/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.components.core.page;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.kwad.components.core.e.d.a;
import com.kwad.components.core.m.b;
import com.kwad.components.core.page.c.d;
import com.kwad.components.core.page.c.e;
import com.kwad.components.core.page.c.f;
import com.kwad.components.core.page.d.a;
import com.kwad.components.core.video.DetailVideoView;
import com.kwad.components.core.video.l;
import com.kwad.components.core.video.m;
import com.kwad.components.core.widget.ComplianceTextView;
import com.kwad.components.core.widget.KsLogoView;
import com.kwad.sdk.R;
import com.kwad.sdk.api.KsVideoPlayConfig;
import com.kwad.sdk.api.core.KsAdSdkDynamicImpl;
import com.kwad.sdk.api.proxy.app.AdWebViewActivity;
import com.kwad.sdk.api.proxy.app.KsFullScreenLandScapeVideoActivity;
import com.kwad.sdk.core.imageloader.KSImageLoader;
import com.kwad.sdk.core.imageloader.core.DisplayImageOptionsCompat;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.listener.SimpleImageLoadingListener;
import com.kwad.sdk.core.imageloader.utils.BlurUtils;
import com.kwad.sdk.core.page.widget.RoundAngleImageView;
import com.kwad.sdk.core.response.model.AdInfo;
import com.kwad.sdk.core.response.model.AdTemplate;
import com.kwad.sdk.mvp.Presenter;
import com.kwad.sdk.service.ServiceProvider;
import com.kwad.sdk.service.c;
import com.kwad.sdk.utils.aq;
import com.kwad.sdk.utils.bg;
import com.kwad.sdk.widget.DownloadProgressBar;
import com.kwad.sdk.widget.KSLinearLayout;
import com.kwad.sdk.widget.KSRelativeLayout;
import java.io.InputStream;
import org.json.JSONObject;

@KsAdSdkDynamicImpl(value=AdWebViewActivity.class)
@Keep
public class DownloadLandPageActivity
extends b<d> {
    private static final String TAG = "DownloadLandPageActivity";
    public static final String KEY_TEMPLATE = "key_template_json";
    public static final String KEY_NEED_CLOSE_REWARD = "key_close_reward";
    private AdInfo mAdInfo;
    private ImageView mVideoBlurBg;
    public static boolean showingAdWebViewLandPage = false;
    private com.kwad.components.core.e.d.c mApkDownloadHelper;
    private KSRelativeLayout mKsadVideoContainer;
    private ImageView mBackIcon;
    private ImageView mCloseIcon;
    private ImageView mVideoCover;
    private l mVideoPlayStateListener;
    private a mPlayModule;
    private boolean mIsRewardLandPage;
    private AdTemplate mAdTemplate;
    private DetailVideoView mDetailVideoView;

    public static void launch(@NonNull Context context, @NonNull AdTemplate adTemplate, boolean bl2) {
        Intent intent = aq.QW() ? AdWebViewActivity.class : KsFullScreenLandScapeVideoActivity.class;
        c.a(intent, DownloadLandPageActivity.class);
        intent = new Intent(context, intent);
        intent.addFlags(0x10000000);
        intent.putExtra(KEY_TEMPLATE, adTemplate.toJson().toString());
        intent.putExtra(KEY_NEED_CLOSE_REWARD, bl2);
        context.startActivity(intent);
    }

    @Override
    public boolean checkIntentData(@Nullable Intent object) {
        try {
            object = this.getIntent().getStringExtra(KEY_TEMPLATE);
            AdTemplate adTemplate = new AdTemplate();
            if (object != null) {
                adTemplate.parseJson(new JSONObject((String)object));
            }
            this.mAdTemplate = adTemplate;
        }
        catch (Throwable throwable) {
            object = throwable;
            com.kwad.sdk.core.d.c.printStackTraceOnly(throwable);
        }
        return this.mAdTemplate != null;
    }

    @Override
    public int getLayoutId() {
        if (aq.QW()) {
            return R.layout.ksad_activity_ad_land_page;
        }
        return R.layout.ksad_activity_land_page_horizontal;
    }

    @Override
    public void initData() {
        showingAdWebViewLandPage = true;
        this.mIsRewardLandPage = this.getIntent().getBooleanExtra(KEY_NEED_CLOSE_REWARD, false);
        this.mAdInfo = com.kwad.sdk.core.response.b.e.el(this.mAdTemplate);
    }

    @Override
    public void initView() {
        Object object = (KSRelativeLayout)this.findViewById(R.id.ksad_root_container);
        this.mKsadVideoContainer = (KSRelativeLayout)this.findViewById(R.id.ksad_video_container);
        this.mDetailVideoView = (DetailVideoView)object.findViewById(R.id.ksad_video_player);
        this.mDetailVideoView.g(true, com.kwad.sdk.core.config.e.Gc());
        this.mVideoBlurBg = (ImageView)object.findViewById(R.id.ksad_video_blur_bg);
        this.mBackIcon = (ImageView)object.findViewById(R.id.ksad_back_icon);
        this.mCloseIcon = (ImageView)object.findViewById(R.id.ksad_right_close);
        this.mVideoCover = (ImageView)object.findViewById(R.id.ksad_video_cover);
        if (this.mAdTemplate.adInfoList.size() > 0) {
            object = com.kwad.sdk.core.response.b.a.X(this.mAdTemplate.adInfoList.get(0));
            this.loadBlurImage((String)object, this.mVideoBlurBg);
        }
        this.mBackIcon.setOnClickListener(new View.OnClickListener(){

            public final void onClick(View object) {
                try {
                    com.kwad.sdk.core.adlog.c.p(DownloadLandPageActivity.this.mAdTemplate, 153);
                    DownloadLandPageActivity.this.finish();
                    return;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    ServiceProvider.reportSdkCaughtException(throwable);
                    return;
                }
            }
        });
        if (com.kwad.sdk.core.response.b.a.bc(com.kwad.sdk.core.response.b.e.el(this.mAdTemplate))) {
            this.setVideoData();
        }
        if (this.mIsRewardLandPage) {
            this.handleCloseBtn();
        }
    }

    private void setVideoData() {
        Object object = this.mKsadVideoContainer.getLayoutParams();
        if (aq.QW()) {
            object.height = com.kwad.sdk.c.a.a.getScreenWidth(this.mContext) * 9 / 16;
            object.width = -1;
        } else {
            object.width = com.kwad.sdk.c.a.a.getScreenWidth(this.mContext) / 2;
            object.height = -1;
        }
        this.mKsadVideoContainer.setLayoutParams((ViewGroup.LayoutParams)object);
        this.mKsadVideoContainer.setVisibility(0);
        object = com.kwad.sdk.core.response.b.a.bu(this.mAdInfo);
        object = object.getUrl();
        KSImageLoader.loadImage(this.mVideoCover, (String)object, this.mAdTemplate);
    }

    @Override
    protected d onCreateCallerContext() {
        d d2 = new d(this);
        new d(this).mAdTemplate = this.mAdTemplate;
        if (com.kwad.sdk.core.response.b.a.bc(com.kwad.sdk.core.response.b.e.el(this.mAdTemplate))) {
            com.kwad.components.core.t.a.aC(this.mContext).aQ(true);
            d2.mPlayModule = this.mPlayModule = new a(this.mAdTemplate, this.mDetailVideoView, new KsVideoPlayConfig.Builder().videoSoundEnable(true).build());
            this.mPlayModule.a(this.getVideoPlayStateListener());
            d2.Rt.add(this.mPlayModule);
        }
        return d2;
    }

    private void loadBlurImage(String string2, ImageView imageView) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        imageView.setVisibility(0);
        KSImageLoader.loadImage(imageView, string2, this.mAdTemplate, new DisplayImageOptionsCompat.Builder().setBlurRadius(50).build(), new SimpleImageLoadingListener(){

            @Override
            public final boolean onDecode(String string2, InputStream inputStream, DecodedResult decodedResult) {
                string2 = BitmapFactory.decodeStream((InputStream)inputStream);
                decodedResult.mBitmap = BlurUtils.stackBlur((Bitmap)string2, 50, false);
                return true;
            }
        });
    }

    @Override
    public Presenter onCreatePresenter() {
        Presenter presenter = new Presenter();
        if (com.kwad.sdk.core.response.b.a.bc(com.kwad.sdk.core.response.b.e.el(this.mAdTemplate))) {
            presenter.a(new e());
        }
        presenter.a(new f(this.getWebViewStateListener(), this.mIsRewardLandPage));
        return presenter;
    }

    @NonNull
    private f.a getWebViewStateListener() {
        return new f.a(){

            @Override
            public final void aP(int n2) {
                if (n2 != 1) {
                    DownloadLandPageActivity.this.initNativeLandPage();
                }
            }
        };
    }

    @Override
    public String getPageName() {
        return TAG;
    }

    @Override
    public void onDestroy() {
        try {
            super.onDestroy();
            showingAdWebViewLandPage = false;
            if (this.mApkDownloadHelper != null) {
                this.mApkDownloadHelper.clear();
            }
            if (this.mPlayModule != null) {
                this.mPlayModule.release();
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            ServiceProvider.reportSdkCaughtException(throwable);
            return;
        }
    }

    private void initNativeLandPage() {
        Object object = this.findViewById(R.id.ksad_ad_land_page_native);
        object.setVisibility(0);
        object = (ComplianceTextView)((Object)this.findViewById(R.id.ksad_compliance_view));
        object.setVisibility(0);
        ((ComplianceTextView)((Object)object)).setAdTemplate(this.mAdTemplate);
        RoundAngleImageView roundAngleImageView = (RoundAngleImageView)((Object)this.findViewById(R.id.ksad_ad_cover));
        Object object2 = (TextView)this.findViewById(R.id.ksad_ad_title);
        TextView textView = (TextView)this.findViewById(R.id.ksad_ad_info);
        KSLinearLayout kSLinearLayout = (KSLinearLayout)this.findViewById(R.id.ksad_info_container);
        KsLogoView ksLogoView = (KsLogoView)((Object)this.findViewById(R.id.ksad_land_page_logo));
        DownloadProgressBar downloadProgressBar = (DownloadProgressBar)((Object)this.findViewById(R.id.ksad_web_download_progress));
        AdInfo adInfo = com.kwad.sdk.core.response.b.e.el(this.mAdTemplate);
        this.setAdTitle((TextView)object2, adInfo);
        textView.setText((CharSequence)adInfo.adBaseInfo.adDescription);
        roundAngleImageView.setRadius(32.0f);
        object2 = com.kwad.sdk.core.response.b.a.co(adInfo);
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            KSImageLoader.loadImage((ImageView)roundAngleImageView, com.kwad.sdk.core.response.b.a.co(adInfo), this.mAdTemplate);
        }
        this.setAdkDownload(downloadProgressBar, adInfo);
        this.buildView((ComplianceTextView)((Object)object), kSLinearLayout, ksLogoView);
    }

    private void setAdTitle(TextView textView, AdInfo adInfo) {
        if (!TextUtils.isEmpty((CharSequence)adInfo.adBaseInfo.appName)) {
            textView.setText((CharSequence)adInfo.adBaseInfo.appName);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)adInfo.advertiserInfo.rawUserName)) {
            textView.setText((CharSequence)adInfo.advertiserInfo.rawUserName);
        }
    }

    private void buildView(ComplianceTextView complianceTextView, KSLinearLayout kSLinearLayout, KsLogoView ksLogoView) {
        if (!com.kwad.sdk.core.response.b.a.bc(com.kwad.sdk.core.response.b.e.el(this.mAdTemplate))) {
            complianceTextView = (FrameLayout.LayoutParams)complianceTextView.getLayoutParams();
            v0.gravity = 80;
            if (!aq.QW()) {
                complianceTextView = (ViewGroup.MarginLayoutParams)ksLogoView.getLayoutParams();
                complianceTextView.setMargins(0, 0, 0, com.kwad.sdk.c.a.a.a(this.mContext, 100.0f));
                ksLogoView.setLayoutParams((ViewGroup.LayoutParams)complianceTextView);
            }
            ksLogoView.setVisibility(0);
            complianceTextView = (FrameLayout.LayoutParams)kSLinearLayout.getLayoutParams();
            ((FrameLayout.LayoutParams)kSLinearLayout.getLayoutParams()).gravity = 17;
            kSLinearLayout.setLayoutParams((ViewGroup.LayoutParams)complianceTextView);
        }
    }

    private void setAdkDownload(final DownloadProgressBar downloadProgressBar, final AdInfo adInfo) {
        if (com.kwad.sdk.core.response.b.a.aF(adInfo)) {
            this.mApkDownloadHelper = new com.kwad.components.core.e.d.c(this.mAdTemplate, new com.kwad.sdk.core.download.a.a(){

                @Override
                public final void onIdle() {
                    downloadProgressBar.setProgress(100.0f);
                    downloadProgressBar.setText(com.kwad.sdk.core.response.b.a.aE(adInfo));
                }

                @Override
                public final void onProgressUpdate(int n2) {
                    downloadProgressBar.setProgress(n2);
                    downloadProgressBar.setText(com.kwad.sdk.core.response.b.a.dF(n2));
                }

                @Override
                public final void onPaused(int n2) {
                    downloadProgressBar.setProgress(n2);
                    downloadProgressBar.setText(com.kwad.sdk.core.response.b.a.dG(n2));
                }

                @Override
                public final void onDownloadFinished() {
                    downloadProgressBar.setProgress(100.0f);
                    downloadProgressBar.setText(com.kwad.sdk.core.response.b.a.cl(DownloadLandPageActivity.this.mAdTemplate));
                }

                @Override
                public final void onInstalled() {
                    downloadProgressBar.setProgress(100.0f);
                    downloadProgressBar.setText(com.kwad.sdk.core.response.b.a.ac(adInfo));
                }

                @Override
                public final void onDownloadFailed() {
                    downloadProgressBar.setProgress(100.0f);
                    downloadProgressBar.setText(com.kwad.sdk.core.response.b.a.aE(adInfo));
                }
            });
            downloadProgressBar.setOnClickListener(new View.OnClickListener(){

                public final void onClick(View object) {
                    com.kwad.sdk.core.adlog.c.p(DownloadLandPageActivity.this.mAdTemplate, 152);
                    object = new a.a((Context)DownloadLandPageActivity.this.getActivity()).aq(true).ar(false).aB(DownloadLandPageActivity.this.mAdTemplate).at(false);
                    DownloadLandPageActivity.this.mApkDownloadHelper.r((a.a)object);
                    if (DownloadLandPageActivity.this.mIsRewardLandPage) {
                        com.kwad.sdk.core.adlog.c.a(DownloadLandPageActivity.this.mAdTemplate, new com.kwad.sdk.core.adlog.c.b(), null);
                    }
                }
            });
        }
    }

    private l getVideoPlayStateListener() {
        this.mVideoPlayStateListener = new m(){

            @Override
            public final void onMediaPlayStart() {
                DownloadLandPageActivity.this.mVideoCover.setVisibility(8);
            }

            @Override
            public final void onMediaPlayError(int n2, int n3) {
            }

            @Override
            public final void onMediaPlayCompleted() {
                DownloadLandPageActivity.this.mVideoCover.setVisibility(0);
            }
        };
        return this.mVideoPlayStateListener;
    }

    private void handleCloseBtn() {
        long l2 = com.kwad.sdk.core.response.b.a.am(this.mAdInfo);
        if (l2 == 0L) {
            this.mCloseIcon.setVisibility(0);
        } else {
            this.mCloseIcon.postDelayed((Runnable)new bg(){

                @Override
                public final void doTask() {
                    if (DownloadLandPageActivity.this.getActivity() != null && !DownloadLandPageActivity.this.getActivity().isFinishing()) {
                        DownloadLandPageActivity.this.mCloseIcon.setVisibility(0);
                        DownloadLandPageActivity.this.mCloseIcon.setAlpha(0.0f);
                        DownloadLandPageActivity.this.mCloseIcon.animate().alpha(1.0f).setDuration(500L).start();
                    }
                }
            }, l2);
        }
        this.mCloseIcon.setOnClickListener(new View.OnClickListener(){

            public final void onClick(View object) {
                try {
                    com.kwad.components.core.t.c.sZ().ta();
                    DownloadLandPageActivity.this.finish();
                    return;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    ServiceProvider.reportSdkCaughtException(throwable);
                    return;
                }
            }
        });
    }
}

