/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.components.core.page.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import com.kwad.sdk.c.a.a;
import com.kwad.sdk.o.m;

public class TextProgressBar
extends ProgressBar {
    @Nullable
    private String VF;
    private Paint mPaint;
    private LinearGradient VG;
    private Matrix VH;
    private boolean VI;
    private boolean VJ = false;
    private boolean VK = true;
    private int VL;
    private int VM;
    private Drawable VN;
    private int VO;
    private Rect VP = new Rect();
    private int[] VQ;
    private int VR;
    private int VS;
    private RectF mRectF;
    private boolean VT;

    public TextProgressBar(Context context) {
        this(context, null);
    }

    public TextProgressBar(Context context, AttributeSet attributeSet) {
        super(m.wrapContextIfNeed(context), attributeSet);
        this.rP();
    }

    public void setProgress(int n2) {
        if (this.VK) {
            super.setProgress(n2);
            return;
        }
        super.setProgress(0);
    }

    protected synchronized void onDraw(Canvas canvas) {
        int n2;
        int n3;
        if (this.VJ) {
            canvas.save();
            canvas.rotate(90.0f);
            canvas.translate(0.0f, (float)(-this.getWidth()));
            super.onDraw(canvas);
            canvas.restore();
        } else {
            super.onDraw(canvas);
        }
        if (!TextUtils.isEmpty((CharSequence)this.VF)) {
            this.mPaint.getTextBounds(this.VF, 0, this.VF.length(), this.VP);
        }
        int n4 = this.getHeight() / 2 - this.VP.centerY();
        if (this.VN != null) {
            int n5 = this.VN.getIntrinsicWidth();
            n3 = this.VN.getIntrinsicHeight();
            n2 = (this.getWidth() - this.VP.width() - n5 - this.VO) / 2;
            this.VN.setBounds(n2, (this.getHeight() - n3) / 2, n2 + n5, (this.getHeight() + n3) / 2);
            this.VN.draw(canvas);
            n2 = n2 + n5 + this.VO;
        } else {
            n2 = this.getWidth() / 2 - this.VP.centerX();
        }
        if (this.VQ != null) {
            float f2;
            float f3 = (float)this.getProgress() * 1.0f / (float)this.getMax() * (float)this.getWidth();
            if (f2 >= (float)n2) {
                if (this.VG == null) {
                    this.VG = new LinearGradient((float)n2, 0.0f, (float)(n2 + this.VP.width()), 0.0f, this.VQ, null, Shader.TileMode.CLAMP);
                    this.VH = new Matrix();
                    this.VG.setLocalMatrix(this.VH);
                }
                this.mPaint.setShader((Shader)this.VG);
                float f4 = (f3 - (float)n2) * 1.0f / (float)this.VP.width();
                this.VH.setScale(f4, 1.0f, (float)n2, 0.0f);
                this.VG.setLocalMatrix(this.VH);
            } else {
                this.mPaint.setShader(null);
            }
            canvas.drawText(this.VF, (float)n2, (float)n4, this.mPaint);
            return;
        }
        if (this.isIndeterminate() || this.VT) {
            float f5 = (float)(this.getWidth() * this.getProgress()) / (float)this.getMax();
            n3 = canvas.save();
            this.mRectF.set(f5, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            canvas.clipRect(this.mRectF);
            this.mPaint.setColor(this.VS);
            if (this.VF != null) {
                canvas.drawText(this.VF, (float)n2, (float)n4, this.mPaint);
            }
            canvas.restoreToCount(n3);
            n3 = canvas.save();
            this.mRectF.set(0.0f, 0.0f, f5, (float)this.getHeight());
            canvas.clipRect(this.mRectF);
            this.mPaint.setColor(this.VR);
            if (this.VF != null) {
                canvas.drawText(this.VF, (float)n2, (float)n4, this.mPaint);
            }
            canvas.restoreToCount(n3);
            return;
        }
        this.mPaint.setColor(this.VR);
        if (this.VF != null) {
            canvas.drawText(this.VF, (float)n2, (float)n4, this.mPaint);
        }
    }

    protected synchronized void onMeasure(int n2, int n3) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null && !TextUtils.isEmpty((CharSequence)this.VF)) {
            Rect rect = new Rect();
            this.mPaint.getTextBounds(this.VF, 0, this.VF.length(), rect);
            if (layoutParams.width == -2) {
                layoutParams.width = rect.width() + this.VL + this.VM;
                n2 = View.MeasureSpec.makeMeasureSpec((int)layoutParams.width, (int)0x40000000);
            }
            if (layoutParams.height == -2) {
                layoutParams.height = rect.height();
                n3 = View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000);
            }
        }
        if (this.VJ) {
            super.onMeasure(n3, n2);
            TextProgressBar textProgressBar = this;
            textProgressBar.setMeasuredDimension(textProgressBar.getMeasuredHeight(), this.getMeasuredWidth());
            return;
        }
        super.onMeasure(n2, n3);
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        if (this.VJ) {
            super.onSizeChanged(n3, n2, n4, n5);
            return;
        }
        super.onSizeChanged(n2, n3, n4, n5);
    }

    private void rP() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(-1);
        this.mPaint.setTextSize((float)a.a(this.getContext(), 12.0f));
        this.VO = a.a(this.getContext(), 2.0f);
        this.mRectF = new RectF();
        this.VR = -1;
        this.VS = -117146;
    }

    private void setProgressText(int n2) {
        n2 = (int)((float)n2 * 1.0f / (float)this.getMax() * 100.0f);
        this.VF = String.valueOf(n2) + "%";
    }

    public final void e(String string2, int n2) {
        this.VF = string2;
        this.VI = true;
        this.setProgress(n2);
        this.invalidate();
    }

    public void setTextDimenSp(int n2) {
        this.mPaint.setTextSize(TypedValue.applyDimension((int)2, (float)n2, (DisplayMetrics)this.getResources().getDisplayMetrics()));
    }

    public void setTextDimen(float f2) {
        this.mPaint.setTextSize(f2);
    }

    public void setTextColor(int n2) {
        this.VT = false;
        this.VR = n2;
        this.postInvalidate();
    }

    public final void setTextColor(@ColorInt int n2, @ColorInt int n3) {
        this.VT = true;
        this.VR = n2;
        this.VS = n3;
        this.postInvalidate();
    }

    public void setVertical(boolean bl2) {
        this.VJ = bl2;
    }

    public void setHasProgress(boolean bl2) {
        this.VK = bl2;
    }

    public void setPadding(int n2, int n3, int n4, int n5) {
        this.VL = n2;
        this.VM = n4;
    }

    public void setDrawableLeft(Drawable drawable2) {
        this.VN = drawable2;
    }

    public void setDrawablePadding(int n2) {
        this.VO = n2;
    }
}

