/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.components.model;

import android.support.annotation.NonNull;
import com.kwad.sdk.core.response.b.a;
import com.kwad.sdk.core.response.b.e;
import com.kwad.sdk.core.response.model.AdTemplate;

public enum FeedType {
    FEED_TYPE_UNKNOWN(0, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_TEXT_IMMERSE(1, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_TEXT_LEFT(2, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_TEXT_RIGHT(3, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_TEXT_ABOVE(4, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_TEXT_BELOW(5, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_TEXT_ABOVE_GROUP(6, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_TEXT_NEW(7, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_CONTENT_11(11, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_CONTENT_12(12, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_CONTENT_13(13, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_THREE_IMAGE(20, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_VERTICAL_ORIGIN(21, FeedDefaultType.FEED_VERTICAL_ORIGIN),
    FEED_TYPE_VERTICAL_NOVEL(21, FeedDefaultType.FEED_VERTICAL_NOVEL_DEFAULT),
    FEED_TYPE_VERTICAL_BISERIAL(21, FeedDefaultType.FEED_VERTICAL_BISERIAL_DEFAULT);

    private int type;
    private FeedDefaultType mFeedDefaultType;

    private FeedType(int n3, FeedDefaultType feedDefaultType) {
        this.type = n3;
        this.mFeedDefaultType = feedDefaultType;
    }

    public final int getType() {
        return this.type;
    }

    public final FeedDefaultType getFeedDefaultType() {
        return this.mFeedDefaultType;
    }

    @NonNull
    public static FeedType fromInt(int n2, int n3) {
        if (FeedType.isH5Type(n2)) {
            return FEED_TYPE_TEXT_NEW;
        }
        for (FeedType feedType : FeedType.values()) {
            if (feedType.type == n2 && !FeedType.isNewVerticalType(n2)) {
                return feedType;
            }
            if (feedType.type != n2 || !FeedType.isNewVerticalType(n2) || feedType.mFeedDefaultType.getDefaultType() != n3) continue;
            return feedType;
        }
        return FEED_TYPE_UNKNOWN;
    }

    private static boolean isH5Type(int n2) {
        return n2 == 7 || n2 == 8 || n2 == 14 || n2 == 15 || n2 == 16 || n2 == 17 || n2 == 18 || n2 == 19 || n2 == 20 || n2 >= 2000;
    }

    public static boolean isNewVerticalType(int n2) {
        return n2 == 21;
    }

    public static boolean checkTypeValid(@NonNull AdTemplate object) {
        int n2 = a.be(e.el(object));
        if (FeedType.isH5Type(object.type)) {
            return true;
        }
        object = FeedType.fromInt(object.type, object.defaultType);
        switch (n2) {
            case 2: {
                return object != FEED_TYPE_UNKNOWN && object != FEED_TYPE_TEXT_ABOVE_GROUP;
            }
            case 3: {
                return object != FEED_TYPE_UNKNOWN && object != FEED_TYPE_VERTICAL_ORIGIN && object != FEED_TYPE_VERTICAL_NOVEL && object != FEED_TYPE_VERTICAL_BISERIAL;
            }
            case 1: 
            case 8: {
                return object == FEED_TYPE_TEXT_ABOVE || object == FEED_TYPE_TEXT_BELOW || object == FEED_TYPE_TEXT_IMMERSE || object == FEED_TYPE_VERTICAL_ORIGIN || object == FEED_TYPE_VERTICAL_NOVEL || object == FEED_TYPE_VERTICAL_BISERIAL;
            }
        }
        return false;
    }

    public static enum FeedDefaultType {
        FEED_VERTICAL_ORIGIN(0),
        FEED_VERTICAL_NOVEL_DEFAULT(1),
        FEED_VERTICAL_BISERIAL_DEFAULT(2);

        private int defaultType;

        private FeedDefaultType(int n3) {
            this.defaultType = n3;
        }

        public final int getDefaultType() {
            return this.defaultType;
        }
    }
}

