/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.components.offline.api.core.api;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import java.io.InputStream;

public interface IImageLoader {
    public void loadImage(ImageView var1, @Nullable String var2);

    public void loadImage(ImageView var1, @Nullable String var2, DisplayImageOptionsCompat var3);

    public void loadImage(ImageView var1, @Nullable String var2, ImageLoadingListener var3);

    public void loadImage(ImageView var1, @Nullable String var2, DisplayImageOptionsCompat var3, ImageLoadingListener var4);

    public void loadImage(@Nullable String var1, DisplayImageOptionsCompat var2, ImageLoadingListener var3);

    public static final class DisplayImageOptionsCompat {
        private final int imageResOnLoading;
        private final int imageResForEmptyUri;
        private final int imageResOnFail;
        private final Drawable imageOnLoading;
        private final Drawable imageForEmptyUri;
        private final Drawable imageOnFail;
        private final boolean resetViewBeforeLoading;
        private final boolean cacheInMemory;
        private final boolean cacheOnDisk;
        private final BitmapFactory.Options decodingOptions;
        private final int delayBeforeLoading;
        private final boolean considerExifParams;
        private final boolean isSyncLoading;
        private final int blurRadius;
        private final int cornerRound;
        private final boolean isCircle;
        private final int strokeColor;
        private final float strokeWidth;
        private final boolean isFrameSequence;
        private final Resources resources;

        private DisplayImageOptionsCompat(Builder builder) {
            this.imageResOnLoading = builder.imageResOnLoading;
            this.imageResForEmptyUri = builder.imageResForEmptyUri;
            this.imageResOnFail = builder.imageResOnFail;
            this.imageOnLoading = builder.imageOnLoading;
            this.imageForEmptyUri = builder.imageForEmptyUri;
            this.imageOnFail = builder.imageOnFail;
            this.resetViewBeforeLoading = builder.resetViewBeforeLoading;
            this.cacheInMemory = builder.cacheInMemory;
            this.cacheOnDisk = builder.cacheOnDisk;
            this.decodingOptions = builder.decodingOptions;
            this.delayBeforeLoading = builder.delayBeforeLoading;
            this.considerExifParams = builder.considerExifParams;
            this.isSyncLoading = builder.isSyncLoading;
            this.blurRadius = builder.blurRadius;
            this.isFrameSequence = builder.isFrameSequence;
            this.cornerRound = builder.cornerRound;
            this.isCircle = builder.isCircle;
            this.strokeColor = builder.strokeColor;
            this.strokeWidth = builder.strokeWidth;
            this.resources = builder.resources;
        }

        public final boolean shouldShowImageOnLoading() {
            return this.imageOnLoading != null || this.imageResOnLoading != 0;
        }

        public final boolean shouldShowImageForEmptyUri() {
            return this.imageForEmptyUri != null || this.imageResForEmptyUri != 0;
        }

        public final boolean shouldShowImageOnFail() {
            return this.imageOnFail != null || this.imageResOnFail != 0;
        }

        public final boolean shouldDelayBeforeLoading() {
            return this.delayBeforeLoading > 0;
        }

        public final Drawable getImageOnLoading() {
            if (this.imageResOnLoading != 0) {
                return this.resources.getDrawable(this.imageResOnLoading);
            }
            return this.imageOnLoading;
        }

        public final Drawable getImageForEmptyUri() {
            if (this.imageResForEmptyUri != 0) {
                return this.resources.getDrawable(this.imageResForEmptyUri);
            }
            return this.imageForEmptyUri;
        }

        public final Drawable getImageOnFail() {
            if (this.imageResOnFail != 0) {
                return this.resources.getDrawable(this.imageResOnFail);
            }
            return this.imageOnFail;
        }

        public final boolean isResetViewBeforeLoading() {
            return this.resetViewBeforeLoading;
        }

        public final boolean isCacheInMemory() {
            return this.cacheInMemory;
        }

        public final boolean isCacheOnDisk() {
            return this.cacheOnDisk;
        }

        public final BitmapFactory.Options getDecodingOptions() {
            return this.decodingOptions;
        }

        public final int getDelayBeforeLoading() {
            return this.delayBeforeLoading;
        }

        public final boolean isConsiderExifParams() {
            return this.considerExifParams;
        }

        public final int getBlurRadius() {
            return this.blurRadius;
        }

        public final boolean isFrameSequence() {
            return this.isFrameSequence;
        }

        public final int getCornerRound() {
            return this.cornerRound;
        }

        public final boolean isCircle() {
            return this.isCircle;
        }

        public final int getStrokeColor() {
            return this.strokeColor;
        }

        public final float getStrokeWidth() {
            return this.strokeWidth;
        }

        public static DisplayImageOptionsCompat createSimple() {
            return new Builder().build();
        }

        public static class Builder {
            private int imageResOnLoading = 0;
            private int imageResForEmptyUri = 0;
            private int imageResOnFail = 0;
            private Drawable imageOnLoading = null;
            private Drawable imageForEmptyUri = null;
            private Drawable imageOnFail = null;
            private boolean resetViewBeforeLoading = false;
            private boolean cacheInMemory = false;
            private boolean cacheOnDisk = false;
            private BitmapFactory.Options decodingOptions = new BitmapFactory.Options();
            private int delayBeforeLoading = 0;
            private boolean considerExifParams = false;
            private boolean isSyncLoading = false;
            private int blurRadius;
            private int cornerRound;
            private boolean isCircle;
            private boolean isFrameSequence;
            private int strokeColor;
            private float strokeWidth;
            private Resources resources;

            @Deprecated
            public Builder showStubImage(int n2) {
                this.imageResOnLoading = n2;
                return this;
            }

            public Builder showImageOnLoading(int n2) {
                this.imageResOnLoading = n2;
                return this;
            }

            public Builder showImageOnLoading(Drawable drawable2) {
                this.imageOnLoading = drawable2;
                return this;
            }

            public Builder showImageForEmptyUri(int n2) {
                this.imageResForEmptyUri = n2;
                return this;
            }

            public Builder showImageForEmptyUri(Drawable drawable2) {
                this.imageForEmptyUri = drawable2;
                return this;
            }

            public Builder showImageOnFail(int n2) {
                this.imageResOnFail = n2;
                return this;
            }

            public Builder showImageOnFail(Drawable drawable2) {
                this.imageOnFail = drawable2;
                return this;
            }

            @Deprecated
            public Builder cacheInMemory() {
                this.cacheInMemory = true;
                return this;
            }

            public Builder cacheInMemory(boolean bl2) {
                this.cacheInMemory = bl2;
                return this;
            }

            @Deprecated
            public Builder cacheOnDisc() {
                return this.cacheOnDisk(true);
            }

            @Deprecated
            public Builder cacheOnDisc(boolean bl2) {
                return this.cacheOnDisk(bl2);
            }

            public Builder cacheOnDisk(boolean bl2) {
                this.cacheOnDisk = bl2;
                return this;
            }

            public Builder bitmapConfig(Bitmap.Config config) {
                if (config == null) {
                    throw new IllegalArgumentException("bitmapConfig can't be null");
                }
                this.decodingOptions.inPreferredConfig = config;
                return this;
            }

            public Builder considerExifParams(boolean bl2) {
                this.considerExifParams = bl2;
                return this;
            }

            public Builder setFrameSequence(boolean bl2) {
                this.isFrameSequence = bl2;
                return this;
            }

            public Builder setBlurRadius(int n2) {
                this.blurRadius = n2;
                return this;
            }

            public Builder setCornerRound(int n2) {
                this.cornerRound = n2;
                return this;
            }

            public Builder setCircle(boolean bl2) {
                this.isCircle = bl2;
                return this;
            }

            public Builder setStrokeColor(int n2) {
                this.strokeColor = n2;
                return this;
            }

            public Builder setStrokeWidth(float f2) {
                if (f2 > 0.0f) {
                    this.strokeWidth = f2;
                    this.isCircle = true;
                }
                return this;
            }

            public Builder setResources(Resources resources) {
                this.resources = resources;
                return this;
            }

            public Builder cloneFrom(DisplayImageOptionsCompat displayImageOptionsCompat) {
                this.imageResOnLoading = displayImageOptionsCompat.imageResOnLoading;
                this.imageResForEmptyUri = displayImageOptionsCompat.imageResForEmptyUri;
                this.imageResOnFail = displayImageOptionsCompat.imageResOnFail;
                this.imageOnLoading = displayImageOptionsCompat.imageOnLoading;
                this.imageForEmptyUri = displayImageOptionsCompat.imageForEmptyUri;
                this.imageOnFail = displayImageOptionsCompat.imageOnFail;
                this.resetViewBeforeLoading = displayImageOptionsCompat.resetViewBeforeLoading;
                this.cacheInMemory = displayImageOptionsCompat.cacheInMemory;
                this.cacheOnDisk = displayImageOptionsCompat.cacheOnDisk;
                this.decodingOptions = displayImageOptionsCompat.decodingOptions;
                this.delayBeforeLoading = displayImageOptionsCompat.delayBeforeLoading;
                this.considerExifParams = displayImageOptionsCompat.considerExifParams;
                this.isSyncLoading = displayImageOptionsCompat.isSyncLoading;
                this.blurRadius = displayImageOptionsCompat.blurRadius;
                this.isFrameSequence = displayImageOptionsCompat.isFrameSequence;
                this.cornerRound = displayImageOptionsCompat.cornerRound;
                this.isCircle = displayImageOptionsCompat.isCircle;
                this.strokeColor = displayImageOptionsCompat.strokeColor;
                this.strokeWidth = displayImageOptionsCompat.strokeWidth;
                this.resources = displayImageOptionsCompat.resources;
                return this;
            }

            public DisplayImageOptionsCompat build() {
                return new DisplayImageOptionsCompat(this);
            }
        }
    }

    public static interface ImageLoadingListener {
        public void onLoadingStarted(String var1, View var2);

        public void onLoadingFailed(String var1, View var2, String var3, Throwable var4);

        public boolean onDecode(String var1, InputStream var2, Bitmap var3);

        public void onLoadingComplete(String var1, View var2, Bitmap var3);

        public void onLoadingCancelled(String var1, View var2);
    }
}

