/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.components.offline.api.core.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.kwad.sdk.widget.j;

public class TkViewRCHelper {
    public float[] radiusArray = new float[8];
    private float mRadius;
    private Path mPath;
    private Paint mPaint;
    private RectF mRectF;
    private boolean mClipBackground;
    @NonNull
    private j.a mCornerConf;

    public TkViewRCHelper() {
        this.mCornerConf = new j.a();
    }

    public TkViewRCHelper(j.a a2) {
        if (a2 == null) {
            this.mCornerConf = new j.a();
            return;
        }
        this.mCornerConf = a2;
    }

    public void initAttrs(Context context, @Nullable AttributeSet attributeSet) {
        this.mPath = new Path();
        this.mPaint = new Paint(1);
        this.mRectF = new RectF();
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }

    public void setRadius(float f2) {
        this.mRadius = f2;
    }

    public void setRadius(float[] fArray) {
        this.radiusArray = fArray;
    }

    public void onSizeChanged(int n2, int n3) {
        this.mRectF.set(0.0f, 0.0f, (float)n2, (float)n3);
    }

    public void beforeDraw(Canvas canvas) {
        if (!this.mClipBackground) {
            return;
        }
        if (Build.VERSION.SDK_INT < 28) {
            canvas.saveLayer(this.mRectF, null, 31);
            return;
        }
        canvas.save();
        canvas.clipPath(this.getPath());
    }

    public void afterDraw(Canvas canvas) {
        if (!this.mClipBackground) {
            return;
        }
        if (Build.VERSION.SDK_INT < 28) {
            canvas.drawPath(this.getPath(), this.mPaint);
        }
        canvas.restore();
    }

    public void beforeDispatchDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT >= 28) {
            canvas.save();
            canvas.clipPath(this.getPath());
            return;
        }
        canvas.saveLayer(this.mRectF, null, 31);
    }

    public void afterDispatchDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT < 28) {
            canvas.drawPath(this.getPath(), this.mPaint);
        }
        canvas.restore();
    }

    private float[] getRadius() {
        this.radiusArray[0] = this.mCornerConf.isLeftTop() ? this.mRadius : 0.0f;
        this.radiusArray[1] = this.mCornerConf.isLeftTop() ? this.mRadius : 0.0f;
        this.radiusArray[2] = this.mCornerConf.isTopRight() ? this.mRadius : 0.0f;
        this.radiusArray[3] = this.mCornerConf.isTopRight() ? this.mRadius : 0.0f;
        this.radiusArray[4] = this.mCornerConf.isRightBottom() ? this.mRadius : 0.0f;
        this.radiusArray[5] = this.mCornerConf.isRightBottom() ? this.mRadius : 0.0f;
        this.radiusArray[6] = this.mCornerConf.isBottomLeft() ? this.mRadius : 0.0f;
        this.radiusArray[7] = this.mCornerConf.isBottomLeft() ? this.mRadius : 0.0f;
        return this.radiusArray;
    }

    @NonNull
    public j.a getCornerConf() {
        return this.mCornerConf;
    }

    private Path getPath() {
        try {
            this.mPath.reset();
        }
        catch (Exception exception) {}
        float[] fArray = this.mRadius == 0.0f ? this.radiusArray : this.getRadius();
        this.mPath.addRoundRect(this.mRectF, fArray, Path.Direction.CW);
        return this.mPath;
    }

    public static class CornerConf {
        private boolean leftTop = true;
        private boolean topRight = true;
        private boolean rightBottom = true;
        private boolean bottomLeft = true;

        public boolean isLeftTop() {
            return this.leftTop;
        }

        public CornerConf setLeftTop(boolean bl2) {
            this.leftTop = bl2;
            return this;
        }

        public boolean isTopRight() {
            return this.topRight;
        }

        public CornerConf setTopRight(boolean bl2) {
            this.topRight = bl2;
            return this;
        }

        public boolean isRightBottom() {
            return this.rightBottom;
        }

        public CornerConf setRightBottom(boolean bl2) {
            this.rightBottom = bl2;
            return this;
        }

        public boolean isBottomLeft() {
            return this.bottomLeft;
        }

        public CornerConf setBottomLeft(boolean bl2) {
            this.bottomLeft = bl2;
            return this;
        }

        public void setAllCorner(boolean bl2) {
            this.leftTop = bl2;
            this.topRight = bl2;
            this.rightBottom = bl2;
            this.bottomLeft = bl2;
        }
    }
}

