/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.components.offline.api.core.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.TimedText;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.kwad.components.offline.api.core.video.mdoel.PlayVideoInfo;
import java.io.FileDescriptor;
import java.util.Map;

public interface IMediaPlayer {
    public void setDisplay(SurfaceHolder var1);

    public void setDataSource(Context var1, Uri var2);

    @TargetApi(value=14)
    public void setDataSource(Context var1, Uri var2, Map<String, String> var3);

    public void setDataSource(FileDescriptor var1);

    public void setDataSource(String var1);

    public void setDataSource(@NonNull PlayVideoInfo var1);

    public String getDataSource();

    public boolean prepareAsync();

    public void start();

    public void stop();

    public void pause();

    public void setScreenOnWhilePlaying(boolean var1);

    public int getVideoWidth();

    public int getVideoHeight();

    public String getCurrentPlayingUrl();

    public boolean isPlaying();

    public void seekTo(long var1);

    public long getCurrentPosition();

    public long getDuration();

    public void release();

    public void reset();

    public void setVolume(float var1, float var2);

    public void setSpeed(float var1);

    public int getAudioSessionId();

    public void setLooping(boolean var1);

    public boolean isLooping();

    public void setSurface(Surface var1);

    public void setAudioStreamType(int var1);

    public void setOnPreparedListener(OnPreparedListener var1);

    public void setOnCompletionListener(OnCompletionListener var1);

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener var1);

    public void setOnSeekCompleteListener(OnSeekCompleteListener var1);

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener var1);

    public void setOnErrorListener(OnErrorListener var1);

    public void setOnInfoListener(OnInfoListener var1);

    public void setOnTimedTextListener(OnTimedTextListener var1);

    public int getMediaPlayerType();

    public static interface OnCompletionListener {
        public void onCompletion(IMediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(IMediaPlayer var1, int var2);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(IMediaPlayer var1);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(IMediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public boolean onError(IMediaPlayer var1, int var2, int var3);
    }

    public static interface OnInfoListener {
        public boolean onInfo(IMediaPlayer var1, int var2, int var3);
    }

    public static interface OnTimedTextListener {
        public void onTimedText(IMediaPlayer var1, TimedText var2);
    }

    public static interface OnPreparedListener {
        public void onPrepared(IMediaPlayer var1);
    }
}

