/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.components.offline.api.core.webview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.kwad.sdk.widget.j;
import java.util.UUID;

public abstract class BaseKsWebView
extends FrameLayout {
    protected WebViewStateListener mWebViewStateListener;
    public WebLoadListener mWebLoadListener;
    public DeepLinkListener mDeeplinkListener;
    protected String mUniqueId;
    private j mViewRCHelper;
    private boolean enableScroll = true;

    public BaseKsWebView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public BaseKsWebView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public BaseKsWebView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context, attributeSet);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this.mViewRCHelper = new j();
        this.mViewRCHelper.initAttrs(context, attributeSet);
    }

    public abstract void setEnableScroll(boolean var1);

    public abstract void scrollTo(int var1, int var2);

    public abstract void scrollBy(int var1, int var2);

    public abstract void setContextUniqId(int var1);

    public abstract void setAdCacheId(int var1, String var2);

    public abstract void setAdTemplateString(String var1);

    public void setWebViewStateListener(WebViewStateListener webViewStateListener) {
        this.mWebViewStateListener = webViewStateListener;
    }

    public void setDeeplinkListener(DeepLinkListener deepLinkListener) {
        this.mDeeplinkListener = deepLinkListener;
    }

    public void setWebLoadListener(WebLoadListener webLoadListener) {
        this.mWebLoadListener = webLoadListener;
    }

    public abstract void setEnableWebCache(boolean var1);

    public abstract void callJs(String var1);

    public abstract void callJs(String var1, String var2);

    public String getUniqueId() {
        if (this.mUniqueId == null) {
            this.mUniqueId = UUID.randomUUID().toString();
        }
        return this.mUniqueId;
    }

    public abstract boolean canGoBack();

    public abstract boolean canGoForward();

    public abstract void goBack();

    public abstract void goForward();

    public abstract void setDeeplinkEnabled(boolean var1);

    public abstract void setInnerDownloadEnabled(boolean var1);

    public abstract void setAllowFileAccess(boolean var1);

    public abstract void setCacheMode(int var1);

    public abstract void setAllowContentAccess(boolean var1);

    public abstract void setJavaScriptEnabled(boolean var1);

    public abstract void setSavePassword(boolean var1);

    public abstract void setTextZoom(int var1);

    public abstract void setAllowFileAccessFromFileURLs(boolean var1);

    public abstract void setAllowUniversalAccessFromFileURLs(boolean var1);

    public abstract void setMixedContentMode(int var1);

    public abstract void setDebugEnabled(boolean var1);

    public abstract void setAcceptThirdPartyCookies(boolean var1);

    public abstract void loadUrl(String var1);

    public abstract void addJavascriptInterface(Object var1, String var2);

    public abstract void destroy();

    protected void onVisibilityChanged(View view, int n2) {
        super.onVisibilityChanged(view, n2);
        if (this.mWebViewStateListener != null) {
            this.mWebViewStateListener.onVisibilityChanged(view, n2);
        }
    }

    public void onWindowFocusChanged(boolean bl2) {
        super.onWindowFocusChanged(bl2);
        if (this.mWebViewStateListener != null) {
            this.mWebViewStateListener.onWindowFocusChanged(bl2);
        }
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        this.mViewRCHelper.onSizeChanged(n2, n3);
        if (this.mWebViewStateListener != null) {
            this.mWebViewStateListener.onSizeChanged(n2, n3, n4, n5);
        }
    }

    protected void onFocusChanged(boolean bl2, int n2, Rect rect) {
        super.onFocusChanged(bl2, n2, rect);
        if (this.mWebViewStateListener != null) {
            this.mWebViewStateListener.onFocusChanged(bl2, n2, rect);
        }
    }

    protected void onScrollChanged(int n2, int n3, int n4, int n5) {
        super.onScrollChanged(n2, n3, n4, n5);
        if (this.mWebViewStateListener != null) {
            this.mWebViewStateListener.onScrollChanged(n2, n3, n4, n5);
        }
    }

    public void setRadius(float f2, float f3, float f4, float f5) {
        float[] fArray = this.getRadius(f2, f3, f4, f5);
        this.mViewRCHelper.setRadius(fArray);
        this.postInvalidate();
    }

    private float[] getRadius(float f2, float f3, float f4, float f5) {
        float[] fArray = new float[8];
        float[] fArray2 = fArray;
        fArray[0] = f2;
        fArray2[1] = f2;
        fArray2[2] = f3;
        fArray2[3] = f3;
        fArray2[4] = f4;
        fArray2[5] = f4;
        fArray2[6] = f5;
        fArray2[7] = f5;
        return fArray2;
    }

    public void draw(Canvas canvas) {
        this.mViewRCHelper.beforeDraw(canvas);
        super.draw(canvas);
        this.mViewRCHelper.afterDraw(canvas);
    }

    protected void dispatchDraw(Canvas canvas) {
        this.mViewRCHelper.beforeDispatchDraw(canvas);
        super.dispatchDraw(canvas);
        this.mViewRCHelper.afterDispatchDraw(canvas);
    }

    public static interface DeepLinkListener {
        public void onSuccess();

        public void onFailed();
    }

    public static interface WebLoadListener {
        public void onReceivedHttpError(int var1, String var2, String var3);

        public void onPageStart();

        public void onPageFinished();

        public boolean shouldOverrideUrlLoading(WebView var1, String var2);

        public void onDownloadStart(String var1, String var2, String var3, String var4, long var5);
    }

    public static interface WebViewStateListener {
        public void onVisibilityChanged(View var1, int var2);

        public void onWindowFocusChanged(boolean var1);

        public void onFocusChanged(boolean var1, int var2, Rect var3);

        public void onSizeChanged(int var1, int var2, int var3, int var4);

        public void onScrollChanged(int var1, int var2, int var3, int var4);
    }
}

