/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.components.offline.api.core.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.kwad.components.offline.api.core.utils.TkViewRCHelper;

public class RcFrameLayout
extends FrameLayout {
    private TkViewRCHelper mViewRCHelper;
    private float mRatio = 0.0f;
    private boolean widthBasedRatio = true;

    public RcFrameLayout(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public RcFrameLayout(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, null);
    }

    public RcFrameLayout(@NonNull Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context, null);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this.mViewRCHelper = new TkViewRCHelper();
        this.mViewRCHelper.initAttrs(context, attributeSet);
    }

    public boolean isWidthBasedRatio() {
        return this.widthBasedRatio;
    }

    public void setWidthBasedRatio(boolean bl2) {
        this.widthBasedRatio = bl2;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        this.mViewRCHelper.onSizeChanged(n2, n3);
    }

    public void draw(Canvas canvas) {
        this.mViewRCHelper.beforeDraw(canvas);
        super.draw(canvas);
        this.mViewRCHelper.afterDraw(canvas);
    }

    protected void dispatchDraw(Canvas canvas) {
        this.mViewRCHelper.beforeDispatchDraw(canvas);
        super.dispatchDraw(canvas);
        this.mViewRCHelper.afterDispatchDraw(canvas);
    }

    protected boolean enableFirstVisible() {
        return true;
    }

    public void setRadius(float f2) {
        this.mViewRCHelper.setRadius(f2);
        this.postInvalidate();
    }

    public void setRadius(float f2, float f3, float f4, float f5) {
        float[] fArray = this.getRadius(f2, f3, f4, f5);
        this.mViewRCHelper.setRadius(fArray);
        this.postInvalidate();
    }

    private float[] getRadius(float f2, float f3, float f4, float f5) {
        float[] fArray = new float[8];
        float[] fArray2 = fArray;
        fArray[0] = f2;
        fArray2[1] = f2;
        fArray2[2] = f3;
        fArray2[3] = f3;
        fArray2[4] = f4;
        fArray2[5] = f4;
        fArray2[6] = f5;
        fArray2[7] = f5;
        return fArray2;
    }

    protected void onMeasure(int n2, int n3) {
        if (this.mRatio != 0.0f) {
            if (this.widthBasedRatio) {
                int n4 = View.MeasureSpec.getSize((int)n2);
                n3 = View.MeasureSpec.makeMeasureSpec((int)((int)((float)n4 * this.mRatio)), (int)0x40000000);
            } else {
                int n5 = View.MeasureSpec.getSize((int)n3);
                n2 = (int)((float)n5 / this.mRatio);
                n2 = View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
            }
        }
        super.onMeasure(n2, n3);
    }

    public void setRatio(float f2) {
        this.mRatio = f2;
    }
}

