/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk;

import android.os.Environment;
import android.text.TextUtils;
import com.kwad.framework.filedownloader.exception.FileDownloadNetworkPolicyException;
import com.kwad.framework.filedownloader.i;
import com.kwad.framework.filedownloader.r;
import com.kwad.sdk.c;
import com.kwad.sdk.crash.utils.h;
import com.kwad.sdk.d;
import com.kwad.sdk.g.a;
import com.kwad.sdk.utils.ao;
import com.kwad.sdk.utils.ax;
import com.kwad.sdk.utils.bc;
import com.kwad.sdk.utils.w;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownloadTask
implements Serializable {
    private static final long serialVersionUID = -7092669850073266500L;
    private transient List<com.kwad.sdk.a> mDownloadListeners = new ArrayList<com.kwad.sdk.a>();
    private String mUrl;
    private int mAllowedNetworkTypes;
    private int mNotificationVisibility;
    private boolean mWakeInstallApk;
    private Serializable mTag;
    private Map<String, String> mRequestHeaders;
    private String mDestinationDir;
    private String mDestinationFileName;
    private boolean mUserPause;
    private boolean mIsCanceled = false;
    protected transient com.kwad.framework.filedownloader.a mBaseDownloadTask;
    public boolean downloadEnablePause = false;
    private boolean notificationRemoved = false;
    public int downloadType;

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.mDownloadListeners = new ArrayList<com.kwad.sdk.a>();
    }

    public DownloadTask(DownloadRequest downloadRequest) {
        this.initDownloadRequestParams(downloadRequest);
        this.instantiateDownloadTask();
        this.initDownloadTaskParams();
    }

    public void submit() {
        try {
            if (!this.mBaseDownloadTask.isRunning()) {
                this.mBaseDownloadTask.start();
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    private void initDownloadRequestParams(DownloadRequest downloadRequest) {
        this.mWakeInstallApk = downloadRequest.mInstallAfterDownload;
        this.mUrl = downloadRequest.mDownloadUrl;
        this.mAllowedNetworkTypes = downloadRequest.mAllowedNetworkTypes;
        this.mNotificationVisibility = downloadRequest.mNotificationVisibility;
        this.mDestinationDir = downloadRequest.mDestinationDir;
        this.mDestinationFileName = downloadRequest.mDestinationFileName;
        this.mRequestHeaders = downloadRequest.mRequestHeaders;
        this.mTag = downloadRequest.mTag;
        this.downloadEnablePause = downloadRequest.isDownloadEnablePause();
    }

    private void initDownloadTaskParams() {
        this.mBaseDownloadTask.f(this.mTag);
        this.mBaseDownloadTask.bf((this.mAllowedNetworkTypes ^ 2) == 0);
        for (Map.Entry<String, String> entry : this.mRequestHeaders.entrySet()) {
            this.mBaseDownloadTask.bl(entry.getKey());
            this.mBaseDownloadTask.u(entry.getKey(), entry.getValue());
        }
    }

    void instantiateDownloadTask() {
        r.xI();
        this.mBaseDownloadTask = r.bm(this.mUrl).bd(true).bq(3).c(TextUtils.isEmpty((CharSequence)this.mDestinationFileName) ? this.mDestinationDir : new File(this.mDestinationDir, this.mDestinationFileName).getPath(), TextUtils.isEmpty((CharSequence)this.mDestinationFileName)).a(new i(){

            @Override
            public final void a(com.kwad.framework.filedownloader.a a2, String string2, boolean bl2, int n2, int n3) {
                DownloadTask.this.onConnected(a2, string2, bl2, n2, n3);
            }

            @Override
            public final void a(com.kwad.framework.filedownloader.a a2) {
                DownloadTask.this.onStarted(a2);
            }

            @Override
            public final void a(com.kwad.framework.filedownloader.a a2, int n2, int n3) {
                DownloadTask.this.onPending(a2, n2, n3);
            }

            @Override
            public final void b(com.kwad.framework.filedownloader.a a2, int n2, int n3) {
                DownloadTask.this.onDownloading(a2, n2, n3);
            }

            @Override
            public final void b(com.kwad.framework.filedownloader.a a2) {
                DownloadTask.this.onBlockCompleted(a2);
            }

            @Override
            public final void c(com.kwad.framework.filedownloader.a a2) {
                DownloadTask.this.onCompleted(a2);
            }

            @Override
            public final void c(com.kwad.framework.filedownloader.a a2, int n2, int n3) {
                DownloadTask.this.onPause(a2, n2, n3);
            }

            @Override
            public final void a(com.kwad.framework.filedownloader.a a2, Throwable throwable) {
                DownloadTask.this.onError(a2, throwable);
            }

            @Override
            public final void d(com.kwad.framework.filedownloader.a a2) {
                DownloadTask.this.onWarn(a2);
            }
        });
    }

    void cancel() {
        try {
            DownloadTask downloadTask = this;
            downloadTask.onCanceled(downloadTask.mBaseDownloadTask);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    void pause() {
        this.mBaseDownloadTask.pause();
        DownloadTask downloadTask = this;
        downloadTask.notifyDownloadProgress(downloadTask.mBaseDownloadTask, true);
    }

    void userPause() {
        this.mUserPause = true;
        this.pause();
    }

    int downLoadProgress() {
        long l2 = this.mBaseDownloadTask.getSmallFileTotalBytes();
        int n2 = 0;
        if (l2 != 0L) {
            n2 = (int)(100.0f * (float)this.mBaseDownloadTask.getSmallFileSoFarBytes() / (float)l2);
        }
        if (n2 == 100 && !w.P(new File(this.mBaseDownloadTask.getTargetFilePath()))) {
            n2 = 0;
        }
        return n2;
    }

    void installApk() {
        try {
            c.AA().g(this);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    void resume(DownloadRequest serializable) {
        if (!ao.isNetworkConnected(c.AA().getContext())) {
            return;
        }
        if (serializable != null) {
            this.initDownloadRequestParams((DownloadRequest)serializable);
            this.initDownloadTaskParams();
        }
        this.mUserPause = false;
        if (!this.mBaseDownloadTask.isRunning()) {
            try {
                if (com.kwad.framework.filedownloader.d.d.bY(this.mBaseDownloadTask.wJ())) {
                    this.mBaseDownloadTask.wB();
                }
                this.submit();
                DownloadTask downloadTask = this;
                downloadTask.onResume(downloadTask.mBaseDownloadTask, this.mBaseDownloadTask.getSmallFileSoFarBytes(), this.mBaseDownloadTask.getSmallFileTotalBytes());
                return;
            }
            catch (Exception exception) {
                serializable = exception;
                exception.printStackTrace();
                return;
            }
        }
        DownloadTask downloadTask = this;
        downloadTask.onResume(downloadTask.mBaseDownloadTask, this.mBaseDownloadTask.getSmallFileSoFarBytes(), this.mBaseDownloadTask.getSmallFileTotalBytes());
    }

    com.kwad.framework.filedownloader.a unwrap() {
        return this.mBaseDownloadTask;
    }

    boolean isUserPause() {
        return this.mUserPause;
    }

    public boolean isRunning() {
        return this.mBaseDownloadTask.isRunning();
    }

    public boolean isPaused() {
        return this.mBaseDownloadTask.wJ() == -2;
    }

    public boolean isError() {
        return this.mBaseDownloadTask.wJ() == -1;
    }

    public boolean isCompleted() {
        return this.mBaseDownloadTask.wJ() == -3;
    }

    public boolean isInvalid() {
        return this.mBaseDownloadTask.wJ() == 0;
    }

    public boolean isCanceled() {
        return this.mIsCanceled;
    }

    public int getId() {
        return this.mBaseDownloadTask.getId();
    }

    public Object getTag() {
        return this.mBaseDownloadTask.getTag();
    }

    public String getTargetFilePath() {
        return this.mBaseDownloadTask.getTargetFilePath();
    }

    public String getFilename() {
        return this.mBaseDownloadTask.getFilename();
    }

    public String getPath() {
        return this.mBaseDownloadTask.getPath();
    }

    public int getSpeed() {
        return this.mBaseDownloadTask.getSpeed();
    }

    public int getSmallFileSoFarBytes() {
        return this.mBaseDownloadTask.getSmallFileSoFarBytes();
    }

    public int getStatus() {
        return this.mBaseDownloadTask.wJ();
    }

    public long getStatusUpdateTime() {
        return this.mBaseDownloadTask.getStatusUpdateTime();
    }

    public int getSmallFileTotalBytes() {
        return this.mBaseDownloadTask.getSmallFileTotalBytes();
    }

    public int getAllowedNetworkTypes() {
        return this.mAllowedNetworkTypes;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getNotificationVisibility() {
        return this.mNotificationVisibility;
    }

    public String getDestinationDir() {
        return this.mDestinationDir;
    }

    private void onDownloading(com.kwad.framework.filedownloader.a iterator, int n2, int n3) {
        try {
            for (com.kwad.sdk.a a2 : this.mDownloadListeners) {
                a2.a(this, n2, n3);
            }
            DownloadTask downloadTask = this;
            downloadTask.notifyDownloadProgress(downloadTask.mBaseDownloadTask, false);
            return;
        }
        catch (Exception exception) {
            iterator = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onLowStorage(com.kwad.framework.filedownloader.a iterator) {
        try {
            for (com.kwad.sdk.a a2 : this.mDownloadListeners) {
                a2.f(this);
            }
            return;
        }
        catch (Exception exception) {
            iterator = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onConnected(com.kwad.framework.filedownloader.a a2, String iterator, boolean bl2, int n2, int n3) {
        long l2 = n3;
        try {
            if (new File(this.mDestinationDir).exists()) {
                l2 = h.getAvailableBytes(this.mDestinationDir);
            } else if (!bc.useStoragePermissionDisable()) {
                l2 = h.getAvailableBytes(Environment.getExternalStorageDirectory().getPath());
            }
        }
        catch (Exception exception) {
            iterator = exception;
            exception.printStackTrace();
        }
        if (l2 < (long)n3) {
            c.AA().cancel(a2.getId());
            this.notifyDownloadCanceled();
            this.onLowStorage(a2);
            return;
        }
        try {
            iterator = this.mDownloadListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            this.notifyDownloadProgress(a2, false);
            return;
        }
        catch (Exception exception) {
            iterator = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onBlockCompleted(com.kwad.framework.filedownloader.a iterator) {
        try {
            iterator = this.mDownloadListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            return;
        }
        catch (Exception exception) {
            iterator = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onCompleted(com.kwad.framework.filedownloader.a a2) {
        try {
            for (com.kwad.sdk.a a3 : this.mDownloadListeners) {
                a3.a(this);
            }
            this.notifyDownloadCompleted(a2);
            if (this.mWakeInstallApk) {
                this.installApk();
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onPending(com.kwad.framework.filedownloader.a iterator, int n2, int n3) {
        try {
            iterator = this.mDownloadListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            this.notifyDownloadPending();
            return;
        }
        catch (Exception exception) {
            iterator = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onStarted(com.kwad.framework.filedownloader.a iterator) {
        try {
            for (com.kwad.sdk.a a2 : this.mDownloadListeners) {
                a2.b(this);
            }
            return;
        }
        catch (Exception exception) {
            iterator = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onWarn(com.kwad.framework.filedownloader.a iterator) {
        try {
            iterator = this.mDownloadListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            return;
        }
        catch (Exception exception) {
            iterator = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onPause(com.kwad.framework.filedownloader.a a2, int n2, int n3) {
        try {
            for (com.kwad.sdk.a a3 : this.mDownloadListeners) {
                a3.c(this);
            }
            this.notifyDownloadProgress(a2, true);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onError(com.kwad.framework.filedownloader.a a2, Throwable throwable) {
        try {
            for (com.kwad.sdk.a a3 : this.mDownloadListeners) {
                a3.a(this, throwable);
            }
            this.notifyDownloadError(a2);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void onCanceled(com.kwad.framework.filedownloader.a a2) {
        try {
            this.mIsCanceled = true;
            for (com.kwad.sdk.a a3 : this.mDownloadListeners) {
                a3.d(this);
            }
            a2.cancel();
            this.notifyDownloadCanceled();
            r.xI().q(this.getId(), this.mBaseDownloadTask.getTargetFilePath());
            this.releaseDownloadTask();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void releaseDownloadTask() {
        this.mBaseDownloadTask.a(null);
        this.clearListener();
    }

    private void onResume(com.kwad.framework.filedownloader.a a2, int n2, int n3) {
        try {
            for (com.kwad.sdk.a a3 : this.mDownloadListeners) {
                a3.e(this);
            }
            this.notifyDownloadProgress(a2, true);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void notifyDownloadPending() {
        if ((this.mNotificationVisibility & 2) != 0) {
            DownloadTask downloadTask = this;
            downloadTask.notify(downloadTask, new a<d>(){

                private void a(d d2) {
                    d2.i(DownloadTask.this);
                }

                @Override
                public final /* synthetic */ void accept(Object object) {
                    this.a((d)object);
                }
            });
        }
    }

    private void notifyDownloadCompleted(com.kwad.framework.filedownloader.a a2) {
        if ((this.mNotificationVisibility & 2) != 0) {
            DownloadTask downloadTask = this;
            downloadTask.notify(downloadTask, new a<d>(){

                private void a(d d2) {
                    d2.k(DownloadTask.this);
                }

                @Override
                public final /* synthetic */ void accept(Object object) {
                    this.a((d)object);
                }
            });
        }
    }

    private void notifyDownloadProgress(com.kwad.framework.filedownloader.a a2, final boolean bl2) {
        if (a2.getSmallFileTotalBytes() == 0 && a2.getSmallFileSoFarBytes() == 0) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)a2.getFilename())) {
            return;
        }
        if ((this.mNotificationVisibility & 1) != 0) {
            DownloadTask downloadTask = this;
            downloadTask.notify(downloadTask, new a<d>(){

                private void a(d d2) {
                    d2.a(DownloadTask.this, bl2);
                }

                @Override
                public final /* synthetic */ void accept(Object object) {
                    this.a((d)object);
                }
            });
        }
    }

    private void notifyDownloadError(com.kwad.framework.filedownloader.a a2) {
        if ((this.mNotificationVisibility & 1) != 0) {
            DownloadTask downloadTask = this;
            downloadTask.notify(downloadTask, new a<d>(){

                private void a(d d2) {
                    d2.j(DownloadTask.this);
                }

                @Override
                public final /* synthetic */ void accept(Object object) {
                    this.a((d)object);
                }
            });
        }
    }

    private void notify(DownloadTask downloadTask, a<d> a2) {
        d d2 = c.AA().AC();
        if (d2 == null) {
            return;
        }
        if (downloadTask.isCanceled()) {
            d2.co(downloadTask.getId());
            return;
        }
        a2.accept(d2);
    }

    private void notifyDownloadCanceled() {
        d d2 = c.AA().AC();
        if (d2 == null) {
            return;
        }
        d2.co(this.getId());
    }

    public void addListener(com.kwad.sdk.a a2) {
        if (a2 != null && !this.mDownloadListeners.contains(a2)) {
            this.mDownloadListeners.add(a2);
        }
    }

    public void removeListener(com.kwad.sdk.a a2) {
        if (a2 != null) {
            this.mDownloadListeners.remove(a2);
        }
    }

    public void clearListener() {
        this.mDownloadListeners.clear();
    }

    public boolean isErrorBecauseWifiRequired() {
        return this.mBaseDownloadTask.wQ() && this.isError() && this.mBaseDownloadTask.wL() instanceof FileDownloadNetworkPolicyException;
    }

    public boolean isNotificationRemoved() {
        return this.notificationRemoved;
    }

    public void setNotificationRemoved(boolean bl2) {
        this.notificationRemoved = bl2;
    }

    public void setAllowedNetworkTypes(int n2) {
        this.mAllowedNetworkTypes = n2;
        this.mBaseDownloadTask.bf((this.mAllowedNetworkTypes ^ 2) == 0);
    }

    public static class DownloadRequest
    implements Serializable {
        private static final long serialVersionUID = -3638290207248829674L;
        private final Map<String, String> mRequestHeaders = new HashMap<String, String>();
        private String mDownloadUrl;
        private String mDestinationDir;
        private String mDestinationFileName;
        private Serializable mTag;
        private boolean mInstallAfterDownload = true;
        @Deprecated
        private boolean mIsPhotoAdDownloadRequest = false;
        private int mAllowedNetworkTypes = 3;
        private int mNotificationVisibility = 0;
        public boolean downloadEnablePause = false;

        public DownloadRequest(String string2) {
            File file = c.AA().AB();
            this.mDestinationDir = file.getPath();
            this.mDownloadUrl = string2;
            string2 = ao.de(c.AA().getContext());
            if (string2 != null && string2.getType() == 0) {
                this.mAllowedNetworkTypes = 3;
                return;
            }
            this.mAllowedNetworkTypes = 2;
        }

        public String getDownloadUrl() {
            return this.mDownloadUrl;
        }

        public String getDestinationDir() {
            return this.mDestinationDir;
        }

        public String getDestinationFileName() {
            return this.mDestinationFileName;
        }

        public DownloadRequest setDestinationDir(String string2) {
            this.mDestinationDir = string2;
            return this;
        }

        public DownloadRequest setDestinationFileName(String string2) {
            this.mDestinationFileName = string2;
            return this;
        }

        public DownloadRequest setTag(Serializable serializable) {
            this.mTag = serializable;
            return this;
        }

        public Serializable getTag() {
            return this.mTag;
        }

        public boolean isPhotoAdDownloadRequest() {
            return this.mIsPhotoAdDownloadRequest;
        }

        public void setIsPhotoAdDownloadRequest() {
            this.mIsPhotoAdDownloadRequest = true;
        }

        public DownloadRequest addRequestHeader(String string2, String string3) {
            ax.hh(string2);
            if (string2.contains(":")) {
                throw new IllegalArgumentException("header may not contain ':'");
            }
            if (string3 == null) {
                string3 = "";
            }
            this.mRequestHeaders.put(string2, string3);
            return this;
        }

        public DownloadRequest setInstallAfterDownload(boolean bl2) {
            this.mInstallAfterDownload = bl2;
            return this;
        }

        public DownloadRequest setNotificationVisibility(int n2) {
            this.mNotificationVisibility = n2;
            return this;
        }

        public DownloadRequest setAllowedNetworkTypes(int n2) {
            this.mAllowedNetworkTypes = n2;
            return this;
        }

        public int getAllowedNetworkTypes() {
            return this.mAllowedNetworkTypes;
        }

        public boolean isDownloadEnablePause() {
            return this.downloadEnablePause;
        }

        public void setDownloadEnablePause(boolean bl2) {
            this.downloadEnablePause = bl2;
        }
    }
}

