/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api;

import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.util.Log;
import com.kwad.sdk.api.KsLoadManager;
import com.kwad.sdk.api.SdkConfig;
import com.kwad.sdk.api.c;
import com.kwad.sdk.api.core.IKsAdSDK;
import com.kwad.sdk.api.core.KsAdSdkApi;
import com.kwad.sdk.api.loader.Loader;
import com.kwad.sdk.api.loader.Wrapper;
import com.kwad.sdk.api.loader.aa;
import com.kwad.sdk.api.loader.b;
import com.kwad.sdk.api.loader.e;
import com.kwad.sdk.api.loader.r;
import com.kwad.sdk.api.proxy.app.AdSdkFileProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.atomic.AtomicBoolean;

@KsAdSdkApi
@Keep
public class KsAdSDK {
    @Keep
    private static IKsAdSDK sSdk = null;
    public static final AtomicBoolean sHasInit = new AtomicBoolean(false);
    private static final AtomicBoolean sHasRest = new AtomicBoolean(false);
    private static String sAppTag;
    private static Context mOriginalAppContext;
    private static final int INIT_ERROR_IKSADSDK_NULL_CODE = -1;
    private static final String INIT_ERROR_IKSADSDK_NULL_MSG = "IKsAdSDK\u5bf9\u8c61\u521b\u5efa\u5f02\u5e38";

    public static void setThemeMode(int n2) {
        if (sSdk != null) {
            sSdk.setThemeMode(n2);
        }
    }

    public static void setLoadingLottieAnimation(boolean bl2, @RawRes int n2) {
        if (sSdk != null) {
            sSdk.setLoadingLottieAnimation(bl2, n2);
        }
    }

    public static void setLoadingLottieAnimationColor(boolean bl2, @ColorInt int n2) {
        if (sSdk != null) {
            sSdk.setLoadingLottieAnimationColor(bl2, n2);
        }
    }

    @KsAdSdkApi
    @Keep
    public static synchronized boolean init(Context context, SdkConfig sdkConfig) {
        try {
            long l2 = SystemClock.elapsedRealtime();
            if (context == null || sdkConfig == null) {
                throw new RuntimeException("init context or config is null");
            }
            mOriginalAppContext = context;
            try {
                Object object = e.aV(context);
                if (object == null) {
                    throw new RuntimeException("init wrapperApp Exception");
                }
                context = object;
                object = r.Dp();
                if (object != null) {
                    object.holdSdkConfig(sdkConfig);
                }
                if ((sSdk = Loader.get().init(context, KsAdSDK.class.getClassLoader())) == null) {
                    KsAdSDK.notifyInitFail(sdkConfig, -1, INIT_ERROR_IKSADSDK_NULL_MSG);
                }
                sSdk.setApiVersion("4.6.30.1");
                sSdk.setApiVersionCode(4063001);
                sSdk.setLaunchTime(AdSdkFileProvider.sLaunchTime);
                object = Wrapper.wrapContextIfNeed(context);
                if (object == null) {
                    throw new RuntimeException("init wrapContextIfNeed Exception");
                }
                try {
                    sSdk.setInitStartTime(l2);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    c.m(throwable);
                }
                sSdk.init((Context)object, sdkConfig);
                sSdk.setAppTag(sAppTag);
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                KsAdSDK.revertDynamic(throwable, context, sdkConfig);
                return false;
            }
            aa.a(context, sSdk);
            b.a(context, sdkConfig);
            c.ow();
            sHasInit.set(sSdk != null);
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            throwable.printStackTrace();
        }
        return sHasInit.get();
    }

    @KsAdSdkApi
    @Keep
    public static synchronized void start() {
        try {
            sSdk.start();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            c.m(throwable);
            return;
        }
    }

    public static boolean haseInit() {
        return sHasInit.get();
    }

    private static void revertDynamic(Throwable throwable, Context context, SdkConfig sdkConfig) {
        if (sHasRest.get()) {
            return;
        }
        sHasRest.set(true);
        aa.be(context);
        Loader.get().rest();
        Log.d((String)"KSAdSDK", (String)("init appId after reset:" + sdkConfig.appId));
        KsAdSDK.init(context, sdkConfig);
        c.m(throwable);
    }

    @KsAdSdkApi
    @Keep
    public static boolean isDebugLogEnable() {
        if (sSdk != null) {
            return sSdk.isDebugLogEnable();
        }
        return false;
    }

    @KsAdSdkApi
    @Keep
    public static String getAppId() {
        if (sSdk != null) {
            return sSdk.getAppId();
        }
        return null;
    }

    @KsAdSdkApi
    @Keep
    public static String getAppName() {
        if (sSdk != null) {
            return sSdk.getAppName();
        }
        return null;
    }

    @KsAdSdkApi
    @Nullable
    @Keep
    public static Context getContext() {
        return mOriginalAppContext;
    }

    @KsAdSdkApi
    @Keep
    public static synchronized KsLoadManager getLoadManager() {
        if (sSdk != null && sHasInit.get()) {
            return sSdk.getAdManager();
        }
        Log.e((String)"KsAdSDK", (String)"please init sdk before getLoadManager");
        return new com.kwad.sdk.api.b();
    }

    @KsAdSdkApi
    @Keep
    public static void unInit() {
        if (sSdk != null) {
            sSdk.unInit();
        }
        sSdk = null;
    }

    @KsAdSdkApi
    @Keep
    public static String getSDKVersion() {
        return "4.6.30.1";
    }

    @KsAdSdkApi
    @Keep
    public static String getSDKVersion(int n2) {
        switch (n2) {
            case 1: {
                return "4.6.30.1";
            }
            case 2: {
                return "";
            }
            case 3: {
                return "";
            }
            case 4: {
                return "";
            }
            case 5: {
                return "";
            }
        }
        return "";
    }

    @KsAdSdkApi
    @Keep
    public static int getSDKType() {
        return 1;
    }

    @KsAdSdkApi
    @Keep
    public static void deleteCache() {
        if (sSdk != null) {
            sSdk.deleteCache();
        }
    }

    @KsAdSdkApi
    @Keep
    public static String getDid() {
        if (sSdk != null) {
            return sSdk.getDid();
        }
        return null;
    }

    @KsAdSdkApi
    @Keep
    public static void setAppTag(String string) {
        if (sSdk != null) {
            sSdk.setAppTag(string);
            return;
        }
        sAppTag = string;
    }

    @KsAdSdkApi
    @Keep
    public static void resumeCurrentPlayer() {
        if (sSdk != null) {
            sSdk.resumeCurrentPlayer();
        }
    }

    @KsAdSdkApi
    @Keep
    public static void pauseCurrentPlayer() {
        if (sSdk != null) {
            sSdk.pauseCurrentPlayer();
        }
    }

    @KsAdSdkApi
    @Keep
    public static void setPersonalRecommend(boolean bl2) {
        if (sSdk != null) {
            sSdk.setPersonalRecommend(bl2);
        }
    }

    @KsAdSdkApi
    @Keep
    public static void setProgrammaticRecommend(boolean bl2) {
        if (sSdk != null) {
            sSdk.setProgrammaticRecommend(bl2);
        }
    }

    @KsAdSdkApi
    @Keep
    public static void setAdxEnable(boolean bl2) {
        if (sSdk != null) {
            sSdk.setAdxEnable(bl2);
        }
    }

    private static void notifyInitFail(SdkConfig object, int n2, String string) {
        try {
            if (object != null && (object = ((SdkConfig)object).ksInitCallback) != null) {
                object.onFail(n2, string);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Keep
    public static @interface SdkType {
        public static final int AD = 1;
        public static final int CT = 2;
        public static final int EC = 3;
        public static final int CT_PURE = 4;
        public static final int CAR = 5;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Keep
    public static @interface KsThemeModeType {
        public static final int NORMAL = 0;
        public static final int NIGHT = 1;
    }
}

