/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.core;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

public class ComponentDestroyer {
    private static final String TAG = "ComponentDestroyer";

    public static void destroyFragment(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        View view = fragment.getView();
        ComponentDestroyer.destroyWebViewInTree(fragment.getView());
        ComponentDestroyer.fixInputMethodManagerLeak(fragment.getContext(), view);
    }

    public static void destroyFragment(Context context, View view) {
        ComponentDestroyer.destroyWebViewInTree(view);
        ComponentDestroyer.fixInputMethodManagerLeak(context, view);
    }

    public static void destroyActivity(Activity activity) {
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        ComponentDestroyer.destroyActivity((Context)activity2, activity2.getWindow());
    }

    public static void destroyActivity(Context context, Window window) {
        if (window == null) {
            return;
        }
        window = window.getDecorView();
        ComponentDestroyer.destroyWebViewInTree((View)window);
        ComponentDestroyer.fixInputMethodManagerLeak(context, (View)window);
    }

    private static synchronized void destroyWebViewInTree(View view) {
        if (view == null) {
            return;
        }
        if (view instanceof WebView) {
            try {
                ((WebView)view).destroy();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        view = (ViewGroup)view;
        int n2 = view.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view2 = view.getChildAt(i2);
            ComponentDestroyer.destroyWebViewInTree(view2);
        }
    }

    private static void fixInputMethodManagerLeak(Context context, View view) {
        if (context == null || view == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return;
        }
        view = (InputMethodManager)context.getSystemService("input_method");
        if (view == null) {
            return;
        }
        Object object = new String[]{"mCurRootView", "mServedView", "mNextServedView"};
        String[] stringArray = object;
        for (int i2 = 0; i2 < 3; ++i2) {
            object = stringArray[i2];
            try {
                Object object2;
                object = view.getClass().getDeclaredField((String)object);
                if (!((AccessibleObject)object).isAccessible()) {
                    ((Field)object).setAccessible(true);
                }
                if (!((object2 = ((Field)object).get(view)) instanceof View)) continue;
                object2 = (View)object2;
                boolean bl2 = context.equals(object2 = object2.getContext());
                if (bl2) {
                    ((Field)object).set(view, null);
                    continue;
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
            }
        }
    }
}

