/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kwad.sdk.api.core.KSLifecycleListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class KSLifecycleObserver {
    private static volatile KSLifecycleObserver sKSLifecycleObserver;
    private Application mApplication;
    private boolean mIsInBackground = true;
    private Set<Integer> mStartedActivitySet = new HashSet<Integer>();
    private WeakReference<Activity> currentActivity;
    private final List<KSLifecycleListener> mListeners = new CopyOnWriteArrayList<KSLifecycleListener>();
    private boolean mHasInit = false;
    private boolean mEnable = false;

    private KSLifecycleObserver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KSLifecycleObserver getInstance() {
        if (sKSLifecycleObserver != null) return sKSLifecycleObserver;
        Class<KSLifecycleObserver> clazz = KSLifecycleObserver.class;
        synchronized (KSLifecycleObserver.class) {
            if (sKSLifecycleObserver != null) return sKSLifecycleObserver;
            sKSLifecycleObserver = new KSLifecycleObserver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sKSLifecycleObserver;
        }
    }

    public void init(@NonNull Context object) {
        try {
            if (!(object instanceof Application) || this.mHasInit) {
                return;
            }
            this.mHasInit = true;
            this.mApplication = (Application)object;
            this.mApplication.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
                    KSLifecycleObserver.this.mEnable = true;
                    try {
                        for (KSLifecycleListener kSLifecycleListener : KSLifecycleObserver.this.mListeners) {
                            kSLifecycleListener.onActivityCreated(activity, bundle);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throwable.printStackTrace();
                        return;
                    }
                }

                public void onActivityStarted(@NonNull Activity object) {
                    try {
                        KSLifecycleObserver.this.mStartedActivitySet.add(object.hashCode());
                        if (KSLifecycleObserver.this.mStartedActivitySet.size() == 1) {
                            KSLifecycleObserver.this.onAppBackToForeground();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throwable.printStackTrace();
                        return;
                    }
                }

                public void onActivityResumed(@NonNull Activity activity) {
                    try {
                        KSLifecycleObserver.this.currentActivity = new WeakReference<Activity>(activity);
                        for (KSLifecycleListener kSLifecycleListener : KSLifecycleObserver.this.mListeners) {
                            kSLifecycleListener.onActivityResumed(activity);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throwable.printStackTrace();
                        return;
                    }
                }

                public void onActivityPaused(@NonNull Activity activity) {
                    try {
                        if (KSLifecycleObserver.this.currentActivity != null && KSLifecycleObserver.this.currentActivity.get() != null && ((Activity)KSLifecycleObserver.this.currentActivity.get()).equals(activity)) {
                            KSLifecycleObserver.this.currentActivity = null;
                        }
                        for (KSLifecycleListener kSLifecycleListener : KSLifecycleObserver.this.mListeners) {
                            kSLifecycleListener.onActivityPaused(activity);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throwable.printStackTrace();
                        return;
                    }
                }

                public void onActivityStopped(@NonNull Activity activity) {
                    try {
                        for (KSLifecycleListener kSLifecycleListener : KSLifecycleObserver.this.mListeners) {
                            kSLifecycleListener.onActivityStopped(activity);
                        }
                        KSLifecycleObserver.this.mStartedActivitySet.remove(activity.hashCode());
                        if (KSLifecycleObserver.this.mStartedActivitySet.size() == 0) {
                            KSLifecycleObserver.this.onAppGoToBackground();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throwable.printStackTrace();
                        return;
                    }
                }

                public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {
                }

                public void onActivityDestroyed(@NonNull Activity activity) {
                    try {
                        for (KSLifecycleListener kSLifecycleListener : KSLifecycleObserver.this.mListeners) {
                            kSLifecycleListener.onActivityDestroyed(activity);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throwable.printStackTrace();
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    @Keep
    public Application getApplication() {
        return this.mApplication;
    }

    @Keep
    public Activity getCurrentActivity() {
        if (this.currentActivity == null) {
            return null;
        }
        return (Activity)this.currentActivity.get();
    }

    @Keep
    public boolean isAppOnForeground() {
        return !this.mIsInBackground;
    }

    @Keep
    public boolean isEnable() {
        return this.mEnable;
    }

    @Keep
    public void registerLifecycleListener(KSLifecycleListener kSLifecycleListener) {
        this.mListeners.add(kSLifecycleListener);
    }

    @Keep
    public void unRegisterLifecycleListener(KSLifecycleListener kSLifecycleListener) {
        this.mListeners.remove(kSLifecycleListener);
    }

    private void onAppBackToForeground() {
        try {
            this.mIsInBackground = false;
            for (KSLifecycleListener kSLifecycleListener : this.mListeners) {
                kSLifecycleListener.onBackToForeground();
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    private void onAppGoToBackground() {
        try {
            this.mIsInBackground = true;
            for (KSLifecycleListener kSLifecycleListener : this.mListeners) {
                kSLifecycleListener.onBackToBackground();
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }
}

