/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.core;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Keep;
import android.widget.RemoteViews;
import com.kwad.sdk.api.core.ApiResUtil;
import com.kwad.sdk.api.core.ICompletedRemoteView;
import com.kwad.sdk.api.core.IProgressRemoteView;
import com.kwad.sdk.api.core.KsAdSdkDynamicApi;
import com.kwad.sdk.api.core.ResContext;

@KsAdSdkDynamicApi
@Keep
public class RemoteViewBuilder {
    private static Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int n2 = !drawable.getBounds().isEmpty() ? drawable.getBounds().width() : drawable.getIntrinsicWidth();
        int n3 = !drawable.getBounds().isEmpty() ? drawable.getBounds().height() : drawable.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)(n2 <= 0 ? 1 : n2), (int)(n3 <= 0 ? 1 : n3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    private static Bitmap getBitmap(Context context, int n2) {
        context = context.getResources().getDrawable(n2);
        return RemoteViewBuilder.drawableToBitmap((Drawable)context);
    }

    @Deprecated
    @KsAdSdkDynamicApi
    @Keep
    public static IProgressRemoteView createProgressView(Context context) {
        return new ProgressRemoteViewImpl(context, 0, false);
    }

    @KsAdSdkDynamicApi
    @Keep
    public static IProgressRemoteView createProgressView(Context context, int n2, boolean bl2) {
        return new ProgressRemoteViewImpl(context, n2, bl2);
    }

    @KsAdSdkDynamicApi
    @Keep
    public static ICompletedRemoteView createCompletedView(Context context) {
        return new CompletedRemoteViewImpl(context);
    }

    static class CompletedRemoteViewImpl
    implements ICompletedRemoteView {
        private final RemoteViews mRemoteViews;
        private final Context mContext;
        private final Context mOriginContext;

        private CompletedRemoteViewImpl(Context context) {
            this.mContext = context;
            this.mOriginContext = context instanceof ResContext ? ((ResContext)context).getDelegatedContext() : context;
            this.mRemoteViews = new RemoteViews(this.mOriginContext.getPackageName(), ApiResUtil.getLayoutId(this.mOriginContext, "ksad_notification_download_completed"));
        }

        @Override
        public void setIcon(Bitmap bitmap) {
            this.mRemoteViews.setImageViewBitmap(ApiResUtil.getId(this.mOriginContext, "ksad_download_icon"), bitmap);
        }

        @Override
        public void setIcon(int n2) {
            CompletedRemoteViewImpl completedRemoteViewImpl = this;
            completedRemoteViewImpl.setIcon(RemoteViewBuilder.getBitmap(completedRemoteViewImpl.mContext, n2));
        }

        @Override
        public void setName(String string) {
            this.mRemoteViews.setTextViewText(ApiResUtil.getId(this.mOriginContext, "ksad_download_name"), (CharSequence)string);
        }

        @Override
        public void setStatus(String string) {
            this.mRemoteViews.setTextViewText(ApiResUtil.getId(this.mOriginContext, "ksad_download_status"), (CharSequence)string);
        }

        @Override
        public void setSize(String string) {
            this.mRemoteViews.setTextViewText(ApiResUtil.getId(this.mOriginContext, "ksad_download_size"), (CharSequence)string);
        }

        @Override
        public void setInstallText(String string) {
            this.mRemoteViews.setTextViewText(ApiResUtil.getId(this.mOriginContext, "ksad_download_install"), (CharSequence)string);
        }

        @Override
        public RemoteViews build() {
            return this.mRemoteViews;
        }
    }

    static class ProgressRemoteViewImpl
    implements IProgressRemoteView {
        private static final String ACTION_CLICK_CONTROL_BTN = "com.ksad.action.ACTION_NOTIFICATION_CLICK_CONTROL_BTN";
        private static final String KEY_TASKID = "taskId";
        private final RemoteViews mRemoteViews;
        private final Context mContext;
        private final Context mOriginContext;
        private int btnControlId = -1;
        private int btnTextColorChecked = Color.parseColor((String)"#FFFFFFFF");
        private int btnTextColorUnchecked = Color.parseColor((String)"#FF222222");
        private int downloadTaskId = 0;

        private ProgressRemoteViewImpl(Context object, int n2, boolean bl2) {
            this.mContext = object;
            this.downloadTaskId = n2;
            this.mOriginContext = object instanceof ResContext ? ((ResContext)object).getDelegatedContext() : object;
            object = bl2 ? "ksad_notification_download_progress_with_control" : "ksad_notification_download_progress_without_control";
            this.mRemoteViews = new RemoteViews(this.mOriginContext.getPackageName(), ApiResUtil.getLayoutId(this.mOriginContext, (String)object));
            this.btnControlId = ApiResUtil.getId(this.mOriginContext, "ksad_download_control_btn");
            this.initViews();
            this.setControlBtnPaused(false);
        }

        private void initViews() {
            Intent intent = new Intent(ACTION_CLICK_CONTROL_BTN);
            intent.putExtra(KEY_TASKID, this.downloadTaskId);
            intent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)this.mContext, (int)this.downloadTaskId, (Intent)intent, (int)0xC000000) : PendingIntent.getBroadcast((Context)this.mContext, (int)this.downloadTaskId, (Intent)intent, (int)0x8000000);
            this.mRemoteViews.setOnClickPendingIntent(this.btnControlId, (PendingIntent)intent);
        }

        @Override
        public void setIcon(Bitmap bitmap) {
            this.mRemoteViews.setImageViewBitmap(ApiResUtil.getId(this.mOriginContext, "ksad_download_icon"), bitmap);
        }

        @Override
        public void setIcon(int n2) {
            ProgressRemoteViewImpl progressRemoteViewImpl = this;
            progressRemoteViewImpl.setIcon(RemoteViewBuilder.getBitmap(progressRemoteViewImpl.mContext, n2));
        }

        @Override
        public void setName(String string) {
            this.mRemoteViews.setTextViewText(ApiResUtil.getId(this.mOriginContext, "ksad_download_name"), (CharSequence)string);
        }

        @Override
        public void setStatus(String string) {
            this.mRemoteViews.setTextViewText(ApiResUtil.getId(this.mOriginContext, "ksad_download_status"), (CharSequence)string);
        }

        @Override
        public void setProgress(int n2, int n3, boolean bl2) {
            this.mRemoteViews.setProgressBar(ApiResUtil.getId(this.mOriginContext, "ksad_download_progress"), n2, n3, bl2);
        }

        @Override
        public void setSize(String string) {
            this.mRemoteViews.setTextViewText(ApiResUtil.getId(this.mOriginContext, "ksad_download_size"), (CharSequence)string);
        }

        @Override
        public void setPercentNum(String string) {
            this.mRemoteViews.setTextViewText(ApiResUtil.getId(this.mOriginContext, "ksad_download_percent_num"), (CharSequence)string);
        }

        @Override
        public void setControlBtnPaused(boolean bl2) {
            if (this.mRemoteViews == null) {
                return;
            }
            String n2 = bl2 ? "\u7ee7\u7eed" : "\u6682\u505c";
            this.mRemoteViews.setTextViewText(this.btnControlId, (CharSequence)n2);
            int n3 = bl2 ? this.btnTextColorChecked : this.btnTextColorUnchecked;
            this.mRemoteViews.setTextColor(this.btnControlId, n3);
            int n4 = bl2 ? ApiResUtil.getDrawableId(this.mOriginContext, "ksad_notification_control_btn_bg_checked") : ApiResUtil.getDrawableId(this.mOriginContext, "ksad_notification_control_btn_bg_unchecked");
            this.mRemoteViews.setImageViewResource(ApiResUtil.getId(this.mOriginContext, "ksad_download_control_bg_image"), n4);
        }

        @Override
        public RemoteViews build() {
            return this.mRemoteViews;
        }
    }
}

