/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.core;

import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TLSConnectionUtils {
    public static void wrapHttpURLConnection(URLConnection uRLConnection) {
        if (!(uRLConnection instanceof HttpsURLConnection)) {
            return;
        }
        uRLConnection = (HttpsURLConnection)uRLConnection;
        SSLSocketFactory sSLSocketFactory = TLSConnectionUtils.systemDefaultSslSocketFactory(TLSConnectionUtils.systemDefaultTrustManager());
        if (sSLSocketFactory != null) {
            ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(sSLSocketFactory);
        }
    }

    private static SSLSocketFactory systemDefaultSslSocketFactory(X509TrustManager x509TrustManager) {
        if (x509TrustManager == null) {
            return null;
        }
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{x509TrustManager}, null);
            return sSLContext.getSocketFactory();
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
    }

    private static X509TrustManager systemDefaultTrustManager() {
        try {
            Object[] objectArray = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            objectArray.init((KeyStore)null);
            objectArray = objectArray.getTrustManagers();
            if (objectArray.length != 1 || !(objectArray[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
            }
            return (X509TrustManager)objectArray[0];
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
    }
}

