/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.core.fragment;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.support.annotation.GuardedBy;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.kwad.sdk.api.core.KsAdSdkDynamicApi;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

@KsAdSdkDynamicApi
@Keep
public class FileProvider
extends ContentProvider {
    private static final String[] COLUMNS = new String[]{"_display_name", "_size"};
    private static final String META_DATA_FILE_PROVIDER_PATHS = "android.support.FILE_PROVIDER_PATHS";
    private static final String TAG_ROOT_PATH = "root-path";
    private static final String TAG_FILES_PATH = "files-path";
    private static final String TAG_CACHE_PATH = "cache-path";
    private static final String TAG_EXTERNAL = "external-path";
    private static final String TAG_EXTERNAL_FILES = "external-files-path";
    private static final String TAG_EXTERNAL_CACHE = "external-cache-path";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final File DEVICE_ROOT = new File("/");
    @GuardedBy(value="sCache")
    private static HashMap<String, PathStrategy> sCache = new HashMap();
    private PathStrategy mStrategy;

    @KsAdSdkDynamicApi
    @Keep
    public boolean onCreate() {
        return true;
    }

    @KsAdSdkDynamicApi
    @Keep
    public void attachInfo(@NonNull Context context, @NonNull ProviderInfo providerInfo) {
        super.attachInfo(context, providerInfo);
        if (providerInfo.exported) {
            throw new SecurityException("Provider must not be exported");
        }
        if (!providerInfo.grantUriPermissions) {
            throw new SecurityException("Provider must grant uri permissions");
        }
        this.mStrategy = FileProvider.getPathStrategy(context, providerInfo.authority);
    }

    @KsAdSdkDynamicApi
    @Keep
    public static Uri getUriForFile(@NonNull Context object, @NonNull String string, @NonNull File file) {
        object = FileProvider.getPathStrategy(object, string);
        return object.getUriForFile(file);
    }

    @KsAdSdkDynamicApi
    @Keep
    public Cursor query(@NonNull Uri object, @Nullable String[] matrixCursor, @Nullable String stringArray, @Nullable String[] objectArray, @Nullable String string) {
        object = this.mStrategy.getFileForUri((Uri)object);
        if (matrixCursor == null) {
            matrixCursor = COLUMNS;
        }
        stringArray = new String[((String[])matrixCursor).length];
        objectArray = new Object[((String[])matrixCursor).length];
        int n2 = 0;
        for (String string2 : matrixCursor) {
            if ("_display_name".equals(string2)) {
                stringArray[n2] = "_display_name";
                objectArray[n2++] = ((File)object).getName();
                continue;
            }
            if (!"_size".equals(string2)) continue;
            stringArray[n2] = "_size";
            objectArray[n2++] = ((File)object).length();
        }
        stringArray = FileProvider.copyOf(stringArray, n2);
        objectArray = FileProvider.copyOf(objectArray, n2);
        matrixCursor = new MatrixCursor(stringArray, 1);
        matrixCursor.addRow(objectArray);
        return matrixCursor;
    }

    @KsAdSdkDynamicApi
    @Keep
    public String getType(@NonNull Uri object) {
        int n2 = ((File)(object = this.mStrategy.getFileForUri((Uri)object))).getName().lastIndexOf(46);
        if (n2 >= 0) {
            object = ((File)object).getName().substring(n2 + 1);
            object = MimeTypeMap.getSingleton().getMimeTypeFromExtension((String)object);
            if (object != null) {
                return object;
            }
        }
        return "application/octet-stream";
    }

    @KsAdSdkDynamicApi
    @Keep
    public Uri insert(@NonNull Uri uri, ContentValues contentValues) {
        throw new UnsupportedOperationException("No external inserts");
    }

    @KsAdSdkDynamicApi
    @Keep
    public int update(@NonNull Uri uri, ContentValues contentValues, @Nullable String string, @Nullable String[] stringArray) {
        throw new UnsupportedOperationException("No external updates");
    }

    @KsAdSdkDynamicApi
    @Keep
    public int delete(@NonNull Uri object, @Nullable String string, @Nullable String[] stringArray) {
        if ((object = this.mStrategy.getFileForUri((Uri)object)).delete()) {
            return 1;
        }
        return 0;
    }

    @KsAdSdkDynamicApi
    @Keep
    public ParcelFileDescriptor openFile(@NonNull Uri object, @NonNull String string) {
        object = this.mStrategy.getFileForUri((Uri)object);
        int n2 = FileProvider.modeToMode(string);
        return ParcelFileDescriptor.open((File)object, (int)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PathStrategy getPathStrategy(Context context, String string) {
        PathStrategy pathStrategy;
        HashMap<String, PathStrategy> hashMap = sCache;
        synchronized (hashMap) {
            pathStrategy = sCache.get(string);
            if (pathStrategy == null) {
                try {
                    pathStrategy = FileProvider.parsePathStrategy(context, string);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", iOException);
                }
                catch (XmlPullParserException xmlPullParserException) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", xmlPullParserException);
                }
                sCache.put(string, pathStrategy);
            }
        }
        return pathStrategy;
    }

    private static PathStrategy parsePathStrategy(Context context, String string) {
        int n2;
        SimplePathStrategy simplePathStrategy = new SimplePathStrategy(string);
        string = context.getPackageManager().resolveContentProvider(string, 128);
        if ((string = string.loadXmlMetaData(context.getPackageManager(), META_DATA_FILE_PROVIDER_PATHS)) == null) {
            throw new IllegalArgumentException("Missing android.support.FILE_PROVIDER_PATHS meta-data");
        }
        while ((n2 = string.next()) != 1) {
            if (n2 != 2) continue;
            File[] fileArray = string.getName();
            String string2 = string.getAttributeValue(null, ATTR_NAME);
            String string3 = string.getAttributeValue(null, ATTR_PATH);
            File file = null;
            if (TAG_ROOT_PATH.equals(fileArray)) {
                file = DEVICE_ROOT;
            } else if (TAG_FILES_PATH.equals(fileArray)) {
                file = context.getFilesDir();
            } else if (TAG_CACHE_PATH.equals(fileArray)) {
                file = context.getCacheDir();
            } else if (TAG_EXTERNAL.equals(fileArray)) {
                file = Environment.getExternalStorageDirectory();
            } else if (TAG_EXTERNAL_FILES.equals(fileArray)) {
                fileArray = ContextCompat.getExternalFilesDirs((Context)context, null);
                if (fileArray.length > 0) {
                    file = fileArray[0];
                }
            } else if (TAG_EXTERNAL_CACHE.equals(fileArray) && (fileArray = ContextCompat.getExternalCacheDirs((Context)context)).length > 0) {
                file = fileArray[0];
            }
            if (file == null) continue;
            simplePathStrategy.addRoot(string2, FileProvider.buildPath(file, string3));
        }
        return simplePathStrategy;
    }

    private static int modeToMode(String string) {
        int n2;
        if ("r".equals(string)) {
            n2 = 0x10000000;
        } else if ("w".equals(string) || "wt".equals(string)) {
            n2 = 0x2C000000;
        } else if ("wa".equals(string)) {
            n2 = 0x2A000000;
        } else if ("rw".equals(string)) {
            n2 = 0x38000000;
        } else if ("rwt".equals(string)) {
            n2 = 0x3C000000;
        } else {
            throw new IllegalArgumentException("Invalid mode: " + string);
        }
        return n2;
    }

    private static File buildPath(File file, String ... stringArray) {
        for (String string : stringArray) {
            if (string == null) continue;
            file = new File(file, string);
        }
        return file;
    }

    private static String[] copyOf(String[] stringArray, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    private static Object[] copyOf(Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    static class SimplePathStrategy
    implements PathStrategy {
        private final String mAuthority;
        private final HashMap<String, File> mRoots = new HashMap();

        public SimplePathStrategy(String string) {
            this.mAuthority = string;
        }

        public void addRoot(String string, File file) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new IllegalArgumentException("Name must not be empty");
            }
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file, iOException);
            }
            this.mRoots.put(string, file);
        }

        @Override
        @KsAdSdkDynamicApi
        @Keep
        public Uri getUriForFile(File object) {
            String string;
            try {
                string = ((File)object).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + object);
            }
            object = null;
            for (Map.Entry<String, File> entry : this.mRoots.entrySet()) {
                String string2 = entry.getValue().getPath();
                if (!string.startsWith(string2) || object != null && string2.length() <= ((File)object.getValue()).getPath().length()) continue;
                object = entry;
            }
            if (object == null) {
                throw new IllegalArgumentException("Failed to find configured root that contains " + string);
            }
            String string3 = ((File)object.getValue()).getPath();
            string = string3.endsWith("/") ? string.substring(string3.length()) : string.substring(string3.length() + 1);
            string = Uri.encode((String)((String)object.getKey())) + '/' + Uri.encode((String)string, (String)"/");
            return new Uri.Builder().scheme("content").authority(this.mAuthority).encodedPath(string).build();
        }

        @Override
        @KsAdSdkDynamicApi
        @Keep
        public File getFileForUri(Uri object) {
            String string = object.getEncodedPath();
            int n2 = string.indexOf(47, 1);
            String string2 = Uri.decode((String)string.substring(1, n2));
            string = Uri.decode((String)string.substring(n2 + 1));
            File file = this.mRoots.get(string2);
            if (file == null) {
                throw new IllegalArgumentException("Unable to find configured root for " + object);
            }
            object = new File(file, string);
            try {
                object = ((File)object).getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + object);
            }
            if (!((File)object).getPath().startsWith(file.getPath())) {
                throw new SecurityException("Resolved path jumped beyond configured root");
            }
            return object;
        }
    }

    @KsAdSdkDynamicApi
    @Keep
    static interface PathStrategy {
        @KsAdSdkDynamicApi
        @Keep
        public Uri getUriForFile(File var1);

        @KsAdSdkDynamicApi
        @Keep
        public File getFileForUri(Uri var1);
    }
}

