/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.loader;

import android.content.Context;
import android.content.res.AssetManager;
import android.support.annotation.Keep;
import android.util.Log;
import com.kwad.sdk.api.loader.DexLoadError;
import com.kwad.sdk.api.loader.g;
import com.kwad.sdk.api.loader.p;
import com.kwad.sdk.api.loader.q;
import com.kwad.sdk.api.loader.r;
import com.kwad.sdk.api.loader.y;
import com.kwad.sdk.api.loader.z;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Objects;

@Keep
public class DexLoader {
    private static final String TAG = "DexLoader";
    private static final String DEX_ROOT_DIR_NAME = "ksad_dex";
    private static final String TARGET_DEX_NAME = "dexJar.jar";
    private static final String dexJarFileName = "ksad_data.jar";
    private static final String dexJarCheckFileName = "ksaddex_makejar.check";
    private static String sDexPathRoot;

    public static ClassLoader initDex(Context context, ClassLoader classLoader) {
        q q2 = r.Dp();
        if (q2 != null) {
            q2.onInit(context);
        }
        Log.w((String)TAG, (String)("initDex liteApi: " + q2));
        DexLoadError dexLoadError = new DexLoadError();
        String string = DexLoader.prepareDexFile(context, dexLoadError);
        Log.w((String)TAG, (String)("initDex after prepareDexFile error: " + dexLoadError));
        if (!dexLoadError.success()) {
            if (q2 != null) {
                Log.w((String)TAG, (String)"initDex after prepareDexFile reportDexLoadError: ");
                q2.reportDexLoadError(context, dexLoadError);
            }
            return null;
        }
        classLoader = DexLoader.createDexClassLoader(context, classLoader, string, dexLoadError);
        Log.w((String)TAG, (String)("initDex after createDexClassLoader error: " + dexLoadError));
        if (dexLoadError.success()) {
            return classLoader;
        }
        Log.w((String)TAG, (String)"initDex after createDexClassLoader reportDexLoadError: ");
        if (q2 != null) {
            q2.reportDexLoadError(context, dexLoadError);
        }
        return null;
    }

    private static String prepareDexFile(Context object, DexLoadError dexLoadError) {
        Log.d((String)TAG, (String)"prepareDexFile start");
        String string = DexLoader.getTargetDexFilePath((Context)object);
        String string2 = DexLoader.readCheckFile((Context)object);
        String string3 = DexLoader.obtainCheckMd5(string2);
        int n2 = DexLoader.obtainVersionCode(string2);
        Log.d((String)TAG, (String)("prepareDexFile after read check md5: " + string3));
        if (DexLoader.checkLocal((Context)object, string3, n2)) {
            Log.d((String)TAG, (String)"prepareDexFile checkLocal success");
            return string;
        }
        object = DexLoader.copyAssetsToData((Context)object, dexJarFileName, dexLoadError);
        Log.d((String)TAG, (String)"prepareDexFile copyAssetsToData done");
        if (object != null && ((File)object).exists()) {
            String string4 = y.getFileMD5((File)object);
            if (Objects.equals(string4, string3)) {
                string = ((File)object).getAbsolutePath();
            } else {
                dexLoadError.setErrorCode(-4);
                dexLoadError.setErrorMsg("targetMd5:" + string4 + ", assetJarFileMd5:" + string3);
            }
        }
        Log.d((String)TAG, (String)("prepareDexFile end with: " + string));
        return string;
    }

    private static String obtainCheckMd5(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        if ((stringArray = stringArray.split("\n")).length == 0) {
            return null;
        }
        return stringArray[0];
    }

    private static int obtainVersionCode(String stringArray) {
        if (stringArray == null) {
            return -1;
        }
        if ((stringArray = stringArray.split("\n")).length == 0) {
            return -1;
        }
        for (String string : stringArray) {
            if (!string.startsWith("versionCode:")) continue;
            String string2 = string.replace("versionCode:", "").trim();
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                NumberFormatException numberFormatException2 = numberFormatException;
                numberFormatException.printStackTrace();
            }
        }
        return -1;
    }

    private static boolean checkLocal(Context object, String string, int n2) {
        Log.d((String)TAG, (String)("checkLocal start assetCheckFileMd5: " + string + ", assetCheckVersionCode: " + n2));
        if (n2 != 4063001) {
            return false;
        }
        object = new File(DexLoader.getTargetDexFilePath(object));
        boolean bl2 = object.exists();
        n2 = bl2 ? 1 : 0;
        if (!bl2) {
            return false;
        }
        return Objects.equals(object = y.getFileMD5((File)object), string);
    }

    private static String readCheckFile(Context object) {
        block6: {
            object = object.getAssets();
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            try {
                String string;
                inputStream = object.open(dexJarCheckFileName);
                object = new StringBuilder();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((string = bufferedReader.readLine()) != null) {
                    ((StringBuilder)object).append(string).append("\n");
                }
                object = ((StringBuilder)object).toString().trim();
                DexLoader.closeQuietly(inputStream);
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
                break block6;
            }
            finally {
                DexLoader.closeQuietly(inputStream);
                DexLoader.closeQuietly(bufferedReader);
            }
            DexLoader.closeQuietly(bufferedReader);
            return object;
        }
        return null;
    }

    private static File copyAssetsToData(Context context, String string, DexLoadError dexLoadError) {
        block9: {
            Object object;
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                AssetManager assetManager = context.getAssets();
                Object object2 = DexLoader.getDexRootPath(context);
                object2 = new File((String)object2);
                if (!((File)object2).exists()) {
                    ((File)object2).mkdir();
                }
                object2 = DexLoader.getTargetDexFilePath(context);
                if (((File)(object2 = new File((String)object2))).exists()) {
                    ((File)object2).delete();
                }
                ((File)object2).createNewFile();
                inputStream = assetManager.open(string);
                fileOutputStream = new FileOutputStream((File)object2);
                string = DexLoader.getTargetDexFilePath(context);
                int n2 = p.a(string, inputStream, p.bb(context));
                if (n2 != 1 && dexLoadError != null) {
                    dexLoadError.setErrorCode(n2);
                }
                fileOutputStream.flush();
                ((File)object2).setReadable(true);
                ((File)object2).setWritable(false);
                object = object2;
                DexLoader.closeQuietly(inputStream);
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
                if (dexLoadError != null) {
                    dexLoadError.setErrorCode(-3);
                    dexLoadError.setErrorMsg(iOException2.getMessage());
                }
                break block9;
            }
            finally {
                DexLoader.closeQuietly(inputStream);
                DexLoader.closeQuietly(fileOutputStream);
            }
            DexLoader.closeQuietly(fileOutputStream);
            return object;
        }
        return null;
    }

    private static void copyFile(InputStream inputStream, OutputStream outputStream) {
        int n2;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    private static String getDexRootPath(Context context) {
        if (sDexPathRoot != null) {
            return sDexPathRoot;
        }
        return context.getApplicationInfo().dataDir + File.separator + DEX_ROOT_DIR_NAME;
    }

    public static String getTargetDexFilePath(Context object) {
        object = DexLoader.getDexRootPath(object);
        return (String)object + File.separator + TARGET_DEX_NAME;
    }

    private static ClassLoader createDexClassLoader(Context object, ClassLoader object2, String string, DexLoadError dexLoadError) {
        block4: {
            try {
                String string2 = z.b((ClassLoader)object2);
                Log.w((String)TAG, (String)("createDexClassLoader parent classLoader is: " + object2 + ", defaultLibPaths is:  " + string2));
                object = g.a(object, (ClassLoader)object2, string, object.getCacheDir().getAbsolutePath(), string2);
                object2 = object.loadClass("com.kwad.sdk.KsAdSDKImpl");
                Log.w((String)TAG, (String)("createDexClassLoader KsAdSDKImpl class is: " + object2));
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                classNotFoundException.printStackTrace();
                if (dexLoadError != null) {
                    dexLoadError.setErrorMsg(classNotFoundException2.getMessage());
                    dexLoadError.setErrorCode(-1);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
                if (dexLoadError == null) break block4;
                dexLoadError.setErrorMsg(throwable2.getMessage());
                dexLoadError.setErrorCode(-2);
            }
        }
        return null;
    }

    private static boolean isTargetDexFileExist(Context context) {
        return false;
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

