/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.loader;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.view.ContextThemeWrapper;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import com.kwad.sdk.api.c;
import com.kwad.sdk.api.core.ResContext;
import com.kwad.sdk.api.loader.ApiReflect;
import com.kwad.sdk.api.loader.Loader;
import com.kwad.sdk.api.loader.t;
import com.kwad.sdk.api.loader.u;
import com.kwad.sdk.api.loader.v;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@Keep
public class Wrapper {
    private static final String TAG = "Wrapper";
    private static final int COUNT_LIMIT_AUTO_UN_WRAP = 5;
    private static final int COUNT_LIMIT_AUTO_UN_WRAP_APPLICATION = 15;
    private static final int COUNT_LIMIT_SAME_STACK_TRACE = 5;
    private static final int TIMELINE_MINIWRAP = 150;
    private static final String CLAZZ_NAME = Wrapper.class.getName();
    private static final String METHOD_WRAP_CONTEXT = "wrapContextIfNeed";
    private static final String METHOD_GET_BASE_CONTEXT = "getBaseContext";
    private static final ThreadLocal<a> sAutoUnWrapModelTL = new ThreadLocal();
    private static final List<String> sAutoUnWrapStackList = new CopyOnWriteArrayList<String>();
    private static Map<Context, Context> sResContextCache = new WeakHashMap<Context, Context>();

    @Keep
    @NonNull
    public static Context wrapContextIfNeed(@Nullable Context context) {
        Object object = (Context)c.g("WRC", context);
        if (object != null) {
            return object;
        }
        if (!Loader.get().isExternalLoaded()) {
            return context;
        }
        if (context == null) {
            return null;
        }
        if (context instanceof ResContext || Wrapper.returnUnWrappedContext(context)) {
            return context;
        }
        if (context instanceof android.view.ContextThemeWrapper) {
            object = sResContextCache.get(context);
            if (object == null) {
                object = new t((android.view.ContextThemeWrapper)context);
                sResContextCache.put(context, (Context)object);
            }
            return object;
        }
        if (context instanceof ContextThemeWrapper) {
            object = sResContextCache.get(context);
            if (object == null) {
                object = new u((ContextThemeWrapper)context);
                sResContextCache.put(context, (Context)object);
            }
            return object;
        }
        if (context instanceof ContextWrapper) {
            object = sResContextCache.get(context);
            if (object == null) {
                object = new v(context);
                sResContextCache.put(context, (Context)object);
            }
            return object;
        }
        object = sResContextCache.get(context);
        if (object == null) {
            object = new v(context);
            sResContextCache.put(context, (Context)object);
        }
        return object;
    }

    public static void onDestroy(Context context) {
        if (context == null) {
            return;
        }
        sResContextCache.remove(context);
    }

    private static boolean returnUnWrappedContext(Context context) {
        a a2 = sAutoUnWrapModelTL.get();
        if (a2 != null) {
            if (a2.aqb.get() == context && Math.abs(System.currentTimeMillis() - a2.aqf) < 150L) {
                int n2;
                a2.aqc++;
                int n3 = n2 = context instanceof Application ? 15 : 5;
                if (a2.aqc >= n2 && Wrapper.needAutoUnWrap(context, a2)) {
                    a2.clear();
                    return true;
                }
            } else {
                a2.clear();
                a2.aqb = new WeakReference<Context>(context);
                a2.aqf = System.currentTimeMillis();
            }
        } else {
            sAutoUnWrapModelTL.set(new a(0));
        }
        return false;
    }

    private static boolean needAutoUnWrap(Context object, a object2) {
        int n2 = 0;
        String string = (object = sResContextCache.get(object)) != null ? object.getClass().getName() : "";
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (Wrapper.containsAllElements(stackTraceElementArray, ((a)object2).aqd)) {
            ((a)object2).aqe++;
            a.a((a)object2, stackTraceElementArray);
            if (((a)object2).aqe >= 5) {
                Log.d((String)TAG, (String)"needAutoUnWrap true \u8fde\u7eed\u76f8\u540c\u5806\u6808");
                return true;
            }
            return false;
        }
        if (((a)object2).aqd != null) {
            ((a)object2).clear();
            return false;
        }
        a.a((a)object2, stackTraceElementArray);
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            object = stackTraceElementArray[i2];
            object2 = ((StackTraceElement)object).getClassName();
            for (String string2 : Wrapper.getAutoUnWrapStackList()) {
                if (TextUtils.isEmpty((CharSequence)string2) || !((String)object2).contains(string2)) continue;
                Log.d((String)TAG, (String)"needAutoUnWrap true \u547d\u4e2d\u767d\u540d\u5355");
                return true;
            }
            object = ((StackTraceElement)object).getMethodName();
            if (i2 + 1 >= stackTraceElementArray.length || !CLAZZ_NAME.equals(object2) || !METHOD_WRAP_CONTEXT.equals(object) || !TextUtils.equals((CharSequence)string, (CharSequence)((StackTraceElement)(object = stackTraceElementArray[i2 + 1])).getClassName()) || !METHOD_GET_BASE_CONTEXT.equals(((StackTraceElement)object).getMethodName()) || ++n2 < 5) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllElements(StackTraceElement[] object, StackTraceElement[] stackTraceElementArray) {
        if (object == null || stackTraceElementArray == null) {
            return false;
        }
        object = new HashSet<StackTraceElement>(Arrays.asList(object));
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (((HashSet)object).contains(stackTraceElement)) continue;
            return false;
        }
        return true;
    }

    private static List<String> getAutoUnWrapStackList() {
        if (sAutoUnWrapStackList.isEmpty()) {
            sAutoUnWrapStackList.add("com.sensorsdata.analytics.android.sdk");
        }
        return sAutoUnWrapStackList;
    }

    @Deprecated
    @Keep
    public static LayoutInflater wrapInflaterIfNeed(LayoutInflater layoutInflater) {
        LayoutInflater layoutInflater2 = (LayoutInflater)c.g("WRI", layoutInflater);
        if (layoutInflater2 != null) {
            return layoutInflater2;
        }
        if (!Loader.get().isExternalLoaded()) {
            return layoutInflater;
        }
        layoutInflater2 = layoutInflater.getContext();
        if (!(layoutInflater2 instanceof ResContext)) {
            if ((layoutInflater2 = Wrapper.wrapContextIfNeed((Context)layoutInflater2)) instanceof ResContext) {
                return layoutInflater.cloneInContext((Context)layoutInflater2);
            }
            return layoutInflater;
        }
        return layoutInflater;
    }

    @Deprecated
    @Keep
    public static Context unwrapContextIfNeed(Context context) {
        Object object = (Context)c.g("URC", context);
        if (object != null) {
            return object;
        }
        object = null;
        Context context2 = context;
        if (context instanceof ResContext) {
            object = (ResContext)context;
        }
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return context;
            }
            if (context instanceof ResContext) {
                object = (ResContext)context;
                context = object.getDelegatedContext();
                continue;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (object != null) {
            return object.getDelegatedContext();
        }
        return context2;
    }

    static Resources replaceExternalResources(Resources resources) {
        Resources resources2 = Loader.get().getExternalResource();
        if (resources2 != null) {
            return resources2;
        }
        return resources;
    }

    static Resources.Theme replaceTheme(Resources.Theme theme, Resources.Theme theme2, int n2) {
        Resources.Theme theme3 = (Resources.Theme)c.g("WRT", theme, theme2, n2);
        if (theme3 != null) {
            return theme3;
        }
        theme3 = Loader.get().getExternalResource();
        if (theme3 != null) {
            if (theme2 == null) {
                theme2 = theme3.newTheme();
                theme2.applyStyle(n2, true);
            }
            return theme2;
        }
        return theme;
    }

    static ClassLoader replaceExternalClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = Loader.get().getExternalClassLoader();
        if (classLoader2 != null) {
            return classLoader2;
        }
        return classLoader;
    }

    static Object wrapSystemService(Object object, String string, Context context) {
        if ("layout_inflater".equals(string) && object instanceof LayoutInflater) {
            string = (object = (LayoutInflater)object).getContext();
            if (string instanceof ResContext) {
                return object;
            }
            return object.cloneInContext(context);
        }
        return object;
    }

    static int getThemeResId(Context object) {
        if (object instanceof android.view.ContextThemeWrapper) {
            if ((object = ApiReflect.h(object).cq("getThemeResId").get()) != null) {
                return (Integer)object;
            }
            return 0;
        }
        if (object instanceof ContextThemeWrapper) {
            return ((ContextThemeWrapper)object).getThemeResId();
        }
        return 0;
    }

    static final class a {
        private WeakReference<Context> aqb = new WeakReference<Object>(null);
        private int aqc = 0;
        private StackTraceElement[] aqd = null;
        private int aqe = 0;
        private long aqf;

        private a() {
        }

        private void clear() {
            this.aqb = new WeakReference<Object>(null);
            this.aqc = 0;
            this.aqd = null;
            this.aqe = 0;
            this.aqf = 0L;
        }

        /* synthetic */ a(byte by2) {
            this();
        }

        static /* synthetic */ StackTraceElement[] a(a a2, StackTraceElement[] stackTraceElementArray) {
            a2.aqd = stackTraceElementArray;
            return stackTraceElementArray;
        }
    }
}

