/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.proxy.app;

import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import com.kwad.sdk.api.core.KSLifecycleObserver;
import com.kwad.sdk.api.loader.b;
import com.kwad.sdk.api.proxy.app.ApiBase64;
import com.kwad.sdk.api.proxy.app.ApiConfigUtils;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONArray;
import org.json.JSONObject;

@Keep
public class AdSdkFileProvider
extends FileProvider {
    private static final String TAG = "AdSdkFileProvider";
    public static long sLaunchTime;
    private static final String SP_INSTALLER_EXTRA_PKGS_KEY = "installerCheckExtraPkgs";
    private static final String SP_INSTALLER_CHECK_PKG_AB_SWITCH = "installerCheckPkgAbSwitch";
    private static final String SP_OPEN_FILE_RECORD = "SP_OPEN_FILE_RECORD";
    private static Set<String> sSystemInstallers;

    public ParcelFileDescriptor openFile(@NonNull Uri uri, @NonNull String string) {
        new StringBuilder("openFile uri:").append(uri).append(" mode:").append(string);
        boolean bl2 = true;
        boolean bl3 = this.isInstallerPkgCheckOpen();
        if (bl3 && Build.VERSION.SDK_INT >= 19) {
            this.checkLocalConfig();
            String string2 = this.getCallingPackage();
            boolean bl4 = sSystemInstallers.contains(string2);
            if (!bl4) {
                bl2 = false;
            }
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("callingPkg", (Object)string2);
                jSONObject.put("checkResult", (Object)String.valueOf(bl4));
                jSONObject.put("uri", (Object)uri.toString());
                string2 = b.b(this.getContext(), SP_OPEN_FILE_RECORD, "");
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = new JSONArray(string2);
                    string2.put((Object)jSONObject);
                    string2 = string2.toString();
                } else {
                    string2 = new JSONArray();
                    string2.put((Object)jSONObject);
                    string2 = string2.toString();
                }
                new StringBuilder("openFile saveRecord:").append(string2);
                b.c(this.getContext(), SP_OPEN_FILE_RECORD, string2);
            }
            catch (Throwable throwable) {}
        }
        if (bl2) {
            return super.openFile(uri, string);
        }
        return null;
    }

    private void checkLocalConfig() {
        try {
            String string = ApiConfigUtils.readString(this.getContext(), SP_INSTALLER_EXTRA_PKGS_KEY, "");
            new StringBuilder("checkLocalConfig extraPkgs:").append(string);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                string = AdSdkFileProvider.getDecodeString(string);
                new StringBuilder("checkLocalConfig extraPkgs decoded: ").append(string);
                string = new JSONArray(string);
                int n2 = string.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string2 = string.getString(i2);
                    if (TextUtils.isEmpty((CharSequence)string2)) continue;
                    sSystemInstallers.add(string2);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private static String getDecodeString(String string) {
        String string2 = string;
        if (!TextUtils.isEmpty((CharSequence)string) && ApiBase64.isEncodeKsSdk(string)) {
            string2 = ApiBase64.decodeKsSdk(string);
        }
        return string2;
    }

    private boolean isInstallerPkgCheckOpen() {
        try {
            int n2 = ApiConfigUtils.readInt(this.getContext(), SP_INSTALLER_CHECK_PKG_AB_SWITCH, 0);
            new StringBuilder("isInstallerPkgCheckOpen abSwitch:").append(n2);
            return n2 == 1;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean onCreate() {
        sLaunchTime = System.currentTimeMillis();
        try {
            KSLifecycleObserver.getInstance().init(this.getContext().getApplicationContext());
        }
        catch (Throwable throwable) {}
        return super.onCreate();
    }

    static {
        sSystemInstallers = new CopyOnWriteArraySet<String>();
        sSystemInstallers.add("com.android.packageinstaller");
        sSystemInstallers.add("com.google.android.packageinstaller");
    }
}

