/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.config.item;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kwad.sdk.core.b;
import com.kwad.sdk.core.d.c;
import com.kwad.sdk.utils.aa;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public final class TipsConfigItem
extends com.kwad.sdk.core.config.item.b<TipConfigData> {
    public TipsConfigItem() {
        super("tipConfig", new TipConfigData());
    }

    @Override
    public final void k(JSONObject jSONObject) {
        if (jSONObject != null && (jSONObject = jSONObject.optJSONObject(this.getKey())) != null) {
            TipConfigData tipConfigData = new TipConfigData();
            tipConfigData.parseJson(jSONObject);
            this.setValue(tipConfigData);
            return;
        }
        TipsConfigItem tipsConfigItem = this;
        tipsConfigItem.setValue(tipsConfigItem.Gu());
    }

    @Override
    public final void b(@NonNull SharedPreferences.Editor editor) {
        editor.putInt("tipsSwitch", ((TipConfigData)this.getValue()).getTipShowSwitch());
        if (((TipConfigData)this.getValue()).getTipInfoData() != null) {
            editor.putString("tipsInfo", ((TipConfigData)this.getValue()).getTipInfoData());
            return;
        }
        editor.putString("tipsInfo", "");
    }

    @Override
    public final void a(@NonNull SharedPreferences sharedPreferences) {
        TipConfigData tipConfigData = (TipConfigData)this.getValue();
        if (tipConfigData == null) {
            tipConfigData = new TipConfigData();
        }
        tipConfigData.setTipShowSwitch(sharedPreferences.getInt("tipsSwitch", 0));
        tipConfigData.setTipInfoData(sharedPreferences.getString("tipsInfo", ""));
        this.setValue(tipConfigData);
    }

    public static class TipConfigData
    implements b,
    Serializable {
        private static final long serialVersionUID = 268961350883157950L;
        private int tipShowSwitch;
        private String tipInfo;
        private transient Map<String, String> tipMap = new HashMap<String, String>();

        @Override
        public void parseJson(@Nullable JSONObject jSONObject) {
            if (jSONObject == null) {
                return;
            }
            this.setTipInfoData(jSONObject.optString("tipInfo"));
            this.tipShowSwitch = jSONObject.optInt("tipShowSwitch", 0);
        }

        @Override
        public JSONObject toJson() {
            JSONObject jSONObject = new JSONObject();
            aa.putValue(jSONObject, "tipShowSwitch", this.tipShowSwitch);
            aa.putValue(jSONObject, "tipInfo", this.tipInfo);
            return jSONObject;
        }

        public boolean isShowTips() {
            return this.tipShowSwitch == 0;
        }

        public String getTips(String string) {
            return this.tipMap.get(string);
        }

        public int getTipShowSwitch() {
            return this.tipShowSwitch;
        }

        @Nullable
        public String getTipInfoData() {
            return this.tipInfo;
        }

        public void setTipShowSwitch(int n2) {
            this.tipShowSwitch = n2;
        }

        public void setTipInfoData(String object) {
            this.tipInfo = object;
            if (TextUtils.isEmpty((CharSequence)object)) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)object) && !"null".equalsIgnoreCase((String)object)) {
                try {
                    this.genTipMap(new JSONObject((String)object));
                    return;
                }
                catch (Exception exception) {
                    object = exception;
                    c.printStackTraceOnly(exception);
                }
            }
        }

        private void genTipMap(JSONObject jSONObject) {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.tipMap.put(string, jSONObject.optString(string, ""));
            }
        }
    }
}

