/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.kwad.sdk.api.core.fragment.KsFragment;
import com.kwad.sdk.c.a.a;
import com.kwad.sdk.core.imageloader.IImageLoader;
import com.kwad.sdk.core.imageloader.KSImageLoader;
import com.kwad.sdk.core.imageloader.cache.disc.naming.Md5FileNameGenerator;
import com.kwad.sdk.core.imageloader.core.DisplayImageOptions;
import com.kwad.sdk.core.imageloader.core.DisplayImageOptionsCompat;
import com.kwad.sdk.core.imageloader.core.ImageLoader;
import com.kwad.sdk.core.imageloader.core.ImageLoaderConfiguration;
import com.kwad.sdk.core.imageloader.core.assist.QueueProcessingType;
import com.kwad.sdk.core.imageloader.core.display.CircleBitmapDisplayer;
import com.kwad.sdk.core.imageloader.core.display.RoundedBitmapDisplayer;
import com.kwad.sdk.core.imageloader.core.download.BaseImageDownloader;
import com.kwad.sdk.core.imageloader.core.listener.ImageLoadingListener;
import com.kwad.sdk.core.network.p;
import com.kwad.sdk.core.network.r;
import com.kwad.sdk.core.response.model.AdTemplate;
import com.kwad.sdk.core.threads.GlobalThreadPools;
import com.kwad.sdk.service.ServiceProvider;
import com.kwad.sdk.service.a.f;
import com.kwad.sdk.utils.be;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class ImageLoadImpl
implements IImageLoader {
    private int cacheSize = -1;

    public void checkInit() {
        if (ImageLoader.getInstance().isInited()) {
            return;
        }
        Context context = ServiceProvider.get(f.class).getContext();
        ImageLoaderConfiguration.Builder builder = new ImageLoaderConfiguration.Builder(context.getApplicationContext());
        builder.taskExecutor(GlobalThreadPools.Jo());
        builder.taskExecutorForCachedImages(GlobalThreadPools.Jp());
        builder.setTaskDistributor(GlobalThreadPools.Jq());
        builder.denyCacheImageMultipleSizesInMemory();
        builder.diskCacheFileNameGenerator(new Md5FileNameGenerator());
        builder.diskCacheSize(0x1400000);
        builder.tasksProcessingOrder(QueueProcessingType.LIFO);
        builder.cacheParentDir(be.dE(context).getPath());
        if (this.cacheSize > 0) {
            builder.memoryCacheSize(this.cacheSize * 1024 * 1024);
        }
        builder.imageDownloader(new BaseImageDownloader(context){

            @Override
            public HttpURLConnection createConnection(String object, Object object2) {
                object = Uri.encode((String)object, (String)"@#&=*+-_.,:!?()/~'%");
                object = (HttpURLConnection)new URL((String)object).openConnection();
                r.wrapHttpURLConnection((URLConnection)object);
                p.b((HttpURLConnection)object);
                ((URLConnection)object).setConnectTimeout(this.connectTimeout);
                ((URLConnection)object).setReadTimeout(this.readTimeout);
                return object;
            }
        });
        ImageLoader.getInstance().init(builder.build());
    }

    @Override
    public void resume() {
        this.checkInit();
        ImageLoader.getInstance().resume();
    }

    @Override
    public void pause() {
        this.checkInit();
        ImageLoader.getInstance().pause();
    }

    @Override
    public void setCacheSize(int n2) {
        this.cacheSize = n2;
    }

    @Override
    public void load(ImageView imageView, Object object) {
        this.checkInit();
        object = this.parseModel(object);
        ImageLoader.getInstance().displayImage((String)object, imageView);
    }

    @Override
    public void load(ImageView imageView, Object object, AdTemplate adTemplate) {
        this.checkInit();
        object = this.parseModel(object);
        ImageLoader.getInstance().displayImage((String)object, imageView, (ImageLoadingListener)new KSImageLoader.InnerImageLoadingListener(adTemplate, null));
    }

    @Override
    public void load(@NonNull Context object, ImageView imageView, Object object2, int n2, int n3) {
        this.checkInit();
        object = this.parseModel(object2);
        object2 = new DisplayImageOptions.Builder().bitmapConfig(Bitmap.Config.ARGB_8888).cacheOnDisk(true).cacheInMemory(true).showImageOnLoading(n3).showImageForEmptyUri(n2).showImageOnFail(n2).build();
        ImageLoader.getInstance().displayImage((String)object, imageView, (DisplayImageOptions)object2);
    }

    private String parseModel(Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("unsupport object except String!");
        }
        object = (String)object;
        return object;
    }

    @Override
    public void load(@NonNull KsFragment object, @NonNull String string, @NonNull ImageView imageView, @NonNull Drawable drawable, @NonNull Drawable drawable2) {
        this.checkInit();
        object = new DisplayImageOptions.Builder().bitmapConfig(Bitmap.Config.ARGB_8888).cacheOnDisk(true).cacheInMemory(true).showImageOnLoading(drawable).showImageOnFail(drawable2).build();
        ImageLoader.getInstance().displayImage(string, imageView, (DisplayImageOptions)object);
    }

    @Override
    public void load(@NonNull KsFragment object, @NonNull String string, @NonNull ImageView imageView, @NonNull Drawable drawable, @NonNull Drawable drawable2, float f2) {
        this.checkInit();
        object = new DisplayImageOptions.Builder().bitmapConfig(Bitmap.Config.ARGB_8888).cacheOnDisk(true).cacheInMemory(true).showImageOnLoading(drawable).showImageOnFail(drawable2).displayer(new RoundedBitmapDisplayer(a.a(imageView.getContext(), f2))).build();
        ImageLoader.getInstance().displayImage(string, imageView, (DisplayImageOptions)object);
    }

    @Override
    public void load(@NonNull Context context, String string, ImageView imageView, DisplayImageOptionsCompat displayImageOptionsCompat, ImageLoadingListener imageLoadingListener) {
        this.checkInit();
        ImageLoader.getInstance().displayImage(string, imageView, this.adapter(displayImageOptionsCompat), imageLoadingListener);
    }

    @Override
    public void load(Context context, String string, DisplayImageOptionsCompat displayImageOptionsCompat, ImageLoadingListener imageLoadingListener) {
        this.checkInit();
        ImageLoader.getInstance().loadImage(string, this.adapter(displayImageOptionsCompat), imageLoadingListener);
    }

    @Override
    public void load(KsFragment ksFragment, @NonNull Context context, String string, DisplayImageOptionsCompat displayImageOptionsCompat, ImageLoadingListener imageLoadingListener) {
        this.checkInit();
        ImageLoader.getInstance().loadImage(string, this.adapter(displayImageOptionsCompat), imageLoadingListener);
    }

    @Override
    public void load(ImageView imageView, Object object, ImageLoadingListener imageLoadingListener) {
        this.checkInit();
        object = this.parseModel(object);
        ImageLoader.getInstance().displayImage((String)object, imageView, imageLoadingListener);
    }

    @Override
    public void clearMemory(Context context) {
        this.checkInit();
        ImageLoader.getInstance().clearMemoryCache();
    }

    private DisplayImageOptions adapter(DisplayImageOptionsCompat displayImageOptionsCompat) {
        Context context = ServiceProvider.get(f.class).getContext();
        Object object = context.getResources();
        object = new DisplayImageOptions.Builder().showImageOnLoading(displayImageOptionsCompat.getImageOnLoading((Resources)object)).showImageForEmptyUri(displayImageOptionsCompat.getImageForEmptyUri((Resources)object)).showImageOnFail(displayImageOptionsCompat.getImageOnFail((Resources)object)).cacheInMemory(true).cacheOnDisc(true).bitmapConfig(Bitmap.Config.RGB_565);
        if (displayImageOptionsCompat.getStrokeWidth() > 0.0f) {
            ((DisplayImageOptions.Builder)object).displayer(new CircleBitmapDisplayer(displayImageOptionsCompat.getStrokeColor(), a.a(context, displayImageOptionsCompat.getStrokeWidth())));
        } else if (displayImageOptionsCompat.isCircle()) {
            ((DisplayImageOptions.Builder)object).displayer(new CircleBitmapDisplayer());
        } else if (displayImageOptionsCompat.getCornerRound() > 0) {
            ((DisplayImageOptions.Builder)object).displayer(new RoundedBitmapDisplayer(a.a(context, displayImageOptionsCompat.getCornerRound())));
        }
        return ((DisplayImageOptions.Builder)object).build();
    }

    @Override
    public File isImageExistOnDisk(String string) {
        this.checkInit();
        return ImageLoader.getInstance().getDiskCache().get(string);
    }

    @Override
    public Bitmap loadImageSync(String string) {
        this.checkInit();
        DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().bitmapConfig(Bitmap.Config.ARGB_8888).cacheOnDisk(true).cacheInMemory(true).build();
        return ImageLoader.getInstance().loadImageSync(string, displayImageOptions);
    }
}

