/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.kwad.sdk.R;
import com.kwad.sdk.core.imageloader.GlobalImageListener;
import com.kwad.sdk.core.imageloader.ImageLoaderProxy;
import com.kwad.sdk.core.imageloader.OnRenderResultListener;
import com.kwad.sdk.core.imageloader.core.DisplayImageOptionsCompat;
import com.kwad.sdk.core.imageloader.core.assist.FailReason;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.listener.ImageLoadingListener;
import com.kwad.sdk.core.response.model.AdTemplate;
import com.kwad.sdk.service.ServiceProvider;
import com.kwad.sdk.service.a.f;
import com.kwad.sdk.utils.ag;
import java.io.File;
import java.io.InputStream;

public class KSImageLoader {
    public static DisplayImageOptionsCompat IMGOPTION_NORMAL = new DisplayImageOptionsCompat.Builder().bitmapConfig(Bitmap.Config.ARGB_8888).cacheOnDisk(true).cacheInMemory(true).build();
    private static OnRenderResultListener<AdTemplate> mDefaultListener;

    private static OnRenderResultListener<AdTemplate> getGlobalImageListener() {
        if (mDefaultListener == null) {
            mDefaultListener = new GlobalImageListener();
        }
        return mDefaultListener;
    }

    private static Context getSDKContext() {
        f f2 = ServiceProvider.get(f.class);
        if (f2 != null) {
            return f2.getContext();
        }
        return null;
    }

    public static boolean isImageExist(String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return false;
        }
        return (object = ImageLoaderProxy.INSTANCE.isImageExistOnDisk((String)object)) != null && ((File)object).exists() && ((File)object).length() > 0L;
    }

    public static Bitmap loadImageSync(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        string = ImageLoaderProxy.INSTANCE.loadImageSync(string);
        return string;
    }

    public static void preloadImage(String string, AdTemplate adTemplate) {
        KSImageLoader.loadImage(string, adTemplate, IMGOPTION_NORMAL, null);
    }

    public static void loadImage(String string, AdTemplate adTemplate, DisplayImageOptionsCompat displayImageOptionsCompat, ImageLoadingListener imageLoadingListener) {
        if (TextUtils.isEmpty((CharSequence)string) || KSImageLoader.getSDKContext() == null) {
            return;
        }
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, displayImageOptionsCompat, new InnerImageLoadingListener(adTemplate, imageLoadingListener));
    }

    public static void loadImage(ImageView imageView, @Nullable String string, ImageLoadingListener imageLoadingListener) {
        if (imageView == null) {
            return;
        }
        ImageLoaderProxy.INSTANCE.load(ServiceProvider.get(f.class).getContext(), string, imageView, IMGOPTION_NORMAL, imageLoadingListener);
    }

    public static void loadImage(ImageView imageView, @Nullable String string, DisplayImageOptionsCompat displayImageOptionsCompat) {
        if (imageView == null) {
            return;
        }
        if (displayImageOptionsCompat == null) {
            displayImageOptionsCompat = IMGOPTION_NORMAL;
        }
        ImageLoaderProxy.INSTANCE.load(ServiceProvider.get(f.class).getContext(), string, imageView, displayImageOptionsCompat, null);
    }

    public static void loadImage(ImageView imageView, @Nullable String string) {
        KSImageLoader.loadImage(imageView, string, null, IMGOPTION_NORMAL);
    }

    public static void loadImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate) {
        KSImageLoader.loadImage(imageView, string, adTemplate, IMGOPTION_NORMAL);
    }

    public static void loadImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate, DisplayImageOptionsCompat displayImageOptionsCompat) {
        if (imageView == null || KSImageLoader.getSDKContext() == null) {
            return;
        }
        if (displayImageOptionsCompat == null) {
            displayImageOptionsCompat = IMGOPTION_NORMAL;
        }
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, displayImageOptionsCompat, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, null));
    }

    public static void loadImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate, DisplayImageOptionsCompat displayImageOptionsCompat, ImageLoadingListener imageLoadingListener) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)string) || KSImageLoader.getSDKContext() == null) {
            return;
        }
        if (displayImageOptionsCompat == null) {
            displayImageOptionsCompat = IMGOPTION_NORMAL;
        }
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, displayImageOptionsCompat, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, imageLoadingListener));
    }

    public static void loadImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate, ImageLoadingListener imageLoadingListener) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)string) || KSImageLoader.getSDKContext() == null) {
            return;
        }
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, IMGOPTION_NORMAL, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, imageLoadingListener));
    }

    public static void loadFeeImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate) {
        KSImageLoader.loadFeeImage(imageView, string, adTemplate, null);
    }

    public static void loadFeeImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate, ImageLoadingListener imageLoadingListener) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)string) || KSImageLoader.getSDKContext() == null) {
            return;
        }
        DisplayImageOptionsCompat displayImageOptionsCompat = new DisplayImageOptionsCompat.Builder().bitmapConfig(Bitmap.Config.RGB_565).cacheInMemory(true).cacheOnDisk(true).setCornerRound(1).build();
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, displayImageOptionsCompat, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, imageLoadingListener));
    }

    public static void loadAppIcon(ImageView imageView, @Nullable String string, AdTemplate adTemplate, int n2) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)string) || KSImageLoader.getSDKContext() == null) {
            return;
        }
        DisplayImageOptionsCompat displayImageOptionsCompat = new DisplayImageOptionsCompat.Builder().showImageOnLoading(imageView.getContext().getResources().getDrawable(R.drawable.ksad_default_app_icon)).showImageForEmptyUri(imageView.getContext().getResources().getDrawable(R.drawable.ksad_default_app_icon)).showImageOnFail(imageView.getContext().getResources().getDrawable(R.drawable.ksad_default_app_icon)).considerExifParams(true).bitmapConfig(Bitmap.Config.RGB_565).setCornerRound(n2).build();
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, displayImageOptionsCompat, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, null));
    }

    public static void loadWithRadius(ImageView imageView, @Nullable String string, AdTemplate adTemplate, int n2) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)string) || KSImageLoader.getSDKContext() == null) {
            return;
        }
        DisplayImageOptionsCompat displayImageOptionsCompat = new DisplayImageOptionsCompat.Builder().showImageOnLoading(imageView.getContext().getResources().getDrawable(R.drawable.ksad_default_app_icon)).showImageForEmptyUri(imageView.getContext().getResources().getDrawable(R.drawable.ksad_default_app_icon)).showImageOnFail(imageView.getContext().getResources().getDrawable(R.drawable.ksad_default_app_icon)).considerExifParams(true).bitmapConfig(Bitmap.Config.RGB_565).setCornerRound(n2).build();
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, displayImageOptionsCompat, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, null));
    }

    public static void loadCircleIcon(ImageView imageView, String string, Drawable object, @ColorInt int n2) {
        if (imageView == null || KSImageLoader.getSDKContext() == null) {
            return;
        }
        object = new DisplayImageOptionsCompat.Builder().showImageOnLoading((Drawable)object).showImageForEmptyUri((Drawable)object).showImageOnFail((Drawable)object).cacheInMemory(true).cacheOnDisc(true).bitmapConfig(Bitmap.Config.RGB_565).setStrokeColor(n2).setStrokeWidth(1.0f).build();
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, (DisplayImageOptionsCompat)object, null);
    }

    public static void loadCircleIconWithBorder(ImageView imageView, String string, Drawable object, Integer n2, float f2) {
        if (imageView == null || KSImageLoader.getSDKContext() == null) {
            return;
        }
        object = new DisplayImageOptionsCompat.Builder().showImageOnLoading((Drawable)object).showImageForEmptyUri((Drawable)object).showImageOnFail((Drawable)object).cacheInMemory(true).cacheOnDisc(true).bitmapConfig(Bitmap.Config.RGB_565).setStrokeColor(n2).setStrokeWidth(f2).build();
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, (DisplayImageOptionsCompat)object, null);
    }

    public static void loadCircleIconWithoutStroke(ImageView imageView, String string, Drawable object) {
        if (imageView == null || KSImageLoader.getSDKContext() == null) {
            return;
        }
        object = new DisplayImageOptionsCompat.Builder().showImageOnLoading((Drawable)object).showImageForEmptyUri((Drawable)object).showImageOnFail((Drawable)object).cacheInMemory(true).cacheOnDisc(true).bitmapConfig(Bitmap.Config.RGB_565).setCircle(true).build();
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, (DisplayImageOptionsCompat)object, null);
    }

    public static void loadCircleIcon(ImageView imageView, String string, Drawable object) {
        if (imageView == null || KSImageLoader.getSDKContext() == null) {
            return;
        }
        object = new DisplayImageOptionsCompat.Builder().showImageOnLoading((Drawable)object).showImageForEmptyUri((Drawable)object).showImageOnFail((Drawable)object).cacheInMemory(true).cacheOnDisc(true).bitmapConfig(Bitmap.Config.RGB_565).setStrokeColor(Color.argb((int)255, (int)255, (int)255, (int)255)).setStrokeWidth(1.0f).build();
        ImageLoaderProxy.INSTANCE.load(KSImageLoader.getSDKContext(), string, imageView, (DisplayImageOptionsCompat)object, null);
    }

    @RequiresApi(api=17)
    public static Bitmap blur(Context context, Bitmap bitmap, @IntRange(from=1L, to=25L) int n2) {
        try {
            Bitmap bitmap2 = bitmap.getConfig() == Bitmap.Config.ARGB_8888 ? bitmap : bitmap.copy(Bitmap.Config.ARGB_8888, true);
            if (bitmap2 == null) {
                Bitmap bitmap3 = bitmap;
                bitmap2 = bitmap3.copy(bitmap3.getConfig(), true);
            }
            bitmap2 = Bitmap.createBitmap((int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Bitmap.Config)bitmap2.getConfig());
            context = RenderScript.create((Context)context);
            Allocation allocation = Allocation.createFromBitmap((RenderScript)context, (Bitmap)bitmap2);
            ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)context, (Element)allocation.getElement());
            scriptIntrinsicBlur.setInput(allocation);
            scriptIntrinsicBlur.setRadius((float)n2);
            scriptIntrinsicBlur.forEach(allocation);
            allocation.copyTo(bitmap2);
            context.destroy();
            return bitmap2;
        }
        catch (Exception exception) {
            return bitmap;
        }
    }

    public static void resume() {
        ImageLoaderProxy.INSTANCE.resume();
    }

    public static void pause() {
        ImageLoaderProxy.INSTANCE.pause();
    }

    public static void clearMemory() {
        ImageLoaderProxy.INSTANCE.clearMemory(ServiceProvider.get(f.class).getContext());
    }

    public static class InnerImageLoadingListener
    implements ImageLoadingListener {
        @Nullable
        AdTemplate adTemplate;
        @Nullable
        ImageLoadingListener loadingListener;
        private long startTime;
        public static final int MAX_DURATION = 30000;

        public InnerImageLoadingListener(@Nullable AdTemplate adTemplate, @Nullable ImageLoadingListener imageLoadingListener) {
            this.adTemplate = adTemplate;
            this.loadingListener = imageLoadingListener;
        }

        @Override
        public void onLoadingStarted(String string, View view) {
            if (this.loadingListener != null) {
                this.loadingListener.onLoadingStarted(string, view);
            }
            this.startTime = SystemClock.elapsedRealtime();
            ag.QH();
        }

        @Override
        public void onLoadingFailed(String string, View object, FailReason failReason) {
            if (this.loadingListener != null) {
                this.loadingListener.onLoadingFailed(string, (View)object, failReason);
            }
            if (this.adTemplate != null) {
                object = new StringBuilder("ImageLoader:");
                if (failReason != null) {
                    Throwable throwable = failReason.getCause();
                    String string2 = "";
                    if (throwable != null && throwable.getStackTrace().length > 0) {
                        string2 = throwable.getMessage() + " @ " + throwable.getStackTrace()[0].getFileName() + throwable.getStackTrace()[0].getClassName() + throwable.getStackTrace()[0].getLineNumber();
                    }
                    switch (failReason.getType()) {
                        case UNKNOWN: {
                            ((StringBuilder)object).append("UNKNOWN");
                            break;
                        }
                        case IO_ERROR: {
                            ((StringBuilder)object).append("IO_ERROR").append(string2);
                            break;
                        }
                        case OUT_OF_MEMORY: {
                            ((StringBuilder)object).append("OUT_OF_MEMORY");
                            break;
                        }
                        case NETWORK_DENIED: {
                            ((StringBuilder)object).append("NETWORK_DENIED");
                            break;
                        }
                        case DECODING_ERROR: {
                            ((StringBuilder)object).append("DECODING_ERROR");
                        }
                    }
                }
                if (KSImageLoader.getGlobalImageListener() != null) {
                    KSImageLoader.getGlobalImageListener().onRenderResult(false, this.adTemplate, string, ((StringBuilder)object).toString());
                }
            }
            ag.QJ();
        }

        @Override
        public boolean onDecode(String string, InputStream inputStream, DecodedResult decodedResult) {
            if (this.loadingListener != null) {
                return this.loadingListener.onDecode(string, inputStream, decodedResult);
            }
            return false;
        }

        private void recordDuration(long l2) {
            try {
                long l3 = this.getDuration(l2);
                if (l3 >= 0L) {
                    ag.ba(l3);
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        private long getDuration(long l2) {
            if (l2 == 0L) {
                return -1L;
            }
            long l3 = SystemClock.elapsedRealtime() - l2;
            if (l3 >= 30000L) {
                return -1L;
            }
            return l3;
        }

        @Override
        public void onLoadingComplete(String string, View view, DecodedResult decodedResult) {
            if (this.loadingListener != null) {
                this.loadingListener.onLoadingComplete(string, view, decodedResult);
            }
            InnerImageLoadingListener innerImageLoadingListener = this;
            innerImageLoadingListener.recordDuration(innerImageLoadingListener.startTime);
            ag.QI();
        }

        @Override
        public void onLoadingCancelled(String string, View view) {
            if (this.loadingListener != null) {
                this.loadingListener.onLoadingCancelled(string, view);
            }
        }
    }
}

