/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.disc.impl;

import android.graphics.Bitmap;
import com.kwad.sdk.core.imageloader.cache.disc.DiskCache;
import com.kwad.sdk.core.imageloader.cache.disc.naming.FileNameGenerator;
import com.kwad.sdk.core.imageloader.core.DefaultConfigurationFactory;
import com.kwad.sdk.core.imageloader.utils.IoUtils;
import com.kwad.sdk.crash.utils.b;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BaseDiskCache
implements DiskCache {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.PNG;
    public static final int DEFAULT_COMPRESS_QUALITY = 100;
    private static final String ERROR_ARG_NULL = " argument must be not null";
    private static final String TEMP_IMAGE_POSTFIX = ".tmp";
    protected final File cacheDir;
    protected final File reserveCacheDir;
    protected final FileNameGenerator fileNameGenerator;
    protected int bufferSize = 32768;
    protected Bitmap.CompressFormat compressFormat = DEFAULT_COMPRESS_FORMAT;
    protected int compressQuality = 100;

    public BaseDiskCache(File file) {
        this(file, null);
    }

    public BaseDiskCache(File file, File file2) {
        this(file, file2, DefaultConfigurationFactory.createFileNameGenerator());
    }

    public BaseDiskCache(File file, File file2, FileNameGenerator fileNameGenerator) {
        if (file == null) {
            throw new IllegalArgumentException("cacheDir argument must be not null");
        }
        if (fileNameGenerator == null) {
            throw new IllegalArgumentException("fileNameGenerator argument must be not null");
        }
        this.cacheDir = file;
        this.reserveCacheDir = file2;
        this.fileNameGenerator = fileNameGenerator;
    }

    @Override
    public File getDirectory() {
        return this.cacheDir;
    }

    @Override
    public File get(String string) {
        return this.getFile(string);
    }

    @Override
    public boolean save(String object, InputStream inputStream, IoUtils.CopyListener copyListener) {
        object = this.getFile((String)object);
        File file = new File(((File)object).getAbsolutePath() + TEMP_IMAGE_POSTFIX);
        boolean bl2 = false;
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), this.bufferSize);
            try {
                bl2 = IoUtils.copyStream(inputStream, bufferedOutputStream, copyListener, this.bufferSize);
            }
            finally {
                b.closeQuietly(bufferedOutputStream);
            }
        }
        finally {
            if (bl2 && !file.renameTo((File)object)) {
                bl2 = false;
            }
            if (!bl2) {
                file.delete();
            }
        }
        return bl2;
    }

    @Override
    public boolean save(String object, Bitmap bitmap) {
        boolean bl2;
        object = this.getFile((String)object);
        File file = new File(((File)object).getAbsolutePath() + TEMP_IMAGE_POSTFIX);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), this.bufferSize);
        try {
            bl2 = bitmap.compress(this.compressFormat, this.compressQuality, (OutputStream)bufferedOutputStream);
        }
        catch (Throwable throwable) {
            b.closeQuietly(bufferedOutputStream);
            file.delete();
            throw throwable;
        }
        b.closeQuietly(bufferedOutputStream);
        if (bl2 && !file.renameTo((File)object)) {
            bl2 = false;
        }
        if (!bl2) {
            file.delete();
        }
        bitmap.recycle();
        return bl2;
    }

    @Override
    public boolean remove(String string) {
        return this.getFile(string).delete();
    }

    @Override
    public void close() {
    }

    @Override
    public void clear() {
        File[] fileArray = this.cacheDir.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                file.delete();
            }
        }
    }

    protected File getFile(String string) {
        string = this.fileNameGenerator.generate(string);
        File file = this.cacheDir;
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs() && this.reserveCacheDir != null && (this.reserveCacheDir.exists() || this.reserveCacheDir.mkdirs())) {
            file = this.reserveCacheDir;
        }
        return new File(file, string);
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    public void setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setCompressQuality(int n2) {
        this.compressQuality = n2;
    }
}

