/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.disc.impl;

import android.graphics.Bitmap;
import com.kwad.sdk.core.imageloader.cache.disc.impl.BaseDiskCache;
import com.kwad.sdk.core.imageloader.cache.disc.naming.FileNameGenerator;
import com.kwad.sdk.core.imageloader.core.DefaultConfigurationFactory;
import com.kwad.sdk.core.imageloader.utils.IoUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeDiskCache
extends BaseDiskCache {
    private final long maxFileAge;
    private final Map<File, Long> loadingDates = Collections.synchronizedMap(new HashMap());

    public LimitedAgeDiskCache(File file, long l2) {
        this(file, null, DefaultConfigurationFactory.createFileNameGenerator(), l2);
    }

    public LimitedAgeDiskCache(File file, File file2, long l2) {
        this(file, file2, DefaultConfigurationFactory.createFileNameGenerator(), l2);
    }

    public LimitedAgeDiskCache(File file, File file2, FileNameGenerator fileNameGenerator, long l2) {
        super(file, file2, fileNameGenerator);
        this.maxFileAge = l2 * 1000L;
    }

    @Override
    public File get(String object) {
        if ((object = super.get((String)object)) != null && ((File)object).exists()) {
            boolean bl2;
            Long l2 = this.loadingDates.get(object);
            if (l2 == null) {
                bl2 = false;
                l2 = ((File)object).lastModified();
            } else {
                bl2 = true;
            }
            if (System.currentTimeMillis() - l2 > this.maxFileAge) {
                ((File)object).delete();
                this.loadingDates.remove(object);
            } else if (!bl2) {
                this.loadingDates.put((File)object, l2);
            }
        }
        return object;
    }

    @Override
    public boolean save(String string, InputStream inputStream, IoUtils.CopyListener copyListener) {
        boolean bl2 = super.save(string, inputStream, copyListener);
        this.rememberUsage(string);
        return bl2;
    }

    @Override
    public boolean save(String string, Bitmap bitmap) {
        boolean bl2 = super.save(string, bitmap);
        this.rememberUsage(string);
        return bl2;
    }

    @Override
    public boolean remove(String string) {
        this.loadingDates.remove(this.getFile(string));
        return super.remove(string);
    }

    @Override
    public void clear() {
        super.clear();
        this.loadingDates.clear();
    }

    private void rememberUsage(String object) {
        object = this.getFile((String)object);
        long l2 = System.currentTimeMillis();
        ((File)object).setLastModified(l2);
        this.loadingDates.put((File)object, l2);
    }
}

