/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.disc.impl.ext;

import android.graphics.Bitmap;
import com.kwad.sdk.core.diskcache.a.a;
import com.kwad.sdk.core.imageloader.cache.disc.DiskCache;
import com.kwad.sdk.core.imageloader.cache.disc.naming.FileNameGenerator;
import com.kwad.sdk.core.imageloader.utils.IoUtils;
import com.kwad.sdk.core.imageloader.utils.L;
import com.kwad.sdk.crash.utils.b;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LruDiskCache
implements DiskCache {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.PNG;
    public static final int DEFAULT_COMPRESS_QUALITY = 100;
    private static final String ERROR_ARG_NULL = " argument must be not null";
    private static final String ERROR_ARG_NEGATIVE = " argument must be positive number";
    protected a cache;
    private File reserveCacheDir;
    protected final FileNameGenerator fileNameGenerator;
    protected int bufferSize = 32768;
    protected Bitmap.CompressFormat compressFormat = DEFAULT_COMPRESS_FORMAT;
    protected int compressQuality = 100;

    public LruDiskCache(File file, FileNameGenerator fileNameGenerator, long l2) {
        this(file, null, fileNameGenerator, l2, 0);
    }

    public LruDiskCache(File file, File file2, FileNameGenerator fileNameGenerator, long l2, int n2) {
        if (file == null) {
            throw new IllegalArgumentException("cacheDir argument must be not null");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("cacheMaxSize argument must be positive number");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("cacheMaxFileCount argument must be positive number");
        }
        if (fileNameGenerator == null) {
            throw new IllegalArgumentException("fileNameGenerator argument must be not null");
        }
        if (l2 == 0L) {
            l2 = Long.MAX_VALUE;
        }
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        this.reserveCacheDir = file2;
        this.fileNameGenerator = fileNameGenerator;
        this.initCache(file, file2, l2, n2);
    }

    private void initCache(File serializable, File file, long l2, int n2) {
        try {
            this.cache = a.a(serializable, 1, 1, l2, n2);
            return;
        }
        catch (IOException iOException) {
            serializable = iOException;
            L.e(iOException);
            if (file != null) {
                this.initCache(file, null, l2, n2);
            }
            if (this.cache == null) {
                throw serializable;
            }
            return;
        }
    }

    @Override
    public File getDirectory() {
        return this.cache.getDirectory();
    }

    @Override
    public File get(String object) {
        a.c c2 = null;
        try {
            c2 = this.cache.dD(this.getKey((String)object));
            object = c2 == null ? null : c2.dv(0);
            b.closeQuietly(c2);
            return object;
        }
        catch (IOException iOException) {
            object = iOException;
            L.e(iOException);
            return null;
        }
        finally {
            b.closeQuietly(c2);
        }
    }

    @Override
    public boolean save(String object, InputStream inputStream, IoUtils.CopyListener copyListener) {
        boolean bl2;
        if ((object = this.cache.dE(this.getKey((String)object))) == null) {
            return false;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(((a.a)object).ds(0), this.bufferSize);
        try {
            bl2 = IoUtils.copyStream(inputStream, bufferedOutputStream, copyListener, this.bufferSize);
        }
        catch (Throwable throwable) {
            b.closeQuietly(bufferedOutputStream);
            ((a.a)object).abort();
            throw throwable;
        }
        b.closeQuietly(bufferedOutputStream);
        if (bl2) {
            ((a.a)object).commit();
        } else {
            ((a.a)object).abort();
        }
        return bl2;
    }

    @Override
    public boolean save(String object, Bitmap bitmap) {
        boolean bl2;
        if ((object = this.cache.dE(this.getKey((String)object))) == null) {
            return false;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(((a.a)object).ds(0), this.bufferSize);
        try {
            bl2 = bitmap.compress(this.compressFormat, this.compressQuality, (OutputStream)bufferedOutputStream);
        }
        finally {
            b.closeQuietly(bufferedOutputStream);
        }
        if (bl2) {
            ((a.a)object).commit();
        } else {
            ((a.a)object).abort();
        }
        return bl2;
    }

    @Override
    public boolean remove(String object) {
        try {
            return this.cache.remove(this.getKey((String)object));
        }
        catch (IOException iOException) {
            object = iOException;
            L.e(iOException);
            return false;
        }
    }

    @Override
    public void close() {
        b.closeQuietly(this.cache);
        this.cache = null;
    }

    @Override
    public void clear() {
        IOException iOException;
        try {
            this.cache.delete();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            L.e(iOException2);
        }
        try {
            LruDiskCache lruDiskCache = this;
            lruDiskCache.initCache(lruDiskCache.cache.getDirectory(), this.reserveCacheDir, this.cache.getMaxSize(), this.cache.GJ());
            return;
        }
        catch (IOException iOException3) {
            iOException = iOException3;
            L.e(iOException3);
            return;
        }
    }

    private String getKey(String string) {
        return this.fileNameGenerator.generate(string);
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    public void setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setCompressQuality(int n2) {
        this.compressQuality = n2;
    }
}

