/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory;

import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class BaseMemoryCache
implements MemoryCache {
    private final Map<String, Reference<DecodedResult>> softMap = Collections.synchronizedMap(new HashMap());

    @Override
    public DecodedResult get(String object) {
        DecodedResult decodedResult = null;
        if ((object = this.softMap.get(object)) != null) {
            decodedResult = (DecodedResult)((Reference)object).get();
        }
        return decodedResult;
    }

    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        this.softMap.put(string, this.createReference(decodedResult));
        return true;
    }

    @Override
    public DecodedResult remove(String object) {
        if ((object = this.softMap.remove(object)) == null) {
            return null;
        }
        return (DecodedResult)((Reference)object).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> keys() {
        Map<String, Reference<DecodedResult>> map = this.softMap;
        synchronized (map) {
            return new HashSet<String>(this.softMap.keySet());
        }
    }

    @Override
    public void clear() {
        this.softMap.clear();
    }

    protected abstract Reference<DecodedResult> createReference(DecodedResult var1);
}

