/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.LimitedMemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FIFOLimitedMemoryCache
extends LimitedMemoryCache {
    private final List<DecodedResult> queue = Collections.synchronizedList(new LinkedList());

    public FIFOLimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        if (super.put(string, decodedResult)) {
            this.queue.add(decodedResult);
            return true;
        }
        return false;
    }

    @Override
    public DecodedResult remove(String string) {
        DecodedResult decodedResult = super.get(string);
        if (decodedResult != null) {
            this.queue.remove(decodedResult);
        }
        return super.remove(string);
    }

    @Override
    public void clear() {
        this.queue.clear();
        super.clear();
    }

    @Override
    public int getSize(DecodedResult decodedResult) {
        return decodedResult.getByteSize();
    }

    @Override
    public DecodedResult removeNext() {
        return this.queue.remove(0);
    }

    @Override
    public Reference<DecodedResult> createReference(DecodedResult decodedResult) {
        return new WeakReference<DecodedResult>(decodedResult);
    }
}

