/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.util.Collection;
import java.util.Comparator;

public class FuzzyKeyMemoryCache
implements MemoryCache {
    private final MemoryCache cache;
    private final Comparator<String> keyComparator;

    public FuzzyKeyMemoryCache(MemoryCache memoryCache, Comparator<String> comparator) {
        this.cache = memoryCache;
        this.keyComparator = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            String string2 = null;
            for (String string3 : this.cache.keys()) {
                if (this.keyComparator.compare(string, string3) != 0) continue;
                string2 = string3;
                break;
            }
            if (string2 != null) {
                this.cache.remove(string2);
            }
        }
        return this.cache.put(string, decodedResult);
    }

    @Override
    public DecodedResult get(String string) {
        return this.cache.get(string);
    }

    @Override
    public DecodedResult remove(String string) {
        return this.cache.remove(string);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Collection<String> keys() {
        return this.cache.keys();
    }
}

