/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.LimitedMemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRULimitedMemoryCache
extends LimitedMemoryCache {
    private static final int INITIAL_CAPACITY = 10;
    private static final float LOAD_FACTOR = 1.1f;
    private final Map<String, DecodedResult> lruCache = Collections.synchronizedMap(new LinkedHashMap(10, 1.1f, true));

    public LRULimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        if (super.put(string, decodedResult)) {
            this.lruCache.put(string, decodedResult);
            return true;
        }
        return false;
    }

    @Override
    public DecodedResult get(String string) {
        this.lruCache.get(string);
        return super.get(string);
    }

    @Override
    public DecodedResult remove(String string) {
        this.lruCache.remove(string);
        return super.remove(string);
    }

    @Override
    public void clear() {
        this.lruCache.clear();
        super.clear();
    }

    @Override
    public int getSize(DecodedResult decodedResult) {
        return decodedResult.getByteSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecodedResult removeNext() {
        Object object = null;
        Map<String, DecodedResult> map = this.lruCache;
        synchronized (map) {
            Iterator<Map.Entry<String, DecodedResult>> iterator = this.lruCache.entrySet().iterator();
            if (iterator.hasNext()) {
                object = iterator.next();
                object = object.getValue();
                iterator.remove();
            }
        }
        return object;
    }

    @Override
    public Reference<DecodedResult> createReference(DecodedResult decodedResult) {
        return new WeakReference<DecodedResult>(decodedResult);
    }
}

