/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.LimitedMemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LargestLimitedMemoryCache
extends LimitedMemoryCache {
    private final Map<DecodedResult, Integer> valueSizes = Collections.synchronizedMap(new HashMap());

    public LargestLimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        if (super.put(string, decodedResult)) {
            this.valueSizes.put(decodedResult, this.getSize(decodedResult));
            return true;
        }
        return false;
    }

    @Override
    public DecodedResult remove(String string) {
        DecodedResult decodedResult = super.get(string);
        if (decodedResult != null) {
            this.valueSizes.remove(decodedResult);
        }
        return super.remove(string);
    }

    @Override
    public void clear() {
        this.valueSizes.clear();
        super.clear();
    }

    @Override
    public int getSize(DecodedResult decodedResult) {
        return decodedResult.getByteSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecodedResult removeNext() {
        Integer n2 = null;
        DecodedResult decodedResult = null;
        Object object = this.valueSizes.entrySet();
        Map<DecodedResult, Integer> map = this.valueSizes;
        synchronized (map) {
            object = object.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                if (decodedResult == null) {
                    decodedResult = (DecodedResult)entry.getKey();
                    n2 = (Integer)entry.getValue();
                    continue;
                }
                Integer n3 = (Integer)entry.getValue();
                if (n3 <= n2) continue;
                n2 = n3;
                decodedResult = (DecodedResult)entry.getKey();
            }
        }
        this.valueSizes.remove(decodedResult);
        return decodedResult;
    }

    @Override
    public Reference<DecodedResult> createReference(DecodedResult decodedResult) {
        return new WeakReference<DecodedResult>(decodedResult);
    }
}

