/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.utils.ax;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruMemoryCache
implements MemoryCache {
    private final LinkedHashMap<String, DecodedResult> map;
    private final int maxSize;
    private int size;

    public LruMemoryCache(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = n2;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DecodedResult get(String string) {
        ax.ax(string, "key");
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            return this.map.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(String string, DecodedResult decodedResult) {
        ax.ax(string, "key");
        ax.g(decodedResult, "value");
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            this.size += this.sizeOf(string, decodedResult);
            decodedResult = this.map.put(string, decodedResult);
            if (decodedResult != null) {
                this.size -= this.sizeOf(string, decodedResult);
            }
        }
        LruMemoryCache lruMemoryCache2 = this;
        lruMemoryCache2.trimToSize(lruMemoryCache2.maxSize);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int n2) {
        while (true) {
            LruMemoryCache lruMemoryCache = this;
            synchronized (lruMemoryCache) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= n2 || this.map.isEmpty()) {
                    return;
                }
                Map.Entry<String, DecodedResult> entry = this.map.entrySet().iterator().next();
                if (entry == null) {
                    return;
                }
                String string = entry.getKey();
                entry = entry.getValue();
                this.map.remove(string);
                this.size -= this.sizeOf(string, (DecodedResult)((Object)entry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DecodedResult remove(String string) {
        ax.ax(string, "key");
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            DecodedResult decodedResult = (DecodedResult)this.map.remove(string);
            if (decodedResult != null) {
                this.size -= this.sizeOf(string, decodedResult);
            }
            return decodedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> keys() {
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            return new HashSet<String>(this.map.keySet());
        }
    }

    @Override
    public void clear() {
        this.trimToSize(-1);
    }

    private int sizeOf(String string, DecodedResult decodedResult) {
        return decodedResult.getByteSize();
    }

    public final synchronized String toString() {
        return String.format("LruCache[maxSize=%d]", this.maxSize);
    }
}

