/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.LimitedMemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UsingFreqLimitedMemoryCache
extends LimitedMemoryCache {
    private final Map<DecodedResult, Integer> usingCounts = Collections.synchronizedMap(new HashMap());

    public UsingFreqLimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        if (super.put(string, decodedResult)) {
            this.usingCounts.put(decodedResult, 0);
            return true;
        }
        return false;
    }

    @Override
    public DecodedResult get(String object) {
        Integer n2;
        if ((object = super.get((String)object)) != null && (n2 = this.usingCounts.get(object)) != null) {
            this.usingCounts.put((DecodedResult)object, n2 + 1);
        }
        return object;
    }

    @Override
    public DecodedResult remove(String string) {
        DecodedResult decodedResult = super.get(string);
        if (decodedResult != null) {
            this.usingCounts.remove(decodedResult);
        }
        return super.remove(string);
    }

    @Override
    public void clear() {
        this.usingCounts.clear();
        super.clear();
    }

    @Override
    public int getSize(DecodedResult decodedResult) {
        return decodedResult.getByteSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecodedResult removeNext() {
        Integer n2 = null;
        DecodedResult decodedResult = null;
        Object object = this.usingCounts.entrySet();
        Map<DecodedResult, Integer> map = this.usingCounts;
        synchronized (map) {
            object = object.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                if (decodedResult == null) {
                    decodedResult = (DecodedResult)entry.getKey();
                    n2 = (Integer)entry.getValue();
                    continue;
                }
                Integer n3 = (Integer)entry.getValue();
                if (n3 >= n2) continue;
                n2 = n3;
                decodedResult = (DecodedResult)entry.getKey();
            }
        }
        this.usingCounts.remove(decodedResult);
        return decodedResult;
    }

    @Override
    public Reference<DecodedResult> createReference(DecodedResult decodedResult) {
        return new WeakReference<DecodedResult>(decodedResult);
    }
}

