/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.kwad.sdk.core.imageloader.cache.disc.DiskCache;
import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.core.DisplayImageOptions;
import com.kwad.sdk.core.imageloader.core.ImageLoaderConfiguration;
import com.kwad.sdk.core.imageloader.core.ImageLoaderEngine;
import com.kwad.sdk.core.imageloader.core.ImageLoadingInfo;
import com.kwad.sdk.core.imageloader.core.LoadAndDisplayImageTask;
import com.kwad.sdk.core.imageloader.core.ProcessAndDisplayImageTask;
import com.kwad.sdk.core.imageloader.core.assist.ImageSize;
import com.kwad.sdk.core.imageloader.core.assist.LoadedFrom;
import com.kwad.sdk.core.imageloader.core.assist.ViewScaleType;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageAware;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageViewAware;
import com.kwad.sdk.core.imageloader.core.imageaware.NonViewAware;
import com.kwad.sdk.core.imageloader.core.listener.ImageLoadingListener;
import com.kwad.sdk.core.imageloader.core.listener.ImageLoadingProgressListener;
import com.kwad.sdk.core.imageloader.core.listener.SimpleImageLoadingListener;
import com.kwad.sdk.core.imageloader.utils.ImageSizeUtils;
import com.kwad.sdk.core.imageloader.utils.L;
import com.kwad.sdk.core.imageloader.utils.MemoryCacheUtils;

public class ImageLoader {
    public static final String TAG = ImageLoader.class.getSimpleName();
    static final String LOG_INIT_CONFIG = "Initialize ImageLoader with configuration";
    static final String LOG_DESTROY = "Destroy ImageLoader";
    static final String LOG_LOAD_IMAGE_FROM_MEMORY_CACHE = "Load image from memory cache [%s]";
    private static final String WARNING_RE_INIT_CONFIG = "Try to initialize ImageLoader which had already been initialized before. To re-init ImageLoader with new configuration call ImageLoader.destroy() at first.";
    private static final String ERROR_WRONG_ARGUMENTS = "Wrong arguments were passed to displayImage() method (ImageView reference must not be null)";
    private static final String ERROR_NOT_INIT = "ImageLoader must be init with configuration before using";
    private static final String ERROR_INIT_CONFIG_WITH_NULL = "ImageLoader configuration can not be initialized with null";
    private volatile ImageLoaderConfiguration configuration;
    private ImageLoaderEngine engine;
    private ImageLoadingListener defaultListener = new SimpleImageLoadingListener();
    private static volatile ImageLoader instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance() {
        if (instance != null) return instance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (instance != null) return instance;
            instance = new ImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ImageLoader() {
    }

    public synchronized void init(ImageLoaderConfiguration imageLoaderConfiguration) {
        if (imageLoaderConfiguration == null) {
            throw new IllegalArgumentException(ERROR_INIT_CONFIG_WITH_NULL);
        }
        if (this.configuration == null) {
            L.d(LOG_INIT_CONFIG, new Object[0]);
            this.engine = new ImageLoaderEngine(imageLoaderConfiguration);
            this.configuration = imageLoaderConfiguration;
            return;
        }
        L.w(WARNING_RE_INIT_CONFIG, new Object[0]);
    }

    public boolean isInited() {
        return this.configuration != null;
    }

    public void displayImage(String string, ImageAware imageAware) {
        this.displayImage(string, imageAware, null, null, null);
    }

    public void displayImage(String string, ImageAware imageAware, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string, imageAware, null, imageLoadingListener, null);
    }

    public void displayImage(String string, ImageAware imageAware, DisplayImageOptions displayImageOptions) {
        this.displayImage(string, imageAware, displayImageOptions, null, null);
    }

    public void displayImage(String string, ImageAware imageAware, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string, imageAware, displayImageOptions, imageLoadingListener, null);
    }

    public void displayImage(String string, ImageAware imageAware, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.displayImage(string, imageAware, displayImageOptions, null, imageLoadingListener, imageLoadingProgressListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void displayImage(String object, ImageAware imageAware, DisplayImageOptions displayImageOptions, ImageSize imageSize, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.checkConfiguration();
        if (imageAware == null) {
            throw new IllegalArgumentException(ERROR_WRONG_ARGUMENTS);
        }
        if (imageLoadingListener == null) {
            imageLoadingListener = this.defaultListener;
        }
        if (displayImageOptions == null) {
            displayImageOptions = this.configuration.defaultDisplayImageOptions;
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            this.engine.cancelDisplayTaskFor(imageAware);
            imageLoadingListener.onLoadingStarted((String)object, imageAware.getWrappedView());
            if (displayImageOptions.shouldShowImageForEmptyUri()) {
                imageAware.setImageDrawable(displayImageOptions.getImageForEmptyUri(this.configuration.resources));
            } else {
                imageAware.setImageDrawable(null);
            }
            imageLoadingListener.onLoadingComplete((String)object, imageAware.getWrappedView(), null);
            return;
        }
        if (imageSize == null) {
            imageSize = ImageSizeUtils.defineTargetSizeForView(imageAware, this.configuration.getMaxImageSize());
        }
        String string = MemoryCacheUtils.generateKey((String)object, imageSize);
        this.engine.prepareDisplayTaskFor(imageAware, string);
        imageLoadingListener.onLoadingStarted((String)object, imageAware.getWrappedView());
        DecodedResult decodedResult = this.configuration.memoryCache.get(string);
        if (decodedResult != null && decodedResult.isDecoded()) {
            L.d(LOG_LOAD_IMAGE_FROM_MEMORY_CACHE, string);
            if (!displayImageOptions.shouldPostProcess()) {
                displayImageOptions.getDisplayer().display(decodedResult, imageAware, LoadedFrom.MEMORY_CACHE);
                imageLoadingListener.onLoadingComplete((String)object, imageAware.getWrappedView(), decodedResult);
                return;
            }
            object = new ImageLoadingInfo((String)object, imageAware, imageSize, string, displayImageOptions, imageLoadingListener, imageLoadingProgressListener, this.engine.getLockForUri((String)object));
            object = new ProcessAndDisplayImageTask(this.engine, decodedResult, (ImageLoadingInfo)object, ImageLoader.defineHandler(displayImageOptions));
            if (displayImageOptions.isSyncLoading()) {
                ((ProcessAndDisplayImageTask)object).run();
                return;
            }
            this.engine.submit((ProcessAndDisplayImageTask)object);
            return;
        }
        if (displayImageOptions.shouldShowImageOnLoading()) {
            imageAware.setImageDrawable(displayImageOptions.getImageOnLoading(this.configuration.resources));
        } else if (displayImageOptions.isResetViewBeforeLoading()) {
            imageAware.setImageDrawable(null);
        }
        object = new ImageLoadingInfo((String)object, imageAware, imageSize, string, displayImageOptions, imageLoadingListener, imageLoadingProgressListener, this.engine.getLockForUri((String)object));
        object = new LoadAndDisplayImageTask(this.engine, (ImageLoadingInfo)object, ImageLoader.defineHandler(displayImageOptions));
        if (displayImageOptions.isSyncLoading()) {
            ((LoadAndDisplayImageTask)object).run();
            return;
        }
        this.engine.submit((LoadAndDisplayImageTask)object);
    }

    public void displayImage(String string, ImageView imageView) {
        this.displayImage(string, new ImageViewAware(imageView), null, null, null);
    }

    public void displayImage(String string, ImageView imageView, ImageSize imageSize) {
        this.displayImage(string, new ImageViewAware(imageView), null, imageSize, null, null);
    }

    public void displayImage(String string, ImageView imageView, DisplayImageOptions displayImageOptions) {
        this.displayImage(string, new ImageViewAware(imageView), displayImageOptions, null, null);
    }

    public void displayImage(String string, ImageView imageView, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string, new ImageViewAware(imageView), null, imageLoadingListener, null);
    }

    public void displayImage(String string, ImageView imageView, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string, imageView, displayImageOptions, imageLoadingListener, null);
    }

    public void displayImage(String string, ImageView imageView, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.displayImage(string, new ImageViewAware(imageView), displayImageOptions, imageLoadingListener, imageLoadingProgressListener);
    }

    public void loadImage(String string, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string, null, null, imageLoadingListener, null);
    }

    public void loadImage(String string, ImageSize imageSize, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string, imageSize, null, imageLoadingListener, null);
    }

    public void loadImage(String string, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string, null, displayImageOptions, imageLoadingListener, null);
    }

    public void loadImage(String string, ImageSize imageSize, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string, imageSize, displayImageOptions, imageLoadingListener, null);
    }

    public void loadImage(String string, ImageSize object, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.checkConfiguration();
        if (object == null) {
            object = this.configuration.getMaxImageSize();
        }
        if (displayImageOptions == null) {
            displayImageOptions = this.configuration.defaultDisplayImageOptions;
        }
        object = new NonViewAware(string, (ImageSize)object, ViewScaleType.CROP);
        this.displayImage(string, (ImageAware)object, displayImageOptions, imageLoadingListener, imageLoadingProgressListener);
    }

    public Bitmap loadImageSync(String string) {
        return this.loadImageSync(string, null, null);
    }

    public Bitmap loadImageSync(String string, DisplayImageOptions displayImageOptions) {
        return this.loadImageSync(string, null, displayImageOptions);
    }

    public Bitmap loadImageSync(String string, ImageSize imageSize) {
        return this.loadImageSync(string, imageSize, null);
    }

    public Bitmap loadImageSync(String string, ImageSize imageSize, DisplayImageOptions displayImageOptions) {
        if (displayImageOptions == null) {
            displayImageOptions = this.configuration.defaultDisplayImageOptions;
        }
        displayImageOptions = new DisplayImageOptions.Builder().cloneFrom(displayImageOptions).syncLoading(true).build();
        SyncImageLoadingListener syncImageLoadingListener = new SyncImageLoadingListener();
        this.loadImage(string, imageSize, displayImageOptions, syncImageLoadingListener);
        return syncImageLoadingListener.getLoadedBitmap();
    }

    private void checkConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException(ERROR_NOT_INIT);
        }
    }

    public void setDefaultLoadingListener(ImageLoadingListener imageLoadingListener) {
        this.defaultListener = imageLoadingListener == null ? new SimpleImageLoadingListener() : imageLoadingListener;
    }

    public MemoryCache getMemoryCache() {
        this.checkConfiguration();
        return this.configuration.memoryCache;
    }

    public void clearMemoryCache() {
        this.checkConfiguration();
        this.configuration.memoryCache.clear();
    }

    @Deprecated
    public DiskCache getDiscCache() {
        return this.getDiskCache();
    }

    public DiskCache getDiskCache() {
        this.checkConfiguration();
        return this.configuration.diskCache;
    }

    @Deprecated
    public void clearDiscCache() {
        this.clearDiskCache();
    }

    public void clearDiskCache() {
        this.checkConfiguration();
        this.configuration.diskCache.clear();
    }

    public String getLoadingUriForView(ImageAware imageAware) {
        return this.engine.getLoadingUriForView(imageAware);
    }

    public String getLoadingUriForView(ImageView imageView) {
        return this.engine.getLoadingUriForView(new ImageViewAware(imageView));
    }

    public void cancelDisplayTask(ImageAware imageAware) {
        this.engine.cancelDisplayTaskFor(imageAware);
    }

    public void cancelDisplayTask(ImageView imageView) {
        this.engine.cancelDisplayTaskFor(new ImageViewAware(imageView));
    }

    public void denyNetworkDownloads(boolean bl2) {
        this.engine.denyNetworkDownloads(bl2);
    }

    public void handleSlowNetwork(boolean bl2) {
        this.engine.handleSlowNetwork(bl2);
    }

    public void pause() {
        this.engine.pause();
    }

    public void resume() {
        this.engine.resume();
    }

    public void stop() {
        this.engine.stop();
    }

    public void destroy() {
        if (this.configuration != null) {
            L.d(LOG_DESTROY, new Object[0]);
        }
        this.stop();
        this.configuration.diskCache.close();
        this.engine = null;
        this.configuration = null;
    }

    private static Handler defineHandler(DisplayImageOptions displayImageOptions) {
        Handler handler = displayImageOptions.getHandler();
        if (displayImageOptions.isSyncLoading()) {
            handler = null;
        } else if (handler == null && Looper.myLooper() == Looper.getMainLooper()) {
            handler = new Handler();
        }
        return handler;
    }

    static class SyncImageLoadingListener
    extends SimpleImageLoadingListener {
        private Bitmap loadedImage;

        private SyncImageLoadingListener() {
        }

        @Override
        public void onLoadingComplete(String string, View view, DecodedResult decodedResult) {
            this.loadedImage = decodedResult.mBitmap;
        }

        public Bitmap getLoadedBitmap() {
            return this.loadedImage;
        }
    }
}

