/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.assist.deque;

import com.kwad.sdk.core.imageloader.core.assist.deque.BlockingDeque;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    transient Node<E> first;
    transient Node<E> last;
    private transient int count;
    private final int capacity;
    final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n2;
    }

    public LinkedBlockingDeque(Collection<? extends E> object) {
        this(Integer.MAX_VALUE);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                if (e2 == null) {
                    throw new NullPointerException();
                }
                if (super.linkLast(new Node(e2))) continue;
                throw new IllegalStateException("Deque full");
            }
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private boolean linkFirst(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.first;
        node.next = node2;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        } else {
            node2.prev = node;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.last;
        node.prev = node2;
        this.last = node;
        if (this.first == null) {
            this.first = node;
        } else {
            node2.next = node;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private E unlinkFirst() {
        Node<E> node = this.first;
        if (node == null) {
            return null;
        }
        Node node2 = node.next;
        Object e2 = node.item;
        node.item = null;
        node.next = node;
        this.first = node2;
        if (node2 == null) {
            this.last = null;
        } else {
            node2.prev = null;
        }
        --this.count;
        this.notFull.signal();
        return e2;
    }

    private E unlinkLast() {
        Node<E> node = this.last;
        if (node == null) {
            return null;
        }
        Node node2 = node.prev;
        Object e2 = node.item;
        node.item = null;
        node.prev = node;
        this.last = node2;
        if (node2 == null) {
            this.first = null;
        } else {
            node2.next = null;
        }
        --this.count;
        this.notFull.signal();
        return e2;
    }

    void unlink(Node<E> node) {
        Node node2 = node.prev;
        Node node3 = node.next;
        if (node2 == null) {
            this.unlinkFirst();
            return;
        }
        if (node3 == null) {
            this.unlinkLast();
            return;
        }
        node2.next = node3;
        node3.prev = node2;
        node.item = null;
        --this.count;
        this.notFull.signal();
    }

    @Override
    public void addFirst(E e2) {
        if (!this.offerFirst(e2)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void addLast(E e2) {
        if (!this.offerLast(e2)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public boolean offerFirst(E object) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = this.linkFirst((Node<E>)object);
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean offerLast(E object) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = this.linkLast((Node<E>)object);
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void putFirst(E object) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            while (!this.linkFirst((Node<E>)object)) {
                this.notFull.await();
            }
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void putLast(E object) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            while (!this.linkLast((Node<E>)object)) {
                this.notFull.await();
            }
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean offerFirst(E object, long l2, TimeUnit timeUnit) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (!this.linkFirst((Node<E>)object)) {
                if (l3 <= 0L) {
                    return false;
                }
                l3 = this.notFull.awaitNanos(l3);
            }
            return true;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean offerLast(E object, long l2, TimeUnit timeUnit) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (!this.linkLast((Node<E>)object)) {
                if (l3 <= 0L) {
                    return false;
                }
                l3 = this.notFull.awaitNanos(l3);
            }
            return true;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E removeFirst() {
        E e2 = this.pollFirst();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    @Override
    public E removeLast() {
        E e2 = this.pollLast();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    @Override
    public E pollFirst() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2 = this.unlinkFirst();
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E pollLast() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2 = this.unlinkLast();
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E takeFirst() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2;
            while ((e2 = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E takeLast() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2;
            while ((e2 = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E pollFirst(long l2, TimeUnit timeUnit) {
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            E e2;
            while ((e2 = this.unlinkFirst()) == null) {
                if (l3 <= 0L) {
                    return null;
                }
                l3 = this.notEmpty.awaitNanos(l3);
            }
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E pollLast(long l2, TimeUnit timeUnit) {
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            E e2;
            while ((e2 = this.unlinkLast()) == null) {
                if (l3 <= 0L) {
                    return null;
                }
                l3 = this.notEmpty.awaitNanos(l3);
            }
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E getFirst() {
        E e2 = this.peekFirst();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    @Override
    public E getLast() {
        E e2 = this.peekLast();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    @Override
    public E peekFirst() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2 = this.first == null ? null : (E)this.first.item;
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E peekLast() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2 = this.last == null ? null : (E)this.last.item;
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    return true;
                }
                node = node.next;
            }
            return false;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.last;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    return true;
                }
                node = node.prev;
            }
            return false;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean add(E e2) {
        this.addLast(e2);
        return true;
    }

    @Override
    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public void put(E e2) {
        this.putLast(e2);
    }

    @Override
    public boolean offer(E e2, long l2, TimeUnit timeUnit) {
        return this.offerLast(e2, l2, timeUnit);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E take() {
        return this.takeFirst();
    }

    @Override
    public E poll(long l2, TimeUnit timeUnit) {
        return this.pollFirst(l2, timeUnit);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2 = this.capacity - this.count;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            n2 = Math.min(n2, this.count);
            for (int i2 = 0; i2 < n2; ++i2) {
                collection.add(this.first.item);
                this.unlinkFirst();
            }
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2 = this.count;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    return true;
                }
                node = node.next;
            }
            return false;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = new Object[this.count];
            int n2 = 0;
            Object object = this.first;
            while (object != null) {
                objectArray[n2++] = object.item;
                object = object.next;
            }
            object = objectArray;
            return object;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (objectArray.length < this.count) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
            }
            int n2 = 0;
            Object object = this.first;
            while (object != null) {
                objectArray[n2++] = object.item;
                object = object.next;
            }
            if (objectArray.length > n2) {
                objectArray[n2] = null;
            }
            object = objectArray;
            return object;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object object = this.first;
            if (object == null) {
                String string = "[]";
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            while (true) {
                Object e2;
                stringBuilder.append((Object)((e2 = ((Node)object).item) == this ? "(this Collection)" : e2));
                object = ((Node)object).next;
                if (object == null) {
                    object = stringBuilder.append(']').toString();
                    return object;
                }
                stringBuilder.append(',').append(' ');
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                node.item = null;
                Node node2 = node.next;
                node.prev = null;
                node.next = null;
                node = node2;
            }
            LinkedBlockingDeque linkedBlockingDeque = this;
            linkedBlockingDeque.last = null;
            linkedBlockingDeque.first = null;
            this.count = 0;
            this.notFull.signalAll();
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            objectOutputStream.defaultWriteObject();
            Node<E> node = this.first;
            while (node != null) {
                objectOutputStream.writeObject(node.item);
                node = node.next;
            }
            objectOutputStream.writeObject(null);
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        Object object;
        objectInputStream.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.last;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.prev;
        }
    }

    class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.first;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.next;
        }
    }

    abstract class AbstractItr
    implements Iterator<E> {
        Node<E> next;
        E nextItem;
        private Node<E> lastRet;

        abstract Node<E> firstNode();

        abstract Node<E> nextNode(Node<E> var1);

        AbstractItr() {
            LinkedBlockingDeque.this = ((LinkedBlockingDeque)LinkedBlockingDeque.this).lock;
            ((ReentrantLock)LinkedBlockingDeque.this).lock();
            try {
                this.next = this.firstNode();
                this.nextItem = this.next == null ? null : this.next.item;
                return;
            }
            finally {
                ((ReentrantLock)LinkedBlockingDeque.this).unlock();
            }
        }

        private Node<E> succ(Node<E> node) {
            Node node2;
            while ((node2 = this.nextNode(node)) != null) {
                if (node2.item != null) {
                    return node2;
                }
                if (node2 == node) {
                    return this.firstNode();
                }
                node = node2;
            }
            return null;
        }

        void advance() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                this.next = this.succ(this.next);
                this.nextItem = this.next == null ? null : this.next.item;
                return;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            Object e2 = this.nextItem;
            this.advance();
            return e2;
        }

        @Override
        public void remove() {
            Node node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                if (node.item != null) {
                    LinkedBlockingDeque.this.unlink(node);
                }
                return;
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    static final class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(E e2) {
            this.item = e2;
        }
    }
}

