/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.download;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import com.kwad.sdk.core.imageloader.core.assist.ContentLengthInputStream;
import com.kwad.sdk.core.imageloader.core.download.ImageDownloader;
import com.kwad.sdk.core.imageloader.utils.IoUtils;
import com.kwad.sdk.crash.utils.b;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class BaseImageDownloader
implements ImageDownloader {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 20000;
    protected static final int BUFFER_SIZE = 32768;
    protected static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    protected static final int MAX_REDIRECT_COUNT = 5;
    private static final String ERROR_UNSUPPORTED_SCHEME = "UIL doesn't support scheme(protocol) by default [%s]. You should implement this support yourself (BaseImageDownloader.getStreamFromOtherSource(...))";
    protected final Context context;
    protected final int connectTimeout;
    protected final int readTimeout;

    public BaseImageDownloader(Context context) {
        this(context, 5000, 20000);
    }

    public BaseImageDownloader(Context context, int n2, int n3) {
        this.context = context.getApplicationContext();
        this.connectTimeout = n2;
        this.readTimeout = n3;
    }

    @Override
    public InputStream getStream(String string, Object object) {
        switch (ImageDownloader.Scheme.ofUri(string)) {
            case HTTP: 
            case HTTPS: {
                return this.getStreamFromNetwork(string, object);
            }
            case FILE: {
                return this.getStreamFromFile(string, object);
            }
            case CONTENT: {
                return this.getStreamFromContent(string, object);
            }
            case ASSETS: {
                return this.getStreamFromAssets(string, object);
            }
            case DRAWABLE: {
                return this.getStreamFromDrawable(string, object);
            }
        }
        return this.getStreamFromOtherSource(string, object);
    }

    protected InputStream getStreamFromNetwork(String object, Object object2) {
        object = this.createConnection((String)object, object2);
        for (int i2 = 0; ((HttpURLConnection)object).getResponseCode() / 100 == 3 && i2 < 5; ++i2) {
            object = this.createConnection(((URLConnection)object).getHeaderField("Location"), object2);
        }
        try {
            object2 = ((URLConnection)object).getInputStream();
        }
        catch (IOException iOException) {
            IoUtils.readAndCloseStream(((HttpURLConnection)object).getErrorStream());
            throw iOException;
        }
        if (!this.shouldBeProcessed((HttpURLConnection)object)) {
            b.closeQuietly((Closeable)object2);
            throw new IOException("Image request failed with response code " + ((HttpURLConnection)object).getResponseCode());
        }
        return new ContentLengthInputStream(new BufferedInputStream((InputStream)object2, 32768), ((URLConnection)object).getContentLength());
    }

    protected boolean shouldBeProcessed(HttpURLConnection httpURLConnection) {
        return httpURLConnection.getResponseCode() == 200;
    }

    protected HttpURLConnection createConnection(String object, Object object2) {
        object = Uri.encode((String)object, (String)ALLOWED_URI_CHARS);
        object = (HttpURLConnection)new URL((String)object).openConnection();
        ((URLConnection)object).setConnectTimeout(this.connectTimeout);
        ((URLConnection)object).setReadTimeout(this.readTimeout);
        return object;
    }

    protected InputStream getStreamFromFile(String object, Object object2) {
        object2 = ImageDownloader.Scheme.FILE.crop((String)object);
        if (this.isVideoFileUri((String)object)) {
            return this.getVideoThumbnailStream((String)object2);
        }
        object = new BufferedInputStream(new FileInputStream((String)object2), 32768);
        return new ContentLengthInputStream((InputStream)object, (int)new File((String)object2).length());
    }

    @TargetApi(value=8)
    private InputStream getVideoThumbnailStream(String string) {
        if (Build.VERSION.SDK_INT >= 8 && (string = ThumbnailUtils.createVideoThumbnail((String)string, (int)2)) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            string.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream);
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        return null;
    }

    protected InputStream getStreamFromContent(String object, Object object2) {
        object2 = this.context.getContentResolver();
        if (this.isVideoContentUri((Uri)(object = Uri.parse((String)object)))) {
            Long l2 = Long.valueOf(object.getLastPathSegment());
            if ((l2 = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)object2, (long)l2, (int)1, null)) != null) {
                object = new ByteArrayOutputStream();
                l2.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)object);
                return new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            }
        }
        return object2.openInputStream((Uri)object);
    }

    protected InputStream getStreamFromAssets(String string, Object object) {
        string = ImageDownloader.Scheme.ASSETS.crop(string);
        return this.context.getAssets().open(string);
    }

    protected InputStream getStreamFromDrawable(String string, Object object) {
        string = ImageDownloader.Scheme.DRAWABLE.crop(string);
        int n2 = Integer.parseInt(string);
        return this.context.getResources().openRawResource(n2);
    }

    protected InputStream getStreamFromOtherSource(String string, Object object) {
        throw new UnsupportedOperationException(String.format(ERROR_UNSUPPORTED_SCHEME, string));
    }

    private boolean isVideoContentUri(Uri object) {
        object = this.context.getContentResolver().getType((Uri)object);
        return object != null && ((String)object).startsWith("video/");
    }

    private boolean isVideoFileUri(String string) {
        string = MimeTypeMap.getFileExtensionFromUrl((String)string);
        string = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string);
        return string != null && string.startsWith("video/");
    }
}

