/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.download;

import java.io.InputStream;
import java.util.Locale;

public interface ImageDownloader {
    public InputStream getStream(String var1, Object var2);

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https"),
        FILE("file"),
        CONTENT("content"),
        ASSETS("assets"),
        DRAWABLE("drawable"),
        UNKNOWN("");

        private String scheme;
        private String uriPrefix;

        private Scheme(String string2) {
            this.scheme = string2;
            this.uriPrefix = string2 + "://";
        }

        public static Scheme ofUri(String string) {
            if (string != null) {
                for (Scheme scheme : Scheme.values()) {
                    if (!scheme.belongsTo(string)) continue;
                    return scheme;
                }
            }
            return UNKNOWN;
        }

        private boolean belongsTo(String string) {
            return string.toLowerCase(Locale.US).startsWith(this.uriPrefix);
        }

        public final String wrap(String string) {
            return this.uriPrefix + string;
        }

        public final String crop(String string) {
            if (!this.belongsTo(string)) {
                throw new IllegalArgumentException(String.format("URI [%1$s] doesn't have expected scheme [%2$s]", string, this.scheme));
            }
            return string.substring(this.uriPrefix.length());
        }
    }
}

