/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.imageaware;

import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.kwad.sdk.core.imageloader.core.assist.ViewScaleType;
import com.kwad.sdk.core.imageloader.core.imageaware.ViewAware;
import com.kwad.sdk.utils.z;

public class ImageViewAware
extends ViewAware {
    public ImageViewAware(ImageView imageView) {
        super((View)imageView);
    }

    public ImageViewAware(ImageView imageView, boolean bl2) {
        super((View)imageView, bl2);
    }

    @Override
    public int getWidth() {
        ImageView imageView;
        int n2 = super.getWidth();
        if (n2 <= 0 && (imageView = (ImageView)this.viewRef.get()) != null) {
            n2 = ImageViewAware.getImageViewFieldValue(imageView, "mMaxWidth");
        }
        return n2;
    }

    @Override
    public int getHeight() {
        ImageView imageView;
        int n2 = super.getHeight();
        if (n2 <= 0 && (imageView = (ImageView)this.viewRef.get()) != null) {
            n2 = ImageViewAware.getImageViewFieldValue(imageView, "mMaxHeight");
        }
        return n2;
    }

    @Override
    public ViewScaleType getScaleType() {
        ImageView imageView = (ImageView)this.viewRef.get();
        if (imageView != null) {
            return ViewScaleType.fromImageView(imageView);
        }
        return super.getScaleType();
    }

    public ImageView getWrappedView() {
        return (ImageView)super.getWrappedView();
    }

    @Override
    protected void setImageDrawableInto(Drawable drawable, View view) {
        ((ImageView)view).setImageDrawable(drawable);
        if (drawable instanceof AnimationDrawable) {
            ((AnimationDrawable)drawable).start();
        }
    }

    @Override
    protected void setImageBitmapInto(Bitmap bitmap, View view) {
        ((ImageView)view).setImageBitmap(bitmap);
    }

    private static int getImageViewFieldValue(Object object, String string) {
        int n2 = 0;
        try {
            int n3 = (Integer)z.getField(object, string);
            if (n3 > 0 && n3 < Integer.MAX_VALUE) {
                n2 = n3;
            }
        }
        catch (Exception exception) {}
        return n2;
    }
}

