/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.imageaware;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import com.kwad.sdk.core.imageloader.core.assist.ViewScaleType;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageAware;
import com.kwad.sdk.core.imageloader.utils.L;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public abstract class ViewAware
implements ImageAware {
    public static final String WARN_CANT_SET_DRAWABLE = "Can't set a drawable into view. You should call ImageLoader on UI thread for it.";
    public static final String WARN_CANT_SET_BITMAP = "Can't set a bitmap into view. You should call ImageLoader on UI thread for it.";
    protected Reference<View> viewRef;
    protected boolean checkActualViewSize;

    public ViewAware(View view) {
        this(view, true);
    }

    public ViewAware(View view, boolean bl2) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        this.viewRef = new WeakReference<View>(view);
        this.checkActualViewSize = bl2;
    }

    @Override
    public int getWidth() {
        View view = this.viewRef.get();
        if (view != null) {
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            int n2 = 0;
            if (this.checkActualViewSize && layoutParams != null && layoutParams.width != -2) {
                n2 = view.getWidth();
            }
            if (n2 <= 0 && layoutParams != null) {
                n2 = layoutParams.width;
            }
            return n2;
        }
        return 0;
    }

    @Override
    public int getHeight() {
        View view = this.viewRef.get();
        if (view != null) {
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            int n2 = 0;
            if (this.checkActualViewSize && layoutParams != null && layoutParams.height != -2) {
                n2 = view.getHeight();
            }
            if (n2 <= 0 && layoutParams != null) {
                n2 = layoutParams.height;
            }
            return n2;
        }
        return 0;
    }

    @Override
    public ViewScaleType getScaleType() {
        return ViewScaleType.CROP;
    }

    @Override
    public View getWrappedView() {
        return this.viewRef.get();
    }

    @Override
    public boolean isCollected() {
        return this.viewRef.get() == null;
    }

    @Override
    public int getId() {
        View view = this.viewRef.get();
        if (view == null) {
            return super.hashCode();
        }
        return view.hashCode();
    }

    @Override
    public boolean setImageDrawable(Drawable drawable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            View view = this.viewRef.get();
            if (view != null) {
                this.setImageDrawableInto(drawable, view);
                return true;
            }
        } else {
            L.w(WARN_CANT_SET_DRAWABLE, new Object[0]);
        }
        return false;
    }

    @Override
    public boolean setImageBitmap(Bitmap bitmap) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            View view = this.viewRef.get();
            if (view != null) {
                this.setImageBitmapInto(bitmap, view);
                return true;
            }
        } else {
            L.w(WARN_CANT_SET_BITMAP, new Object[0]);
        }
        return false;
    }

    protected abstract void setImageDrawableInto(Drawable var1, View var2);

    protected abstract void setImageBitmapInto(Bitmap var1, View var2);
}

