/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.utils;

import android.opengl.GLES10;
import com.kwad.sdk.core.imageloader.core.assist.ImageSize;
import com.kwad.sdk.core.imageloader.core.assist.ViewScaleType;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageAware;

public final class ImageSizeUtils {
    private static final int DEFAULT_MAX_BITMAP_DIMENSION = 2048;
    private static ImageSize maxBitmapSize;

    private ImageSizeUtils() {
    }

    public static ImageSize defineTargetSizeForView(ImageAware imageAware, ImageSize imageSize) {
        int n2;
        int n3 = imageAware.getWidth();
        if (n3 <= 0) {
            n3 = imageSize.getWidth();
        }
        if ((n2 = imageAware.getHeight()) <= 0) {
            n2 = imageSize.getHeight();
        }
        return new ImageSize(n3, n2);
    }

    public static int computeImageSampleSize(ImageSize imageSize, ImageSize imageSize2, ViewScaleType viewScaleType, boolean bl2) {
        int n2 = imageSize.getWidth();
        int n3 = imageSize.getHeight();
        int n4 = imageSize2.getWidth();
        int n5 = imageSize2.getHeight();
        int n6 = 1;
        switch (viewScaleType) {
            case FIT_INSIDE: {
                if (bl2) {
                    int n7 = n2 / 2;
                    int n8 = n3 / 2;
                    while (n7 / n6 > n4 || n8 / n6 > n5) {
                        n6 *= 2;
                    }
                    break;
                }
                n6 = Math.max(n2 / n4, n3 / n5);
                break;
            }
            case CROP: {
                if (bl2) {
                    int n9 = n2 / 2;
                    int n10 = n3 / 2;
                    while (n9 / n6 > n4 && n10 / n6 > n5) {
                        n6 *= 2;
                    }
                    break;
                }
                n6 = Math.min(n2 / n4, n3 / n5);
            }
        }
        if (n6 <= 0) {
            n6 = 1;
        }
        n6 = ImageSizeUtils.considerMaxTextureSize(n2, n3, n6, bl2);
        return n6;
    }

    private static int considerMaxTextureSize(int n2, int n3, int n4, boolean bl2) {
        int n5 = maxBitmapSize.getWidth();
        int n6 = maxBitmapSize.getHeight();
        while (n2 / n4 > n5 || n3 / n4 > n6) {
            if (bl2) {
                n4 *= 2;
                continue;
            }
            ++n4;
        }
        return n4;
    }

    public static int computeMinImageSampleSize(ImageSize imageSize) {
        int n2 = imageSize.getWidth();
        int n3 = imageSize.getHeight();
        int n4 = maxBitmapSize.getWidth();
        int n5 = maxBitmapSize.getHeight();
        n2 = (int)Math.ceil((float)n2 / (float)n4);
        n3 = (int)Math.ceil((float)n3 / (float)n5);
        return Math.max(n2, n3);
    }

    public static float computeImageScale(ImageSize imageSize, ImageSize imageSize2, ViewScaleType viewScaleType, boolean bl2) {
        int n2;
        int n3 = imageSize.getWidth();
        int n4 = imageSize.getHeight();
        int n5 = imageSize2.getWidth();
        int n6 = imageSize2.getHeight();
        float f2 = (float)n3 / (float)n5;
        float f3 = (float)n4 / (float)n6;
        if (viewScaleType == ViewScaleType.FIT_INSIDE && f2 >= f3 || viewScaleType == ViewScaleType.CROP && f2 < f3) {
            n2 = n5;
            n6 = (int)((float)n4 / f2);
        } else {
            n2 = (int)((float)n3 / f3);
        }
        float f4 = 1.0f;
        if (!bl2 && n2 < n3 && n6 < n4 || bl2 && n2 != n3 && n6 != n4) {
            f4 = (float)n2 / (float)n3;
        }
        return f4;
    }

    static {
        int n2;
        int[] nArray = new int[1];
        GLES10.glGetIntegerv((int)3379, (int[])nArray, (int)0);
        int n3 = n2 = Math.max(nArray[0], 2048);
        maxBitmapSize = new ImageSize(n3, n3);
    }
}

