/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.utils;

import com.kwad.sdk.crash.utils.b;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public final class IoUtils {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final int DEFAULT_IMAGE_TOTAL_SIZE = 512000;
    public static final int CONTINUE_LOADING_PERCENTAGE = 75;

    private IoUtils() {
    }

    public static boolean copyStream(InputStream inputStream, OutputStream outputStream, CopyListener copyListener) {
        return IoUtils.copyStream(inputStream, outputStream, copyListener, 32768);
    }

    public static boolean copyStream(InputStream inputStream, OutputStream outputStream, CopyListener copyListener, int n2) {
        int n3;
        int n4 = 0;
        int n5 = inputStream.available();
        if (n5 <= 0) {
            n5 = 512000;
        }
        byte[] byArray = new byte[n2];
        if (IoUtils.shouldStopLoading(copyListener, 0, n5)) {
            return false;
        }
        while ((n3 = inputStream.read(byArray, 0, n2)) != -1) {
            outputStream.write(byArray, 0, n3);
            if (!IoUtils.shouldStopLoading(copyListener, n4 += n3, n5)) continue;
            return false;
        }
        outputStream.flush();
        return true;
    }

    private static boolean shouldStopLoading(CopyListener copyListener, int n2, int n3) {
        boolean bl2;
        return copyListener != null && !(bl2 = copyListener.onBytesCopied(n2, n3)) && 100 * n2 / n3 < 75;
    }

    public static void readAndCloseStream(InputStream inputStream) {
        byte[] byArray = new byte[32768];
        try {
            while (inputStream.read(byArray, 0, 32768) != -1) {
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            b.closeQuietly(inputStream);
        }
    }

    public static String inputStreamToString(InputStream inputStream) {
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        try {
            int n2;
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            while ((n2 = ((Reader)inputStreamReader).read(cArray, 0, 1024)) >= 0) {
                stringBuilder.append(cArray, 0, n2);
            }
        }
        catch (Exception exception) {
            b.closeQuietly(inputStreamReader);
            return null;
        }
        catch (Throwable throwable) {
            b.closeQuietly(inputStreamReader);
            throw throwable;
        }
        b.closeQuietly(inputStreamReader);
        return stringBuilder.toString();
    }

    public static interface CopyListener {
        public boolean onBytesCopied(int var1, int var2);
    }
}

