/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.network.idc;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.apache.http.conn.ConnectTimeoutException;

public class DomainException
extends Exception {
    private final Pattern CONNECT_ERR_PATTERN = Pattern.compile(".*(ECONN(RESET|REFUSED|ABORTED)|ETIMEDOUT|ENETUNREACH|EHOSTUNREACH).*", 2);
    private final int httpCode;

    public DomainException(int n2) {
        this(n2, null);
    }

    public DomainException(Throwable throwable) {
        this(-1, throwable);
    }

    public DomainException(int n2, Throwable throwable) {
        super(throwable);
        this.httpCode = n2;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    private Exception getInternal() {
        Throwable throwable = this.getCause();
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return null;
    }

    boolean isConnectException() {
        Object object = this.getInternal();
        if (object == null) {
            return false;
        }
        if (object instanceof SocketTimeoutException || object instanceof ConnectTimeoutException || object instanceof SocketException || object instanceof UnknownHostException) {
            return true;
        }
        if (object.getClass().getSimpleName().equalsIgnoreCase("ErrnoException") && (object = ((Throwable)object).getMessage()) != null) {
            return this.CONNECT_ERR_PATTERN.matcher((CharSequence)object).find();
        }
        return false;
    }
}

