/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.network;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.kwad.sdk.core.network.a;
import com.kwad.sdk.core.network.c;
import com.kwad.sdk.core.network.c.b;
import com.kwad.sdk.core.network.e;
import com.kwad.sdk.core.network.f;
import com.kwad.sdk.core.network.g;
import com.kwad.sdk.core.network.h;
import com.kwad.sdk.core.network.idc.DomainException;
import com.kwad.sdk.core.network.q;
import com.kwad.sdk.core.response.model.BaseResultData;
import com.kwad.sdk.export.proxy.AdHttpProxy;
import com.kwad.sdk.service.ServiceProvider;
import com.kwad.sdk.utils.ao;
import com.kwad.sdk.utils.bw;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class l<R extends f, T extends BaseResultData>
extends a<R> {
    private static final String TAG = "Networking";
    @Nullable
    private g<R, T> mListener = null;
    private final com.kwad.sdk.core.network.b.b mMonitorRecorder = com.kwad.sdk.core.network.b.c.HU();

    public void request(@NonNull g<R, T> g2) {
        try {
            this.onRequest(g2);
            this.fetch();
            return;
        }
        catch (Throwable throwable) {
            this.notifyOnErrorListener(null, e.aEv.errorCode, bw.s(throwable));
            this.reportSdkCaughtException(throwable);
            return;
        }
    }

    private void onRequest(@NonNull g<R, T> g2) {
        this.mMonitorRecorder.HN();
        this.mListener = g2;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.mListener = null;
    }

    private void setMonitorRequestId(@NonNull f object) {
        if ((object = object.getHeader()) != null && !TextUtils.isEmpty((CharSequence)(object = (String)object.get("kuaishou-tracing-token")))) {
            this.mMonitorRecorder.em((String)object);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @WorkerThread
    protected void fetchImpl() {
        f f2;
        block22: {
            f2 = null;
            this.mMonitorRecorder.HR();
            f2 = (f)this.createRequest();
            this.notifyOnStartRequest(f2);
            this.mMonitorRecorder.ei(f2.getUrl()).ej(f2.getUrl());
            this.setMonitorRequestId(f2);
            Object object = ServiceProvider.get(com.kwad.sdk.service.a.f.class);
            if (!ao.isNetworkConnected(object.getContext())) {
                this.notifyOnErrorListener(f2, e.aEo.errorCode, e.aEo.msg);
                this.mMonitorRecorder.dx(e.aEo.errorCode).ek(e.aEo.msg);
                break block22;
            }
            object = null;
            try {
                String string = f2.getUrl();
                AdHttpProxy adHttpProxy = com.kwad.sdk.g.AI();
                if (adHttpProxy instanceof b) {
                    this.mMonitorRecorder.el("ok_http").HQ();
                } else {
                    this.mMonitorRecorder.el("http").HQ();
                }
                object = this.isPostByJson() ? adHttpProxy.doPost(string, f2.getHeader(), f2.getBody()) : adHttpProxy.doPost(string, f2.getHeader(), f2.getBodyMap());
                com.kwad.sdk.core.d.c.i(TAG, "url: " + string + ", response: " + object);
            }
            catch (Exception exception) {
                this.notifyOnErrorListener(f2, e.aEv.errorCode, bw.s(exception));
                com.kwad.sdk.core.d.c.printStackTraceOnly(exception);
                this.mMonitorRecorder.ek("requestError:" + exception.getMessage());
            }
            this.mMonitorRecorder.HO().HP().dA(com.kwad.sdk.ip.direct.a.getType());
            try {
                this.onResponse(f2, (c)object);
            }
            catch (Exception exception) {
                this.notifyOnErrorListener(f2, e.aEv.errorCode, bw.s(exception));
                this.mMonitorRecorder.ek("onResponseError:" + exception.getMessage());
                com.kwad.sdk.core.d.c.printStackTraceOnly(exception);
            }
        }
        try {
            if (this.enableMonitorReport()) {
                this.mMonitorRecorder.report();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (Throwable throwable) {
            try {
                try {
                    this.mMonitorRecorder.ek("requestError:" + throwable.getMessage());
                }
                catch (Exception exception) {}
                this.notifyOnErrorListener(f2, e.aEv.errorCode, bw.s(throwable));
                com.kwad.sdk.core.d.c.printStackTrace(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    if (this.enableMonitorReport()) {
                        this.mMonitorRecorder.report();
                    }
                }
                catch (Exception exception) {}
                throw throwable2;
            }
            try {
                if (this.enableMonitorReport()) {
                    this.mMonitorRecorder.report();
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    @Override
    protected void onResponse(R r2, c c2) {
        T t2;
        if (c2 == null) {
            this.notifyOnErrorListener(r2, e.aEo.errorCode, e.aEo.msg);
            this.mMonitorRecorder.ek("responseBase is null");
            com.kwad.sdk.core.d.c.e(TAG, "request responseBase is null");
            return;
        }
        this.mMonitorRecorder.dx(c2.code);
        this.checkIpDirect(c2);
        if (TextUtils.isEmpty((CharSequence)c2.aEk) || !c2.Hx()) {
            this.notifyOnErrorListener(r2, c2, "\u7f51\u7edc\u9519\u8bef");
            this.mMonitorRecorder.ek("httpCodeError:" + c2.code + ":" + c2.aEk);
            com.kwad.sdk.core.d.c.w(TAG, "request responseBase httpCodeError:" + c2.code);
            return;
        }
        try {
            this.parseCommonData(r2.getUrl(), c2.aEk);
            t2 = this.parseData(c2.aEk);
            this.afterParseData(t2);
        }
        catch (Exception exception) {
            this.notifyOnErrorListener(r2, e.aEp.errorCode, e.aEp.msg);
            com.kwad.sdk.core.d.c.printStackTraceOnly(exception);
            this.mMonitorRecorder.ek("parseDataError:" + exception.getMessage());
            return;
        }
        if (c2.aEk != null) {
            this.mMonitorRecorder.az(c2.aEk.length()).HS().dz(((BaseResultData)t2).result);
        }
        if (!((BaseResultData)t2).isResultOk()) {
            this.mMonitorRecorder.ek("serverCodeError:" + ((BaseResultData)t2).result + ":" + ((BaseResultData)t2).errorMsg);
            if (((BaseResultData)t2).notifyFailOnResultError()) {
                this.notifyOnErrorListener(r2, ((BaseResultData)t2).result, ((BaseResultData)t2).errorMsg);
                return;
            }
        }
        if (((BaseResultData)t2).isDataEmpty()) {
            this.notifyOnErrorListener(r2, e.aEq.errorCode, !TextUtils.isEmpty((CharSequence)((BaseResultData)t2).testErrorMsg) ? ((BaseResultData)t2).testErrorMsg : e.aEq.msg);
            return;
        }
        this.checkAndSetHasData((BaseResultData)t2);
        this.notifyOnSuccess(r2, t2);
    }

    private void checkIpDirect(c object) {
        if (object == null) {
            return;
        }
        if (!((c)object).Hx() && (object = ServiceProvider.get(com.kwad.sdk.service.a.f.class)) != null && ao.isNetworkConnected(object.getContext())) {
            com.kwad.sdk.ip.direct.a.MI();
        }
    }

    private void checkAndSetHasData(BaseResultData baseResultData) {
        if (baseResultData.hasData()) {
            this.mMonitorRecorder.dy(1);
        }
    }

    private void parseCommonData(String string, String object) {
        try {
            object = new JSONObject(object);
            object = object.optString("requestSessionData");
            q.HB().U(string, (String)object);
            return;
        }
        catch (JSONException jSONException) {
            object = jSONException;
            jSONException.printStackTrace();
            return;
        }
    }

    protected boolean isPostByJson() {
        return true;
    }

    @NonNull
    protected abstract T parseData(String var1);

    protected void afterParseData(T t2) {
    }

    protected boolean enableMonitorReport() {
        return true;
    }

    protected boolean enableCrashReport() {
        return true;
    }

    private void notifyOnStartRequest(@NonNull R r2) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onStartRequest(r2);
    }

    private void notifyOnErrorListener(@NonNull R r2, c c2, String string) {
        String string2 = r2.getUrl();
        DomainException domainException = new DomainException(c2.aEi, (Throwable)c2.aEj);
        String string3 = this.getHostTypeByUrl(string2);
        com.kwad.sdk.core.network.idc.a.HF().a(string2, string3, domainException);
        this.notifyOnErrorListener(r2, c2.code, string);
    }

    private String getHostTypeByUrl(@NonNull String string) {
        string = string.contains("/rest/zt/emoticon/package/list") ? "zt" : "api";
        return string;
    }

    private void notifyOnErrorListener(@NonNull R r2, int n2, String string) {
        try {
            h.Hy().b((f)r2, n2);
        }
        catch (Throwable throwable) {
            this.reportSdkCaughtException(throwable);
        }
        if (this.mListener == null) {
            return;
        }
        this.mListener.onError(r2, n2, string);
        this.mMonitorRecorder.HT();
    }

    private void reportSdkCaughtException(Throwable throwable) {
        if (this.enableCrashReport()) {
            ServiceProvider.reportSdkCaughtException(throwable);
            return;
        }
        com.kwad.sdk.core.d.c.printStackTrace(throwable);
    }

    private void notifyOnSuccess(@NonNull R r2, T t2) {
        String string;
        if (com.kwad.sdk.core.network.idc.a.HF().HH() && "api".equals(string = this.getHostTypeByUrl(r2.getUrl()))) {
            com.kwad.sdk.core.network.idc.a.HF().ec(string);
        }
        if (this.mListener == null) {
            return;
        }
        this.mListener.onSuccess(r2, t2);
        this.mMonitorRecorder.HT();
    }
}

