/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.response.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kwad.sdk.commercial.e.a;
import com.kwad.sdk.components.d;
import com.kwad.sdk.core.a.e;
import com.kwad.sdk.core.b;
import com.kwad.sdk.core.d.c;
import com.kwad.sdk.core.response.model.AdGlobalConfigInfo;
import com.kwad.sdk.core.response.model.AdTemplate;
import com.kwad.sdk.core.response.model.AdVideoPreCacheConfig;
import com.kwad.sdk.core.response.model.BaseResultData;
import com.kwad.sdk.core.response.model.PageInfo;
import com.kwad.sdk.internal.api.SceneImpl;
import com.kwad.sdk.service.ServiceProvider;
import com.kwad.sdk.utils.aa;
import com.kwad.sdk.utils.ag;
import com.kwad.sdk.utils.bp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdResultData
extends BaseResultData
implements b {
    private static final String TAG = "AdResultData";
    private static final long serialVersionUID = -818939163644825380L;
    public String pcursor;
    public PageInfo pageInfo = new PageInfo();
    private List<AdTemplate> mAdTemplateList = new ArrayList<AdTemplate>();
    public AdGlobalConfigInfo adGlobalConfigInfo;
    private Map<Long, SceneImpl> mRequestAdSceneMap;
    public boolean hasMore;
    @Nullable
    protected String mOriginalJson;
    private SceneImpl mScene;
    private String mAdSource;
    public int mAdCacheId;

    public static AdResultData createFromResponseJson(String string2, SceneImpl b2) {
        JSONObject jSONObject = new JSONObject(string2);
        b2 = new AdResultData((SceneImpl)b2);
        ((AdResultData)b2).parseJson(jSONObject);
        ((AdResultData)b2).mOriginalJson = string2;
        return b2;
    }

    public AdResultData() {
    }

    public AdResultData(SceneImpl sceneImpl) {
        this.mScene = sceneImpl;
        if (sceneImpl != null) {
            this.mRequestAdSceneMap = new HashMap<Long, SceneImpl>(1);
            this.mRequestAdSceneMap.put(sceneImpl.getPosId(), sceneImpl);
        }
    }

    public AdResultData(BaseResultData baseResultData, SceneImpl sceneImpl, List<AdTemplate> list) {
        this(sceneImpl);
        if (baseResultData == null) {
            return;
        }
        super.parseJson(baseResultData.baseToJson());
        if (list != null) {
            this.getAdTemplateList().addAll(list);
        }
    }

    public AdResultData(List<SceneImpl> list) {
        this.setRequestAdSceneList(list);
    }

    public void setRequestAdSceneList(List<SceneImpl> object) {
        if (object != null) {
            this.mRequestAdSceneMap = new HashMap<Long, SceneImpl>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                SceneImpl sceneImpl = (SceneImpl)object.next();
                this.mRequestAdSceneMap.put(sceneImpl.getPosId(), sceneImpl);
            }
        }
    }

    @NonNull
    public List<AdTemplate> getProceedTemplateList() {
        ArrayList<AdTemplate> arrayList = new ArrayList<AdTemplate>();
        List<AdTemplate> list = this.getAdTemplateList();
        if (list == null) {
            return arrayList;
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AdTemplate adTemplate = list.get(i2);
            arrayList.add(adTemplate);
        }
        return arrayList;
    }

    public AdTemplate getFirstAdTemplate() {
        List<AdTemplate> list = this.getAdTemplateList();
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public boolean isBidding() {
        List<AdTemplate> list = this.getProceedTemplateList();
        if (list.size() == 0) {
            return false;
        }
        int n2 = com.kwad.sdk.core.response.b.e.ez(list.get(0));
        return n2 > 0;
    }

    public SceneImpl getDefaultAdScene() {
        AdResultData adResultData = this;
        return adResultData.getAdScene(adResultData.getPosId());
    }

    public long getPosId() {
        List<AdTemplate> list = this.getProceedTemplateList();
        if (list.size() == 0) {
            return 0L;
        }
        return list.get((int)0).posId;
    }

    public SceneImpl getAdScene(long l2) {
        SceneImpl sceneImpl = null;
        if (this.mRequestAdSceneMap != null) {
            sceneImpl = this.mRequestAdSceneMap.get(l2);
        }
        if (sceneImpl == null) {
            return new SceneImpl(l2);
        }
        return sceneImpl;
    }

    public String getAdSource() {
        if (this.mAdSource != null) {
            return this.mAdSource;
        }
        return "network";
    }

    public void setAdSource(String string2) {
        this.mAdSource = string2;
    }

    @Override
    public void parseJson(JSONObject jSONObject) {
        block14: {
            super.parseJson(jSONObject);
            if (jSONObject == null) {
                return;
            }
            try {
                String string2;
                this.pcursor = jSONObject.optString("pcursor");
                this.hasMore = jSONObject.optBoolean("hasMore");
                String string3 = jSONObject.optString("adGlobalConfigInfo");
                e e2 = d.f(e.class);
                if (!bp.isNullString(string3)) {
                    string3 = e2.getResponseData(string3);
                    this.adGlobalConfigInfo = new AdGlobalConfigInfo();
                    this.adGlobalConfigInfo.parseJson(new JSONObject(string3));
                    ag.c(ServiceProvider.getContext(), this.adGlobalConfigInfo.uaidEnable);
                }
                try {
                    string3 = jSONObject.optString("pageInfo");
                    if (!bp.isNullString(string3)) {
                        string2 = e2.getResponseData(string3);
                        this.pageInfo.parseJson(new JSONObject(string2));
                    }
                }
                catch (Exception exception) {
                    c.d("json bug", exception.toString());
                    c.printStackTrace(exception);
                }
                string3 = jSONObject.optString("impAdInfo");
                if (!TextUtils.isEmpty((CharSequence)string3) && !bp.isNullString(string2 = e2.getResponseData(string3))) {
                    try {
                        jSONObject = null;
                        try {
                            jSONObject = new JSONArray(string2);
                        }
                        catch (Throwable throwable) {
                            a.a(this.mScene, this.llsid, string3, string2);
                        }
                        if (jSONObject != null && jSONObject.length() > 0) {
                            for (int i2 = 0; i2 < jSONObject.length(); ++i2) {
                                JSONObject jSONObject2 = jSONObject.optJSONObject(i2);
                                if (jSONObject2 == null) continue;
                                AdTemplate adTemplate = new AdTemplate();
                                adTemplate.parseJson(jSONObject2);
                                adTemplate.llsid = this.llsid;
                                adTemplate.extra = this.extra;
                                adTemplate.mAdScene = this.getAdScene(adTemplate.posId);
                                adTemplate.mPageInfo = this.pageInfo;
                                this.mAdTemplateList.add(adTemplate);
                                a.bM(adTemplate);
                                if (this.mScene == null || AdResultData.styleMatch(this.mScene, adTemplate)) continue;
                                int n2 = adTemplate.adStyle;
                                adTemplate.adStyle = this.mScene.adStyle;
                                a.c(adTemplate, "ad_style", String.valueOf(n2));
                            }
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        a.a(this.mScene, this.llsid, string3);
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                c.printStackTrace(throwable);
            }
        }
    }

    private static boolean styleMatch(SceneImpl sceneImpl, AdTemplate adTemplate) {
        int n2 = sceneImpl.adStyle;
        int n3 = adTemplate.adStyle;
        if (n2 == 13) {
            return n3 == 13 || n3 == 23;
        }
        return n2 == n3;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jSONObject = super.toJson();
        aa.putValue(jSONObject, "pcursor", this.pcursor);
        aa.putValue(jSONObject, "hasMore", this.hasMore);
        aa.a(jSONObject, "pageInfo", this.pageInfo);
        aa.putValue(jSONObject, "impAdInfo", this.getAdTemplateList());
        aa.a(jSONObject, "adGlobalConfigInfo", this.adGlobalConfigInfo);
        if (this.mAdCacheId != 0) {
            aa.putValue(jSONObject, "adCacheId", this.mAdCacheId);
        }
        return jSONObject;
    }

    public boolean isAdResultDataEmpty() {
        List<AdTemplate> list = this.getAdTemplateList();
        if (list.isEmpty()) {
            c.w(TAG, "adTemplateList is empty");
            return true;
        }
        c.d(TAG, "adTemplateList size = " + list.size());
        list = list.get(0);
        list = ((AdTemplate)((Object)list)).adInfoList;
        if (list.isEmpty()) {
            c.w(TAG, "adInfoList is empty");
            return true;
        }
        if ((list = list.get(0)) == null) {
            c.w(TAG, "adInfo is null");
            return true;
        }
        return false;
    }

    @Override
    public boolean isDataEmpty() {
        return false;
    }

    @NonNull
    public AdResultData clone() {
        AdResultData adResultData = new AdResultData();
        try {
            JSONObject jSONObject = this.toJson();
            adResultData.parseJson(jSONObject);
            return adResultData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            c.printStackTraceOnly(throwable);
            return adResultData;
        }
    }

    public String getResponseJson() {
        if (this.mOriginalJson != null) {
            return this.mOriginalJson;
        }
        JSONObject jSONObject = super.toJson();
        aa.putValue(jSONObject, "pcursor", this.pcursor);
        aa.a(jSONObject, "pageInfo", this.pageInfo);
        String string2 = aa.S(this.getAdTemplateList()).toString();
        e e2 = d.f(e.class);
        aa.putValue(jSONObject, "impAdInfo", e2.as(string2));
        return jSONObject.toString();
    }

    public List<AdTemplate> getAdTemplateList() {
        return this.mAdTemplateList;
    }

    public void setAdTemplateList(List<AdTemplate> list) {
        this.mAdTemplateList = list;
    }

    public static AdVideoPreCacheConfig obtainVideoPreCacheConfig(AdResultData adResultData, int n2) {
        if (adResultData == null) {
            return null;
        }
        if (adResultData.adGlobalConfigInfo != null && adResultData.adGlobalConfigInfo.adVideoPreCacheConfig != null) {
            return adResultData.adGlobalConfigInfo.adVideoPreCacheConfig;
        }
        return new AdVideoPreCacheConfig(n2, false);
    }
}

