/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.response.model;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ksad.json.annotation.KsJson;
import com.kwad.sdk.core.b;
import com.kwad.sdk.core.d.c;
import com.kwad.sdk.core.response.a.a;
import java.io.Serializable;
import java.text.DecimalFormat;

@KsJson
public class CouponInfo
extends a
implements b,
Serializable {
    private static final long serialVersionUID = -9143537899646897962L;
    private static final float COUPON_DISCOUNT_THRESHOLD = 20.0f;
    public static final String JINNIIU_PRICE_BREAK_DISCOUNT = "1";
    public static final String JINNIIU_DISCOUNT = "2";
    public String displayName;
    public String displayTitle;
    public String displayValue;
    public String displayBase;
    public String displayType;
    public String displayActionWords;
    public String displayDiscount;
    public String startFetchTime;
    public String endFetchTime;

    public String getStartFetchTime() {
        return this.startFetchTime;
    }

    public void setStartFetchTime(String string2) {
        this.startFetchTime = string2;
    }

    public String getEndFetchTime() {
        return this.endFetchTime;
    }

    public void setEndFetchTime(String string2) {
        this.endFetchTime = string2;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public String getDisplayBase() {
        return this.displayBase;
    }

    public boolean isNoPreRequirement() {
        if (this.displayBase == null) {
            return false;
        }
        try {
            boolean bl2 = Float.parseFloat(this.displayBase) <= 0.0f;
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public String getFormattedJinniuPrefix() {
        String string2 = null;
        String string3 = this.getDisplayType();
        if (this.isNoPreRequirement()) {
            string2 = "\u5238";
        } else if (JINNIIU_PRICE_BREAK_DISCOUNT.equals(string3)) {
            string2 = "\u6ee1";
        } else if (JINNIIU_DISCOUNT.equals(string3)) {
            string2 = "\u5238";
        }
        return string2;
    }

    public String getDisplayActionWords() {
        return this.displayActionWords;
    }

    @Nullable
    public String getFormattedDisplayDiscount() {
        try {
            float f2 = Float.valueOf(this.displayDiscount).floatValue() / 10.0f;
            return new DecimalFormat("#.#").format(f2);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            c.printStackTraceOnly(exception);
            return null;
        }
    }

    public void setDisplayDiscount(String string2) {
        this.displayDiscount = string2;
    }

    @Nullable
    public static String jinniuFormatCoupon(CouponInfo couponInfo) {
        if (couponInfo == null) {
            return null;
        }
        String string2 = null;
        String string3 = couponInfo.getDisplayType();
        String string4 = couponInfo.getDisplayValue();
        string4 = CouponInfo.rinToYuan(string4);
        int n2 = -1;
        switch (string3.hashCode()) {
            case 49: {
                if (!string3.equals(JINNIIU_PRICE_BREAK_DISCOUNT)) break;
                n2 = 0;
                break;
            }
            case 50: {
                if (!string3.equals(JINNIIU_DISCOUNT)) break;
                n2 = 1;
            }
        }
        switch (n2) {
            case 0: {
                string3 = couponInfo.getDisplayBase();
                string3 = CouponInfo.rinToYuan(string3);
                if (TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4)) break;
                if (couponInfo.isNoPreRequirement()) {
                    string2 = "\u00a5" + string4;
                    break;
                }
                string2 = string3 + "\u51cf" + string4;
                break;
            }
            case 1: {
                if (TextUtils.isEmpty((CharSequence)string4)) break;
                try {
                    float f2;
                    float f3 = Float.parseFloat(string4);
                    if (f2 >= 20.0f) {
                        string2 = "\u00a5" + string4;
                        break;
                    }
                    string2 = couponInfo.getFormattedDisplayDiscount() + "\u6298";
                    break;
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
        }
        return string2;
    }

    @Nullable
    public static String rinToYuan(String object) {
        if (object == null) {
            return null;
        }
        String string2 = null;
        try {
            float f2 = Float.parseFloat((String)object) / 1000.0f;
            string2 = new DecimalFormat("#.#").format(f2);
        }
        catch (Exception exception) {
            object = exception;
            c.printStackTraceOnly(exception);
        }
        return string2;
    }
}

