/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.videocache;

import android.text.TextUtils;
import com.kwad.sdk.core.network.a.d;
import com.kwad.sdk.core.videocache.InterruptedProxyCacheException;
import com.kwad.sdk.core.videocache.ProxyCacheException;
import com.kwad.sdk.core.videocache.d.b;
import com.kwad.sdk.core.videocache.d.c;
import com.kwad.sdk.core.videocache.l;
import com.kwad.sdk.core.videocache.n;
import com.kwad.sdk.core.videocache.p;
import com.kwad.sdk.utils.ax;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionSpec;
import okhttp3.Dns;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public final class j
extends p {
    private final c aKN;
    private final com.kwad.sdk.core.videocache.b.b aKO;
    private n aLl;
    private InputStream aLn;
    private OkHttpClient aLs = new OkHttpClient();

    public j(String string2, c object, com.kwad.sdk.core.videocache.b.b b2) {
        this.aKN = ax.checkNotNull(object);
        this.aKO = ax.checkNotNull(b2);
        object = object.eS(string2);
        this.aLl = object != null ? object : new n(string2, Integer.MIN_VALUE, l.eQ(string2));
    }

    public j(j j2) {
        this.aLl = j2.aLl;
        this.aKN = j2.aKN;
        this.aKO = j2.aKO;
    }

    @Override
    public final synchronized long length() {
        if (this.aLl.aLB == Integer.MIN_VALUE) {
            this.Kv();
        }
        if (this.aLl.aLB == Integer.MIN_VALUE) {
            this.Kt();
        }
        return this.aLl.aLB;
    }

    private void Kv() {
        n n2;
        if (this.aKN != null && this.aKN instanceof b && (n2 = this.aKN.eS(this.getUrl())) != null && !TextUtils.isEmpty((CharSequence)n2.aLC) && n2.aLB != Integer.MIN_VALUE) {
            this.aLl = n2;
        }
    }

    @Override
    public final void aK(long l2) {
        try {
            Response response = this.f(l2, -1);
            String string2 = response.body().contentType().toString();
            long l3 = this.a(response, l2);
            this.aLn = new BufferedInputStream(response.body().byteStream(), 1024);
            this.aLl = new n(this.aLl.url, l3, string2);
            this.aKN.a(this.aLl.url, this.aLl);
            return;
        }
        catch (IOException iOException) {
            throw new ProxyCacheException("Error opening connection for " + this.getUrl() + " with offset " + l2, iOException);
        }
    }

    private long a(Response response, long l2) {
        int n2 = response.code();
        long l3 = response.body().contentLength();
        if (n2 == 200) {
            return l3;
        }
        if (n2 == 206) {
            return l3 + l2;
        }
        return this.aLl.aLB;
    }

    @Override
    public final void close() {
        com.kwad.sdk.crash.utils.b.closeQuietly(this.aLn);
    }

    @Override
    public final int read(byte[] byArray) {
        if (this.aLn == null) {
            throw new ProxyCacheException("Error reading data from " + this.aLl.url + ": connection is absent!");
        }
        try {
            return this.aLn.read(byArray, 0, 1024);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedProxyCacheException("Reading source " + this.aLl.url + " is interrupted", interruptedIOException);
        }
        catch (IOException iOException) {
            throw new ProxyCacheException("Error reading data from " + this.aLl.url, iOException);
        }
    }

    private void Kt() {
        block7: {
            Response response = null;
            try {
                response = this.dP(10000);
                if (response == null || !response.isSuccessful()) {
                    throw new ProxyCacheException("Fail to fetchContentInfo: " + this.getUrl());
                }
                long l2 = j.c(response);
                String string2 = response.header("Content-Type");
                this.aLl = new n(this.aLl.url, l2, string2);
                this.aKN.a(this.aLl.url, this.aLl);
                com.kwad.sdk.core.d.c.d("HttpUrlSource", "Source info fetched: " + this.aLl);
            }
            catch (IOException iOException) {
                com.kwad.sdk.core.d.c.e("HttpUrlSource", "Error fetching info from " + this.aLl.url);
                return;
            }
            finally {
                if (response == null || response.body() == null) break block7;
                com.kwad.sdk.crash.utils.b.closeQuietly((Closeable)response.body());
            }
            if (response != null && response.body() != null) {
                com.kwad.sdk.crash.utils.b.closeQuietly((Closeable)response.body());
                return;
            }
        }
    }

    private static long c(Response object) {
        if ((object = object.header("Content-Length")) == null) {
            return -1L;
        }
        return Long.parseLong((String)object);
    }

    private Response f(long l2, int n2) {
        Throwable throwable;
        OkHttpClient.Builder builder = this.aLs.newBuilder();
        builder.connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT));
        try {
            builder.dns((Dns)new d());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            com.kwad.sdk.core.d.c.printStackTrace(throwable2);
        }
        this.aLs = builder.build();
        boolean bl2 = false;
        String string2 = this.getUrl();
        int n3 = 0;
        do {
            throwable = new Request.Builder();
            throwable.get();
            throwable.url(string2);
            if (l2 > 0L) {
                throwable.addHeader("Range", "bytes=" + l2 + "-");
            }
            if ((throwable = this.aLs.newCall(throwable.build()).execute()).isRedirect()) {
                string2 = throwable.header("Location");
                bl2 = throwable.isRedirect();
                ++n3;
            }
            if (n3 <= 5) continue;
            throw new ProxyCacheException("Too many redirects: " + n3);
        } while (bl2);
        return throwable;
    }

    private Response dP(int n2) {
        Throwable throwable;
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        builder.connectTimeout(10000L, TimeUnit.MILLISECONDS);
        builder.readTimeout(10000L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(10000L, TimeUnit.MILLISECONDS);
        builder.connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT));
        try {
            builder.dns((Dns)new d());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            com.kwad.sdk.core.d.c.printStackTrace(throwable2);
        }
        this.aLs = builder.build();
        boolean bl2 = false;
        String string2 = this.getUrl();
        int n3 = 0;
        do {
            throwable = new Request.Builder();
            throwable.head();
            throwable.url(string2);
            throwable = this.aLs.newCall(throwable.build()).execute();
            if (throwable.isRedirect()) {
                string2 = throwable.header("Location");
                bl2 = throwable.isRedirect();
                ++n3;
            }
            if (n3 <= 5) continue;
            throw new ProxyCacheException("Too many redirects: " + n3);
        } while (bl2);
        return throwable;
    }

    @Override
    public final synchronized String Ku() {
        if (TextUtils.isEmpty((CharSequence)this.aLl.aLC)) {
            this.Kv();
        }
        if (TextUtils.isEmpty((CharSequence)this.aLl.aLC)) {
            this.Kt();
        }
        return this.aLl.aLC;
    }

    @Override
    public final String getUrl() {
        return this.aLl.url;
    }

    @Override
    public final String toString() {
        return "HttpUrlSource{sourceInfo='" + this.aLl + "}";
    }
}

