/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.crash.handler;

import android.app.ActivityManager;
import android.os.Build;
import android.os.FileObserver;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.Process;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Printer;
import com.kwad.sdk.core.d.c;
import com.kwad.sdk.crash.e;
import com.kwad.sdk.crash.f;
import com.kwad.sdk.crash.handler.b;
import com.kwad.sdk.crash.model.message.AnrExceptionMessage;
import com.kwad.sdk.crash.model.message.AnrReason;
import com.kwad.sdk.crash.model.message.ExceptionMessage;
import com.kwad.sdk.crash.utils.g;
import com.kwad.sdk.utils.SystemUtil;
import com.kwad.sdk.utils.h;
import com.kwad.sdk.utils.w;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;

@Keep
public final class AnrHandler
extends b {
    private static final String TAG = "AnrHandler";
    private static final String ANR_HAPPENED_BEGIN = "------ ANR Happened Begin ------\n";
    private static final long PARSE_TRACE_INTERVAL = 10000L;
    private static final long GET_REASON_INTERVAL = 500L;
    private static final long TRY_TIMES = 20L;
    private static final String DEFAULT_TRACE_ROOT = "/data/anr/";
    private static long sLastTime = 0L;
    private static final int MY_PID = Process.myPid();
    private static final Pattern PID_PATTERN = Pattern.compile("-{5}\\spid\\s\\d+\\sat\\s\\d+-\\d+-\\d+\\s\\d{2}:\\d{2}:\\d{2}\\s-{5}");
    private static final boolean DUMP_FROM_SIG_QUIT = SystemUtil.eX(21);
    private FileObserver mTraceFileObserver;

    private AnrHandler() {
    }

    public static AnrHandler getInstance() {
        return a.aPc;
    }

    @Override
    public final void init(File file, f f2, com.kwad.sdk.crash.report.e e2) {
        super.init(file, f2, e2);
        if (!com.kwad.sdk.crash.b.La()) {
            return;
        }
        c.d(TAG, "ANR init ");
        this.mLogDir = file;
        if (!this.mLogDir.exists()) {
            this.mLogDir.mkdirs();
        }
        this.mDumpDir = new File(this.mLogDir, FILE_NAME_BASE + "-anr");
        new File(this.mLogDir, FILE_NAME_BASE);
        if (!DUMP_FROM_SIG_QUIT) {
            this.watchTraceFile();
            return;
        }
        try {
            if (Build.VERSION.SDK_INT < 23) {
                file = new Handler(Looper.getMainLooper());
                file.post(new Runnable(){

                    @Override
                    public final void run() {
                        c.e(AnrHandler.TAG, "install in main:");
                        AnrHandler.install(AnrHandler.this.mDumpDir.getPath(), Build.VERSION.SDK_INT);
                    }
                });
                return;
            }
            Looper.getMainLooper().getQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                public final boolean queueIdle() {
                    c.e(AnrHandler.TAG, "install in Idle");
                    AnrHandler.install(AnrHandler.this.mDumpDir.getPath(), Build.VERSION.SDK_INT);
                    return false;
                }
            });
        }
        catch (Throwable throwable) {
            this.getUploader();
        }
    }

    private void watchTraceFile() {
        c.d(TAG, "ANR watchTraceFile");
        this.mTraceFileObserver = new FileObserver(DEFAULT_TRACE_ROOT, 8){

            public final void onEvent(int n2, @Nullable String string2) {
                if (string2 != null) {
                    String string3 = AnrHandler.DEFAULT_TRACE_ROOT + string2;
                    AnrHandler.this.onTraceFileWritten(string3);
                }
            }
        };
        try {
            this.mTraceFileObserver.startWatching();
            return;
        }
        catch (Throwable throwable) {
            AnrHandler.getInstance().getUploader();
            return;
        }
    }

    private void onTraceFileWritten(String string2) {
        c.d(TAG, "ANR onTraceFileWritten");
        if (this.parseTraceFile(string2)) {
            h.execute(new Runnable(){

                @Override
                public final void run() {
                    AnrHandler.getInstance().dumpAnr(null, AnrHandler.this.mIndex.getAndIncrement());
                }
            });
        }
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean parseTraceFile(String string2) {
        boolean bl2;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
            int n2 = -1;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!PID_PATTERN.matcher(string2).matches()) continue;
                n2 = Integer.parseInt(string2.split("\\s")[2]);
                break;
            }
            bl2 = n2 == MY_PID;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getUploader();
            com.kwad.sdk.crash.utils.b.closeQuietly(bufferedReader);
        }
        catch (IOException iOException) {
            this.getUploader();
            {
                catch (Throwable throwable) {
                    com.kwad.sdk.crash.utils.b.closeQuietly(bufferedReader);
                    throw throwable;
                }
            }
            com.kwad.sdk.crash.utils.b.closeQuietly(bufferedReader);
        }
        com.kwad.sdk.crash.utils.b.closeQuietly(bufferedReader);
        return bl2;
        return false;
    }

    @Keep
    public static void onCallFromNative(int n2) {
    }

    @Keep
    public static synchronized String getMainThreadStackTrace() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            StackTraceElement[] stackTraceElementArray = Looper.getMainLooper().getThread().getStackTrace();
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            stackTraceElementArray2 = stackTraceElementArray;
            int n2 = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[i2];
                stringBuilder.append("  at ").append(stackTraceElement).append("\n");
            }
            return stringBuilder.append("\n").toString();
        }
        catch (Throwable throwable) {
            c.e(TAG, Log.getStackTraceString((Throwable)throwable));
            return "";
        }
    }

    @Keep
    public static boolean isRealNotResponding(final int n2) {
        c.d(TAG, "judge isRealNotResponding");
        try {
            isExceptionHappened.set(true);
            sCrashingPid = String.valueOf(Process.myPid());
            h.execute(new Runnable(){

                @Override
                public final void run() {
                    AnrHandler.getInstance().dumpAnr(null, n2);
                }
            });
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return true;
        }
    }

    private static boolean checkErrorState() {
        try {
            c.i(TAG, "[checkErrorState] start");
            Object object = com.kwad.sdk.core.c.b.Ho().getApplication();
            object = (ActivityManager)object.getSystemService("activity");
            object = object.getProcessesInErrorState();
            if (object == null) {
                c.i(TAG, "[checkErrorState] procs == null");
                return false;
            }
            object = object.iterator();
            while (object.hasNext()) {
                ActivityManager.ProcessErrorStateInfo processErrorStateInfo = (ActivityManager.ProcessErrorStateInfo)object.next();
                if (processErrorStateInfo.uid != Process.myUid() && processErrorStateInfo.condition == 2) {
                    c.i(TAG, "maybe received other apps ANR signal");
                    return false;
                }
                if (processErrorStateInfo.pid != Process.myPid() || processErrorStateInfo.condition != 2) continue;
                c.i(TAG, "error sate longMsg = " + processErrorStateInfo.longMsg);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            c.e(TAG, "[checkErrorState] error : " + throwable.getMessage());
            return false;
        }
    }

    private synchronized void dumpAnr(@Nullable String string2, int n2) {
        c.d(TAG, "ANR dumpAnr tracePath=" + string2 + " index=" + n2);
        AnrExceptionMessage anrExceptionMessage = new AnrExceptionMessage();
        File file = new File(this.mDumpDir.toString() + "-" + n2);
        Object object = AnrHandler.getInstance().mLogDir;
        boolean bl2 = true;
        try {
            Object object2;
            CharSequence charSequence;
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                c.d(TAG, "ANR dumpAnr create dir failed.");
                anrExceptionMessage.mErrorMessage = anrExceptionMessage.mErrorMessage + "create " + ((File)object).getPath() + " failed!\n";
                bl2 = false;
            }
            if (!file.exists() && !file.mkdirs()) {
                c.d(TAG, "ANR dumpAnr create dir failed.");
                anrExceptionMessage.mErrorMessage = anrExceptionMessage.mErrorMessage + "create " + this.mDumpDir.getPath() + " failed!\n";
                bl2 = false;
            }
            g.b(null, anrExceptionMessage, e.Lr().getContext());
            g.a((ExceptionMessage)anrExceptionMessage, 3);
            File file2 = new File(file, "dump");
            if (string2 != null && bl2) {
                w.f(new File(string2), file2);
            }
            g.F(new File(file, "logcat"));
            try {
                charSequence = new StringBuilder();
                object2 = new Printer((StringBuilder)charSequence){
                    final /* synthetic */ StringBuilder aPb;
                    {
                        this.aPb = stringBuilder;
                    }

                    public final void println(String string2) {
                        this.aPb.append(string2).append("\n");
                    }
                };
                Looper.getMainLooper().dump((Printer)object2, "");
                anrExceptionMessage.mMessageQueueDetail = charSequence.substring(0, charSequence.length() - 1);
            }
            catch (Exception exception) {
                anrExceptionMessage.mErrorMessage = anrExceptionMessage.mErrorMessage + Log.getStackTraceString((Throwable)exception) + "\n";
            }
            try {
                anrExceptionMessage.mLogUUID = g.fU(file2.getName());
                charSequence = anrExceptionMessage.toJson().toString();
                object2 = new File(file, "message");
                g.a((File)object2, charSequence);
                AnrHandler.getInstance().backupLogFiles((File)object);
                object = AnrHandler.getInstance().getUploader();
                if (object != null) {
                    new StringBuilder(ANR_HAPPENED_BEGIN).append(anrExceptionMessage);
                }
                g.a((com.kwad.sdk.crash.report.e)object, TAG, file2);
                object = new File(file, "meminfo");
                g.I((File)object);
            }
            catch (Throwable throwable) {}
            if (AnrHandler.getInstance().mExceptionListener != null) {
                AnrHandler.getInstance().mExceptionListener.a(AnrHandler.getInstance().getCrashType(), anrExceptionMessage);
            }
            AnrHandler.getInstance().uploadRemainingExceptions();
            AnrHandler.notifyJavaDumpDone();
            AnrHandler.getAnrReason(string2, file);
            return;
        }
        catch (Throwable throwable) {
            anrExceptionMessage.mErrorMessage = anrExceptionMessage.mErrorMessage + throwable;
            c.printStackTraceOnly(throwable);
            return;
        }
    }

    private static void getAnrReason(@Nullable String string2, File file) {
        c.d(TAG, "ANR getAnrReasonInner");
        com.kwad.sdk.crash.report.e e2 = AnrHandler.getInstance().getUploader();
        try {
            Object object;
            if (string2 != null) {
                long l2 = new File(string2).lastModified();
                if (Math.abs(l2 - sLastTime) < 10000L) {
                    return;
                }
                sLastTime = l2;
            }
            ActivityManager activityManager = (ActivityManager)e.Lr().getContext().getSystemService("activity");
            ActivityManager.ProcessErrorStateInfo processErrorStateInfo = null;
            boolean bl2 = false;
            if (activityManager == null) {
                return;
            }
            int n2 = 0;
            while ((long)n2 < 20L) {
                object = activityManager.getProcessesInErrorState();
                if (object != null) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        ActivityManager.ProcessErrorStateInfo processErrorStateInfo2 = (ActivityManager.ProcessErrorStateInfo)object.next();
                        if (processErrorStateInfo2.condition != 2) continue;
                        processErrorStateInfo = processErrorStateInfo2;
                        break;
                    }
                }
                if (Build.VERSION.SDK_INT > 33 && !bl2 && (object = activityManager.getRunningAppProcesses()) != null) {
                    boolean bl3 = true;
                    object = object.iterator();
                    while (object.hasNext()) {
                        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                        if (runningAppProcessInfo.pid != Process.myPid()) continue;
                        bl3 = false;
                        break;
                    }
                    if (bl3) {
                        c.i(TAG, "anr did happen on android14");
                        object = new File(file, "anr_happened");
                        g.a((File)object, (CharSequence)"anr did happen", false);
                        bl2 = true;
                    }
                }
                if (processErrorStateInfo != null) break;
                Thread.sleep(500L);
                ++n2;
            }
            if (processErrorStateInfo == null) {
                return;
            }
            if (processErrorStateInfo.pid != MY_PID) {
                if (e2 != null) {
                    new StringBuilder("other process anr:\n").append(processErrorStateInfo.shortMsg);
                }
                return;
            }
            AnrReason anrReason = new AnrReason();
            new AnrReason().mTag = processErrorStateInfo.tag;
            anrReason.mShortMsg = processErrorStateInfo.shortMsg;
            anrReason.mLongMsg = processErrorStateInfo.longMsg;
            object = new File(file, "anr_reason");
            c.i(TAG, "anr reason: " + anrReason.toJson().toString());
            g.a((File)object, anrReason.toJson().toString());
            return;
        }
        catch (Throwable throwable) {
            if (e2 != null) {
            }
            return;
        }
    }

    @Override
    protected final int getCrashType() {
        return 3;
    }

    @Override
    protected final void reportException(@NonNull File[] fileArray, @Nullable CountDownLatch countDownLatch) {
        com.kwad.sdk.crash.report.b b2 = new com.kwad.sdk.crash.report.b();
        b2.a(this.getUploader());
        for (File file : fileArray) {
            b2.a(file, countDownLatch);
        }
    }

    public static native void install(String var0, int var1);

    public static native boolean getStackTraceCrashOccured();

    public static native void notifyJavaDumpDone();

    static final class a {
        private static final AnrHandler aPc = new AnrHandler();
    }
}

