/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.crash.handler;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.Process;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.kwad.sdk.core.d.c;
import com.kwad.sdk.crash.e;
import com.kwad.sdk.crash.handler.b;
import com.kwad.sdk.crash.model.message.ExceptionMessage;
import com.kwad.sdk.crash.model.message.NativeExceptionMessage;
import com.kwad.sdk.crash.report.g;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;

@Keep
public final class NativeCrashHandler
extends b {
    private static final String TAG = "NativeCrashHandler";
    private static final String NATIVE_CRASH_HAPPENED_BEGIN = "------ Native Crash Happened Begin ------\n";
    private static ExceptionMessage mMessage = new NativeExceptionMessage();
    private File mMessageFile;

    public static NativeCrashHandler getInstance() {
        return a.aPh;
    }

    private NativeCrashHandler() {
    }

    @Override
    protected final int getCrashType() {
        return 4;
    }

    public final void init(@NonNull File file, boolean bl2, final @NonNull String string2, com.kwad.sdk.crash.report.c c2) {
        super.init(file, null, c2);
        if (!com.kwad.sdk.crash.b.La()) {
            return;
        }
        this.mLogDir = file;
        if (!this.mLogDir.exists()) {
            this.mLogDir.mkdirs();
        }
        this.mDumpDir = new File(file, FILE_NAME_BASE + "-native-0");
        this.mLogcatFile = new File(this.mDumpDir, "logcat");
        this.mMessageFile = new File(this.mDumpDir, "message");
        this.mJavaTraceFile = new File(this.mDumpDir, "all_java_backtrace");
        this.mMemoryInfoFile = new File(this.mDumpDir, "meminfo");
        try {
            if (Build.VERSION.SDK_INT < 23) {
                file = new Handler(Looper.getMainLooper());
                file.post(new Runnable(){

                    @Override
                    public final void run() {
                        c.e(NativeCrashHandler.TAG, "native install in main:" + NativeCrashHandler.this.mDumpDir.getPath());
                        NativeCrashHandler.install(NativeCrashHandler.this.mDumpDir.getPath(), string2, Build.VERSION.SDK_INT);
                    }
                });
                return;
            }
            Looper.getMainLooper().getQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                public final boolean queueIdle() {
                    c.d(NativeCrashHandler.TAG, "native install in idle" + NativeCrashHandler.this.mDumpDir.getPath());
                    NativeCrashHandler.install(NativeCrashHandler.this.mDumpDir.getPath(), string2, Build.VERSION.SDK_INT);
                    return false;
                }
            });
        }
        catch (Throwable throwable) {
            this.getUploader();
        }
    }

    public static native void install(@NonNull String var0, @NonNull String var1, int var2);

    public static native void doCrash();

    public static native void doFakeCrash();

    public static native void doNativeFdOverLimitCrash();

    public static native void doMemoryCorruption();

    /*
     * Loose catch block
     */
    @Keep
    public static synchronized void onCallFromNative(long l2) {
        c.e(TAG, "onCallFromNative");
        isExceptionHappened.set(true);
        sCrashingPid = String.valueOf(Process.myPid());
        Serializable serializable = NativeCrashHandler.getInstance().mLogDir;
        File file = NativeCrashHandler.getInstance().mLogcatFile;
        File file2 = NativeCrashHandler.getInstance().mMessageFile;
        File file3 = NativeCrashHandler.getInstance().mJavaTraceFile;
        File file4 = NativeCrashHandler.getInstance().mMemoryInfoFile;
        com.kwad.sdk.crash.report.e e2 = NativeCrashHandler.getInstance().getUploader();
        if (!((File)serializable).exists() && !((File)serializable).mkdirs()) {
            NativeCrashHandler.mMessage.mErrorMessage = NativeCrashHandler.mMessage.mErrorMessage + "create " + ((File)serializable).getPath() + " failed!\n";
            if (e2 != null) {
                mMessage.toJson();
            }
        }
        if (!NativeCrashHandler.getInstance().mDumpDir.exists() && !NativeCrashHandler.getInstance().mDumpDir.mkdirs()) {
            NativeCrashHandler.mMessage.mErrorMessage = NativeCrashHandler.mMessage.mErrorMessage + "create " + NativeCrashHandler.getInstance().mDumpDir.getPath() + " failed!\n";
            if (e2 != null) {
                mMessage.toJson();
            }
        }
        if (file == null) {
            file = new File(NativeCrashHandler.getInstance().mDumpDir, "logcat");
        }
        if (file2 == null) {
            file2 = new File(NativeCrashHandler.getInstance().mDumpDir, "message");
        }
        if (file3 == null) {
            file3 = new File(NativeCrashHandler.getInstance().mDumpDir, "all_java_backtrace");
        }
        if (file4 == null) {
            file4 = new File(NativeCrashHandler.getInstance().mDumpDir, "meminfo");
        }
        com.kwad.sdk.crash.utils.g.b(null, mMessage, e.Lr().getContext());
        com.kwad.sdk.crash.utils.g.a(mMessage, NativeCrashHandler.getInstance().getCrashType());
        NativeCrashHandler.mMessage.mLogUUID = com.kwad.sdk.crash.utils.g.fU(NativeCrashHandler.getInstance().mDumpDir.getName());
        try {
            if (file2 != null) {
                c.e(TAG, "onCallFromNative write message " + mMessage.toJson().toString());
                com.kwad.sdk.crash.utils.g.a(file2, mMessage.toJson().toString());
            }
            com.kwad.sdk.crash.utils.g.H(file3);
            NativeCrashHandler.getInstance().backupLogFiles((File)serializable);
            com.kwad.sdk.crash.utils.g.a(e2, TAG, NativeCrashHandler.getInstance().mDumpDir);
            NativeCrashHandler.getInstance().uploadRemainingExceptions();
            com.kwad.sdk.crash.utils.g.I(file4);
            com.kwad.sdk.crash.utils.g.F(file);
            if (NativeCrashHandler.getInstance().mExceptionListener != null) {
                NativeCrashHandler.getInstance().mExceptionListener.a(NativeCrashHandler.getInstance().getCrashType(), mMessage);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            c.printStackTraceOnly(throwable);
            if (e2 != null) {
                com.kwad.sdk.crash.utils.g.r(throwable2);
            }
            return;
        }
        catch (Throwable throwable) {
            try {
                NativeCrashHandler.mMessage.mErrorMessage = NativeCrashHandler.mMessage.mErrorMessage + throwable;
                c.d("AnrAndNativeAdExceptionCollector", Log.getStackTraceString((Throwable)throwable));
            }
            catch (Throwable throwable3) {
                block26: {
                    try {
                        if (file2 != null) {
                            c.e(TAG, "onCallFromNative write message " + mMessage.toJson().toString());
                            com.kwad.sdk.crash.utils.g.a(file2, mMessage.toJson().toString());
                        }
                        com.kwad.sdk.crash.utils.g.H(file3);
                        NativeCrashHandler.getInstance().backupLogFiles((File)serializable);
                        com.kwad.sdk.crash.utils.g.a(e2, TAG, NativeCrashHandler.getInstance().mDumpDir);
                        NativeCrashHandler.getInstance().uploadRemainingExceptions();
                        com.kwad.sdk.crash.utils.g.I(file4);
                        com.kwad.sdk.crash.utils.g.F(file);
                        if (NativeCrashHandler.getInstance().mExceptionListener != null) {
                            NativeCrashHandler.getInstance().mExceptionListener.a(NativeCrashHandler.getInstance().getCrashType(), mMessage);
                        }
                    }
                    catch (Throwable throwable4) {
                        serializable = throwable4;
                        c.printStackTraceOnly(throwable4);
                        if (e2 == null) break block26;
                        com.kwad.sdk.crash.utils.g.r((Throwable)serializable);
                    }
                }
                throw throwable3;
            }
            try {
                if (file2 != null) {
                    c.e(TAG, "onCallFromNative write message " + mMessage.toJson().toString());
                    com.kwad.sdk.crash.utils.g.a(file2, mMessage.toJson().toString());
                }
                com.kwad.sdk.crash.utils.g.H(file3);
                NativeCrashHandler.getInstance().backupLogFiles((File)serializable);
                com.kwad.sdk.crash.utils.g.a(e2, TAG, NativeCrashHandler.getInstance().mDumpDir);
                NativeCrashHandler.getInstance().uploadRemainingExceptions();
                com.kwad.sdk.crash.utils.g.I(file4);
                com.kwad.sdk.crash.utils.g.F(file);
                if (NativeCrashHandler.getInstance().mExceptionListener != null) {
                    NativeCrashHandler.getInstance().mExceptionListener.a(NativeCrashHandler.getInstance().getCrashType(), mMessage);
                }
                return;
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                c.printStackTraceOnly(throwable5);
                if (e2 != null) {
                    com.kwad.sdk.crash.utils.g.r(throwable6);
                }
                return;
            }
        }
    }

    @Override
    protected final void reportException(@NonNull File[] fileArray, @Nullable CountDownLatch countDownLatch) {
        g g2 = new g();
        g2.a(this.getUploader());
        for (File file : fileArray) {
            g2.a(file, countDownLatch);
        }
    }

    static final class a {
        private static final NativeCrashHandler aPh = new NativeCrashHandler();
    }
}

