/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.crash.handler;

import android.content.Context;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.kwad.sdk.core.d.c;
import com.kwad.sdk.crash.e;
import com.kwad.sdk.crash.f;
import com.kwad.sdk.utils.SystemUtil;
import com.kwad.sdk.utils.w;
import com.kwad.sdk.utils.z;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class b {
    public static final String TAG = "ANR_Native_ExceptionHandler";
    public static final String FILE_NAME_BASE = b.getBaseDir();
    private static final int REAL_TIME_UPLOAD_THRESHOLD = 2;
    public static File sBackupDir;
    protected f mExceptionListener;
    protected AtomicInteger mIndex = new AtomicInteger();
    protected File mLogDir;
    protected File mDumpDir;
    protected File mLogcatFile;
    protected File mMessageFile;
    protected File mJavaTraceFile;
    protected File mMemoryInfoFile;
    protected com.kwad.sdk.crash.report.e mUploader;
    public static AtomicBoolean isExceptionHappened;
    public static String sCrashingPid;

    public void init(File file, f f2, com.kwad.sdk.crash.report.e e2) {
        this.mLogDir = file;
        if (!this.mLogDir.exists()) {
            this.mLogDir.mkdirs();
        }
        this.mDumpDir = new File(this.mLogDir, FILE_NAME_BASE + "-" + this.mIndex + ".dump");
        this.mLogcatFile = new File(this.mLogDir, FILE_NAME_BASE + "-" + this.mIndex + ".log");
        this.mJavaTraceFile = new File(this.mLogDir, FILE_NAME_BASE + "-" + this.mIndex + ".jtrace");
        this.mMemoryInfoFile = new File(this.mLogDir, FILE_NAME_BASE + "-" + this.mIndex + ".minfo");
        this.mExceptionListener = f2;
        this.mUploader = e2;
    }

    public static void initBackupDir(File file) {
        sBackupDir = file;
        if (!sBackupDir.exists()) {
            sBackupDir.mkdirs();
        }
    }

    public f getCrashListener() {
        return this.mExceptionListener;
    }

    public final com.kwad.sdk.crash.report.e getUploader() {
        return this.mUploader;
    }

    void uploadRemainingExceptions() {
        Object object = this.mLogDir.listFiles(new FileFilter(){

            @Override
            public final boolean accept(File file) {
                return file.getName().endsWith(".dump");
            }
        });
        if (object != null && ((File[])object).length > 2) {
            CountDownLatch countDownLatch = new CountDownLatch(((File[])object).length);
            this.reportException((File[])object, countDownLatch);
            try {
                countDownLatch.await(5L, TimeUnit.SECONDS);
                return;
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                c.printStackTraceOnly(interruptedException);
            }
        }
    }

    void backupLogFiles(File serializable) {
        if (sBackupDir == null) {
            return;
        }
        if (!sBackupDir.exists()) {
            sBackupDir.mkdirs();
        }
        try {
            w.g(serializable.getParentFile().getParentFile(), sBackupDir);
            return;
        }
        catch (IOException iOException) {
            serializable = iOException;
            c.printStackTraceOnly(iOException);
            return;
        }
    }

    private static String getBaseDir() {
        try {
            Context context = e.Lr().getContext();
            if (context == null) {
                c.e(TAG, "getBaseDir() but getInstance().getContext() is null");
                context = z.Dl();
            }
            if (context != null) {
                String string2 = SystemUtil.getProcessName(context);
                if (TextUtils.isEmpty((CharSequence)string2) || SystemUtil.isInMainProcess(context)) {
                    string2 = "main";
                } else if (string2 != null && string2.startsWith(context.getPackageName() + ":")) {
                    string2 = string2.substring(context.getPackageName().length() + 1);
                }
                return string2 + "-" + Process.myPid() + "-" + UUID.randomUUID().toString();
            }
            c.e(TAG, "getBaseDir() but context is null");
            return UUID.randomUUID().toString();
        }
        catch (Throwable throwable) {
            c.T(TAG, Log.getStackTraceString((Throwable)throwable));
            return UUID.randomUUID().toString();
        }
    }

    protected abstract int getCrashType();

    protected abstract void reportException(@NonNull File[] var1, @Nullable CountDownLatch var2);

    static {
        isExceptionHappened = new AtomicBoolean(false);
        sCrashingPid = "#####";
    }
}

