/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.crash.model.message;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kwad.sdk.core.c.b;
import com.kwad.sdk.core.d.c;
import com.kwad.sdk.crash.model.message.JavaExceptionMessage;
import com.kwad.sdk.crash.utils.i;
import com.kwad.sdk.crash.utils.j;
import com.kwad.sdk.utils.aa;
import java.io.Serializable;
import org.json.JSONObject;

public abstract class ExceptionMessage
implements com.kwad.sdk.core.b,
Serializable {
    private static final long serialVersionUID = -5338556142957298914L;
    public String mCrashDetail = "Unknown";
    public String mMemoryInfo = "Unknown";
    public String mDiskInfo = "Unknown";
    public String mProcessName = "Unknown";
    public int mExceptionType = 0;
    public String mCrashType = this.getTypeCommon();
    public String mThreadName = "Unknown";
    public String mIsAppOnForeground = "Unknown";
    public String mLogUUID = "Unknown";
    public String mVirtualApp = "Unknown";
    public String mCustomMsg = "Unknown";
    public String mThreadOverflow = "Unknown";
    public String mFdOverflow = "Unknown";
    public String mTaskId = "Unknown";
    public String mErrorMessage = "";
    public long mCurrentTimeStamp;
    public long mUsageTimeMills;
    public int mPid;
    public int mTid;
    public String mVersionCode = "Unknown";
    public boolean mVersionConflict = false;
    public String mAppVersionBeforeLastUpload = "Unknown";
    public String mJNIError = "";
    public String mGCInfo = "";
    public String mLockInfo = "";
    public String mMonitorInfo = "";
    public String mSlowLooper = "";
    public String mSlowOperation = "";
    public String mBuildConfigInfo = "";
    public String mAbi = "Unknown";
    public String mDumpsys = "";
    public int mCrashSource = 0;

    protected abstract String getTypePrefix();

    public final String getTypeCommon() {
        return this.getTypePrefix() + "COMMON";
    }

    public final String getTypeHeapOOM() {
        return this.getTypePrefix() + "HEAP_OOM";
    }

    public final String getTypeThreadOOM() {
        return this.getTypePrefix() + "THREAD_OOM";
    }

    public final String getTypeFdOOM() {
        return this.getTypePrefix() + "FD_OOM";
    }

    @Override
    public void parseJson(@Nullable JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        this.mCrashDetail = jSONObject.optString("mCrashDetail");
        this.mMemoryInfo = jSONObject.optString("mMemoryInfo");
        this.mDiskInfo = jSONObject.optString("mDiskInfo");
        this.mProcessName = jSONObject.optString("mProcessName");
        this.mCrashType = jSONObject.optString("mCrashType");
        this.mThreadName = jSONObject.optString("mThreadName");
        this.mIsAppOnForeground = jSONObject.optString("mIsAppOnForeground");
        this.mLogUUID = jSONObject.optString("mLogUUID");
        this.mVirtualApp = jSONObject.optString("mVirtualApp");
        this.mCustomMsg = jSONObject.optString("mCustomMsg");
        this.mThreadOverflow = jSONObject.optString("mThreadOverflow");
        this.mFdOverflow = jSONObject.optString("mFdOverflow");
        this.mTaskId = jSONObject.optString("mTaskId");
        this.mErrorMessage = jSONObject.optString("mErrorMessage");
        this.mCurrentTimeStamp = jSONObject.optLong("mCurrentTimeStamp");
        this.mUsageTimeMills = jSONObject.optLong("mUsageTimeMills");
        this.mPid = jSONObject.optInt("mPid");
        this.mTid = jSONObject.optInt("mTid");
        this.mVersionCode = jSONObject.optString("mVersionCode");
        this.mVersionConflict = jSONObject.optBoolean("mVersionConflict");
        this.mAppVersionBeforeLastUpload = jSONObject.optString("mAppVersionBeforeLastUpload");
        this.mJNIError = jSONObject.optString("mJNIError");
        this.mGCInfo = jSONObject.optString("mGCInfo");
        this.mLockInfo = jSONObject.optString("mLockInfo");
        this.mMonitorInfo = jSONObject.optString("mMonitorInfo");
        this.mSlowLooper = jSONObject.optString("mSlowLooper");
        this.mSlowOperation = jSONObject.optString("mSlowOperation");
        this.mBuildConfigInfo = jSONObject.optString("mBuildConfigInfo");
        this.mAbi = jSONObject.optString("mAbi");
        this.mDumpsys = jSONObject.optString("mDumpsys");
        this.mCrashSource = jSONObject.optInt("mCrashSource");
    }

    private void setIsForeground() {
        try {
            b.Ho();
            this.mIsAppOnForeground = b.isAppOnForeground() ? "Foreground" : "Background";
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        aa.putValue(jSONObject, "mCrashDetail", this.mCrashDetail);
        aa.putValue(jSONObject, "mMemoryInfo", this.mMemoryInfo);
        aa.putValue(jSONObject, "mDiskInfo", this.mDiskInfo);
        aa.putValue(jSONObject, "mProcessName", this.mProcessName);
        aa.putValue(jSONObject, "mCrashType", this.mCrashType);
        aa.putValue(jSONObject, "mThreadName", this.mThreadName);
        this.setIsForeground();
        aa.putValue(jSONObject, "mIsAppOnForeground", this.mIsAppOnForeground);
        aa.putValue(jSONObject, "mLogUUID", this.mLogUUID);
        aa.putValue(jSONObject, "mVirtualApp", this.mVirtualApp);
        aa.putValue(jSONObject, "mCustomMsg", this.mCustomMsg);
        aa.putValue(jSONObject, "mThreadOverflow", this.mThreadOverflow);
        aa.putValue(jSONObject, "mFdOverflow", this.mFdOverflow);
        aa.putValue(jSONObject, "mTaskId", this.mTaskId);
        aa.putValue(jSONObject, "mErrorMessage", this.mErrorMessage);
        aa.putValue(jSONObject, "mCurrentTimeStamp", this.mCurrentTimeStamp);
        aa.putValue(jSONObject, "mUsageTimeMills", this.mUsageTimeMills);
        aa.putValue(jSONObject, "mPid", this.mPid);
        aa.putValue(jSONObject, "mTid", this.mTid);
        aa.putValue(jSONObject, "mVersionCode", this.mVersionCode);
        aa.putValue(jSONObject, "mVersionConflict", this.mVersionConflict);
        aa.putValue(jSONObject, "mAppVersionBeforeLastUpload", this.mAppVersionBeforeLastUpload);
        aa.putValue(jSONObject, "mJNIError", this.mJNIError);
        aa.putValue(jSONObject, "mGCInfo", this.mGCInfo);
        aa.putValue(jSONObject, "mLockInfo", this.mLockInfo);
        aa.putValue(jSONObject, "mMonitorInfo", this.mMonitorInfo);
        aa.putValue(jSONObject, "mSlowLooper", this.mSlowLooper);
        aa.putValue(jSONObject, "mSlowOperation", this.mSlowOperation);
        aa.putValue(jSONObject, "mBuildConfigInfo", this.mBuildConfigInfo);
        aa.putValue(jSONObject, "mAbi", this.mAbi);
        aa.putValue(jSONObject, "mDumpsys", this.mDumpsys);
        aa.putValue(jSONObject, "mCrashSource", this.mCrashSource);
        return jSONObject;
    }

    public String getThreadName() {
        return this.mThreadName;
    }

    public void setThreadName(String string2) {
        this.mThreadName = string2;
    }

    public int getTid() {
        return this.mTid;
    }

    public void setTid(int n2) {
        this.mTid = n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("\u5f02\u5e38\u72b6\u6001\u6c47\u603b:\nUUID: ").append(this.mLogUUID).append("\nCPU\u67b6\u6784: ").append(this.mAbi).append("\n\u5f02\u5e38\u8fdb\u7a0b: ").append(this.mProcessName).append(" (").append(this.mPid).append(")\n").append("\u5f02\u5e38\u7ebf\u7a0b: ").append(this.mThreadName).append(" (").append(this.mTid).append(")\n").append("\u5f02\u5e38\u7c7b\u578b: ").append(this.mCrashType).append("\n\u5e94\u7528\u591a\u5f00\u73af\u5883: ").append(this.mVirtualApp).append("\nTaskId: ").append(this.mTaskId).append("\nmTid: ").append(this.mTid).append("\n\u81ea\u5b9a\u4e49\u4fe1\u606f: ").append(this.mCustomMsg).append("\n\u524d\u540e\u53f0\u72b6\u6001: ").append(this.mIsAppOnForeground).append("\n\u5f02\u5e38\u53d1\u751f\u65f6\u95f4: ").append(i.aO(this.mCurrentTimeStamp)).append("\n\u7248\u672c\u53f7: ").append(this.mVersionCode).append("\n\u5347\u7ea7\u524d\u7248\u672c\u53f7: ").append(this.mAppVersionBeforeLastUpload).append("\n\u4f7f\u7528\u65f6\u957f: ").append(j.aP(this.mUsageTimeMills)).append("\n\u5f02\u5e38\u8be6\u60c5: \n");
            if (this instanceof JavaExceptionMessage) {
                stringBuilder.append(this.mCrashDetail.replace("##", "\n\t").replace("#", "\n"));
            } else {
                stringBuilder.append(this.mCrashDetail);
            }
            stringBuilder.append("\n\u78c1\u76d8\u8be6\u60c5: \n").append(this.mDiskInfo).append("\n");
            if (!TextUtils.isEmpty((CharSequence)this.mErrorMessage)) {
                stringBuilder.append("\u5f02\u5e38\u4e0a\u62a5Debug: \n").append(this.mErrorMessage).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mBuildConfigInfo)) {
                stringBuilder.append("BuildConfig\u4fe1\u606f: \n").append(this.mBuildConfigInfo).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mJNIError)) {
                stringBuilder.append("JNI\u5f02\u5e38: \n").append(this.mJNIError).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mGCInfo)) {
                stringBuilder.append("GC\u8017\u65f6: \n").append(this.mGCInfo).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mLockInfo)) {
                stringBuilder.append("\u9501\u8017\u65f6(dvm_lock_sample): \n").append(this.mLockInfo).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mMonitorInfo)) {
                stringBuilder.append("\u9501\u8017\u65f6(monitor): \n").append(this.mMonitorInfo).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mSlowLooper)) {
                stringBuilder.append("Looper\u8017\u65f6: \n").append(this.mSlowLooper).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mSlowOperation)) {
                stringBuilder.append("AMS\u8c03\u5ea6\u8017\u65f6: \n").append(this.mSlowOperation).append("\n");
            }
            stringBuilder.append("\u5185\u5b58\u8be6\u60c5: \n").append(this.mMemoryInfo).append("\n");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            c.printStackTraceOnly(throwable);
        }
        return stringBuilder.substring(0);
    }

    public String getReportMsg() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UUID=").append(this.mLogUUID).append(",crashTime=").append(i.aO(this.mCurrentTimeStamp)).append(",customMsg=").append(this.mCustomMsg);
        return stringBuilder.toString();
    }

    public static final String getSdkVersionNameSuffix(int n2) {
        String string2 = "";
        switch (n2) {
            case 1: {
                string2 = "-ad";
                break;
            }
            case 2: {
                string2 = "-ct";
                break;
            }
            case 3: {
                string2 = "-ec";
                break;
            }
            case 4: {
                string2 = "-pct";
                break;
            }
            case 5: {
                string2 = "-car";
            }
        }
        return string2;
    }

    public static final String getSdkCrashVersionName(String string2, int n2) {
        return string2 + "-" + n2;
    }
}

