/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.crash.model.message;

import java.io.Serializable;

public final class FastUnwindBackTraceElement
implements Serializable {
    private static final long serialVersionUID = -6763898640806477065L;
    public String declaringClass = "";
    public String methodName = "";
    public String fileName = "";
    public int lineNumber = 0;
    public String artMethod = "";
    public String pc = "";
    public String buildId = "";
    public boolean isNative = false;
    public String formatString = "";
    public boolean hasUnwind = false;
    public boolean isIgnore = false;
    public String threadInfo;
    public String costInfo;
    public long updateTime;
    public String tag;
    public int unwindFailReason;
    public long lastUpdateTime;

    public static FastUnwindBackTraceElement obtainFastUnwindBackTraceElement(Object object) {
        FastUnwindBackTraceElement fastUnwindBackTraceElement = new FastUnwindBackTraceElement("");
        if (object instanceof FastUnwindBackTraceElement) {
            fastUnwindBackTraceElement.updateTraceInfo((FastUnwindBackTraceElement)object);
        } else if (object instanceof StackTraceElement) {
            fastUnwindBackTraceElement.updateTraceInfo((StackTraceElement)object);
        }
        return fastUnwindBackTraceElement;
    }

    public FastUnwindBackTraceElement(String string2) {
        this.formatString = string2;
        this.hasUnwind = true;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.hasUnwind) {
            if (this.isNative) {
                return "native:" + this.pc;
            }
            return this.artMethod + ":" + this.pc;
        }
        if (this.formatString != null && !this.formatString.isEmpty()) {
            return this.formatString;
        }
        stringBuilder.append(this.declaringClass).append(".").append(this.methodName);
        if (this.lineNumber == -2) {
            stringBuilder.append("(Native Method)");
        } else if (this.fileName != null) {
            if (this.lineNumber >= 0) {
                stringBuilder.append("(").append(this.fileName).append(":").append(this.lineNumber).append(")");
            } else {
                stringBuilder.append("(").append(this.fileName).append(")");
            }
        } else if (this.lineNumber >= 0) {
            stringBuilder.append("(Unknown Source:").append(this.lineNumber).append(")");
        } else {
            stringBuilder.append("(Unknown Source)");
        }
        return stringBuilder.toString();
    }

    public final String toTraceString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.updateTime).append(this.tag);
        if (this.formatString != null && !this.formatString.isEmpty()) {
            stringBuilder.append(this.formatString).append(this.threadInfo).append(this.costInfo);
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(this.declaringClass).append(".").append(this.methodName);
        if (this.lineNumber == -2) {
            stringBuilder2.append("(Native Method)");
        } else if (this.fileName != null) {
            if (this.lineNumber >= 0) {
                stringBuilder2.append("(").append(this.fileName).append(":").append(this.lineNumber).append(")");
            } else {
                stringBuilder2.append("(").append(this.fileName).append(")");
            }
        } else if (this.lineNumber >= 0) {
            stringBuilder2.append("(Unknown Source:").append(this.lineNumber).append(")");
        } else {
            stringBuilder2.append("(Unknown Source)");
        }
        this.formatString = stringBuilder2.toString();
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(this.threadInfo).append(this.costInfo);
        return stringBuilder.toString();
    }

    public final void updateTraceInfo(FastUnwindBackTraceElement fastUnwindBackTraceElement) {
        this.artMethod = fastUnwindBackTraceElement.artMethod;
        this.pc = fastUnwindBackTraceElement.pc;
        this.declaringClass = fastUnwindBackTraceElement.declaringClass;
        this.methodName = fastUnwindBackTraceElement.methodName;
        this.fileName = fastUnwindBackTraceElement.fileName;
        this.lineNumber = fastUnwindBackTraceElement.lineNumber;
        this.formatString = fastUnwindBackTraceElement.formatString;
        this.buildId = fastUnwindBackTraceElement.buildId;
        this.isNative = fastUnwindBackTraceElement.isNative;
        this.hasUnwind = fastUnwindBackTraceElement.hasUnwind;
        this.isIgnore = fastUnwindBackTraceElement.isIgnore;
        this.unwindFailReason = fastUnwindBackTraceElement.unwindFailReason;
    }

    public final void updateTraceInfo(StackTraceElement stackTraceElement) {
        this.declaringClass = stackTraceElement.getClassName();
        this.methodName = stackTraceElement.getMethodName();
        this.fileName = stackTraceElement.getFileName();
        this.lineNumber = stackTraceElement.getLineNumber();
        this.hasUnwind = true;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FastUnwindBackTraceElement)) {
            return false;
        }
        object = (FastUnwindBackTraceElement)object;
        if (this.isNative) {
            return ((FastUnwindBackTraceElement)object).pc.equals(this.pc);
        }
        if (((FastUnwindBackTraceElement)object).artMethod == null) {
            return false;
        }
        return ((FastUnwindBackTraceElement)object).artMethod.equals(this.artMethod) && ((FastUnwindBackTraceElement)object).pc.equals(this.pc);
    }

    public final int hashCode() {
        if (this.isNative) {
            return this.pc.hashCode();
        }
        int n2 = 31 * this.artMethod.hashCode() + this.pc.hashCode();
        return n2;
    }

    public final boolean isEmpty() {
        if (this.isNative) {
            return this.pc == null || this.pc.isEmpty() || this.pc.equals("0");
        }
        return this.artMethod == null || this.artMethod.isEmpty() || this.artMethod.equals("0");
    }
}

