/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.crash.model.message;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kwad.sdk.core.b;
import com.kwad.sdk.core.d.c;
import com.kwad.sdk.crash.model.message.ThreadInfo;
import com.kwad.sdk.utils.aa;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MemoryInfo
implements b,
Serializable {
    private static final long serialVersionUID = -4944913077323984734L;
    public int mTotalMB;
    public int mAvailableMB;
    public int mJavaHeapLimitMB;
    public int mJavaHeapMB;
    public int mVssMB;
    public int mRssMB;
    public int mPssMB;
    public int mThreadsCount;
    public int mFdCount;
    public List<String> mFds = new ArrayList<String>();
    public List<ThreadInfo> mJavaThreads = new ArrayList<ThreadInfo>();
    public List<ThreadInfo> mNativeThreads = new ArrayList<ThreadInfo>();
    public List<ThreadInfo> mAllThreads = new ArrayList<ThreadInfo>();

    public MemoryInfo() {
    }

    public MemoryInfo(String object) {
        try {
            if (!TextUtils.isEmpty((CharSequence)object) && !"Unknown".equals(object)) {
                this.parseJson(new JSONObject(object));
            }
            return;
        }
        catch (JSONException jSONException) {
            object = jSONException;
            c.printStackTraceOnly(jSONException);
            return;
        }
    }

    @Override
    public void parseJson(@Nullable JSONObject object) {
        if (object == null) {
            return;
        }
        this.mTotalMB = object.optInt("mTotalMB");
        this.mAvailableMB = object.optInt("mAvailableMB");
        this.mJavaHeapLimitMB = object.optInt("mJavaHeapLimitMB");
        this.mJavaHeapMB = object.optInt("mJavaHeapMB");
        this.mVssMB = object.optInt("mVssMB");
        this.mRssMB = object.optInt("mRssMB");
        this.mPssMB = object.optInt("mPssMB");
        this.mThreadsCount = object.optInt("mThreadsCount");
        this.mFdCount = object.optInt("mFdCount");
        try {
            JSONArray jSONArray;
            ThreadInfo threadInfo;
            Object object2;
            JSONArray jSONArray2 = object.optJSONArray("mFds");
            if (jSONArray2 != null && jSONArray2.length() > 0) {
                for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                    String string2 = jSONArray2.optString(i2);
                    if (string2 == null || string2.isEmpty()) continue;
                    this.mFds.add(string2);
                }
            }
            if ((object2 = object.optJSONArray("mJavaThreads")) != null && object2.length() > 0) {
                for (int i3 = 0; i3 < object2.length(); ++i3) {
                    jSONArray2 = object2.optJSONObject(i3);
                    if (jSONArray2 == null) continue;
                    threadInfo = new ThreadInfo();
                    threadInfo.parseJson((JSONObject)jSONArray2);
                    this.mJavaThreads.add(threadInfo);
                }
            }
            if ((jSONArray = object.optJSONArray("mNativeThreads")) != null && jSONArray.length() > 0) {
                for (int i4 = 0; i4 < jSONArray.length(); ++i4) {
                    threadInfo = jSONArray.optJSONObject(i4);
                    if (threadInfo == null) continue;
                    object2 = new ThreadInfo();
                    object2.parseJson((JSONObject)threadInfo);
                    this.mNativeThreads.add((ThreadInfo)object2);
                }
            }
            if ((jSONArray2 = object.optJSONArray("mAllThreads")) != null && jSONArray2.length() > 0) {
                for (int i5 = 0; i5 < jSONArray2.length(); ++i5) {
                    object2 = jSONArray2.optJSONObject(i5);
                    if (object2 == null) continue;
                    object = new ThreadInfo();
                    object.parseJson((JSONObject)object2);
                    this.mAllThreads.add((ThreadInfo)object);
                }
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            c.printStackTraceOnly(exception);
            return;
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        aa.putValue(jSONObject, "mTotalMB", this.mTotalMB);
        aa.putValue(jSONObject, "mAvailableMB", this.mAvailableMB);
        aa.putValue(jSONObject, "mJavaHeapLimitMB", this.mJavaHeapLimitMB);
        aa.putValue(jSONObject, "mJavaHeapMB", this.mJavaHeapMB);
        aa.putValue(jSONObject, "mVssMB", this.mVssMB);
        aa.putValue(jSONObject, "mRssMB", this.mRssMB);
        aa.putValue(jSONObject, "mPssMB", this.mPssMB);
        aa.putValue(jSONObject, "mThreadsCount", this.mThreadsCount);
        aa.putValue(jSONObject, "mFdCount", this.mFdCount);
        aa.putValue(jSONObject, "mFds", this.mFds);
        aa.putValue(jSONObject, "mJavaThreads", this.mJavaThreads);
        aa.putValue(jSONObject, "mNativeThreads", this.mNativeThreads);
        aa.putValue(jSONObject, "mAllThreads", this.mAllThreads);
        return jSONObject;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t\u603bRAM\u5bb9\u91cf: ").append(this.mTotalMB).append(" (MB)\n\t\u5269\u4f59RAM\u5bb9\u91cf: ").append(this.mAvailableMB).append(" (MB)\n\t\u672c\u8fdb\u7a0bJava\u5806\u4e0a\u9650: ").append(this.mJavaHeapLimitMB).append(" (MB)\n\t\u672c\u8fdb\u7a0bJava\u5806\u5df2\u4f7f\u7528: ").append(this.mJavaHeapMB).append(" (MB)\n\t\u865a\u62df\u5730\u5740\u7a7a\u95f4\u5df2\u4f7f\u7528Vss: ").append(this.mVssMB).append(" (MB)\n\t\u5b9e\u9645\u7a7a\u95f4\u4f7f\u7528\u91cf(\u5305\u542b\u5171\u4eab\u5e93) Rss: ").append(this.mRssMB).append(" (MB)\n\t\u5b9e\u9645\u7a7a\u95f4\u4f7f\u7528\u91cf(\u5171\u4eab\u5e93\u5df2\u7ecf\u5747\u644a)(\u9ad8\u5185\u5b58\u6740\u8fdb\u7a0b\u7684\u4f9d\u636e\uff09Pss: ").append(this.mPssMB).append(" (MB)\n\t\u6253\u5f00\u6587\u4ef6\u63cf\u8ff0\u7b26\u6570: ").append(this.mFdCount).append("\n");
        if (this.mFds.size() > 0) {
            stringBuilder.append("\t\u6587\u4ef6\u63cf\u8ff0\u7b26\u8be6\u60c5: \n");
            for (String object : this.mFds) {
                stringBuilder.append("\t").append(object).append("\n");
            }
        }
        stringBuilder.append("\t\u6b63\u5728\u8fd0\u884c\u7ebf\u7a0b\u6570: ").append(this.mThreadsCount).append("\tJava: ").append(this.mJavaThreads.size()).append("\tNative: ").append(this.mThreadsCount - this.mJavaThreads.size()).append("\n\n");
        if (this.mAllThreads.size() > 0) {
            stringBuilder.append("\t\u5168\u90e8\u7ebf\u7a0b\u540d: \n");
            for (ThreadInfo threadInfo : this.mAllThreads) {
                stringBuilder.append("\t").append(threadInfo.mName).append("\n");
            }
        }
        if (this.mJavaThreads.size() > 0) {
            stringBuilder.append("Java\u7ebf\u7a0b\u5806\u6808: \n");
            for (ThreadInfo threadInfo : this.mJavaThreads) {
                stringBuilder.append(threadInfo.mName).append("\n").append(threadInfo.mTrace.replace("#", "\n")).append("\n");
            }
        }
        if (this.mNativeThreads.size() > 0) {
            stringBuilder.append("\tNative\u7ebf\u7a0b\u5806\u6808: \n");
            for (ThreadInfo threadInfo : this.mNativeThreads) {
                stringBuilder.append("\t").append(threadInfo.mName).append("\t(tid=").append(threadInfo.mTid).append(", index=").append(threadInfo.mIndex).append("):\n").append(threadInfo.mTrace);
            }
        }
        return stringBuilder.substring(0);
    }
}

